﻿using Farakonesh.Commands.Services;
using Farakonesh.Models.API.Zarinpal;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IApp.IPPG
{
    public interface IZarinpalService
    {
        Task<DBResult> getPayByFilter(InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken);
        Task<DBResult> startPay(StartPayOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> startPayPublic(StartPayPublicOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> verifyPay(VerifyPayOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> startPayChargeWallet(StartPayChargeWalletCommand command, CancellationToken cancellationToken);
        Task<DBResult> verifyChargeWallet(VerifyPayChargeCommand command, CancellationToken cancellationToken);
        Task<DBResult<List<ResponsePurchasesZarinpalPPGUnverifiedItemsData>>> getUnverifiedPay(GetUnverifiedPayZarinpalCommand command, CancellationToken cancellationToken, bool checkJobToken = true);
        Task<bool> verifyAutoTransAction(VerifyAutoTransActionZarinpal command, CancellationToken cancellationToken);
        Task<DBResult> getPay(InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken);
    }
}
