﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IApp.IUser
{
    public interface IAuthServices
    {
        Task<DBResult> SendCodeInTelegram(SendCodeInTelegramCommand command, CancellationToken cancellationToken);
        Task<DBResult> Login(LoginCommand command, CancellationToken cancellationToken);
        Task<DBResult> LoginCompany(LoginCommand command, CancellationToken cancellationToken);
        Task<DBResult> Verify(VerifyCommand command, CancellationToken cancellationToken);
        Task<DBResult> VerifyByCompany(VerifyCompanyCommand command, CancellationToken cancellationToken);
        Task<DBResult> SendCodeInPanel(SendCodeInPanelCommand command, CancellationToken cancellationToken);
        Task<DBResult> SendCodeByCompany(SendCodeInCompanyCommand command, CancellationToken cancellationToken);
        Task<DBResult> ReSendCode(ReSendCodeCommand command, CancellationToken cancellationToken);
        Task<DBResult> SendCodeLogin(SendCodeLoginCommand command, CancellationToken cancellationToken);
        Task<DBResult> verifyGoogle(VerifyGoogleCommand command, CancellationToken cancellationToken);
        Task<DBResult> Refresh(RefreshTokenCommand command, CancellationToken cancellationToken);
        Task<DBResult> SendCodeByCompanyInPanel(SendCodeInCompanyCommand command, CancellationToken cancellationToken);
    }

}