﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IApp.IUser
{
    public interface IUserServices
    {
        Task JibitInquiryShahkar(JibitInquiryShahkarCommand command, IUserContext _context, CancellationToken cancellationToken);
        Task<DBResult> SaveNewUser(SaveNewUserCommand command, CancellationToken cancellationToken);
        Task<DBResult> UpdateUser(UpdateUserCommand command, CancellationToken cancellationToken);
        Task<DBResult> sendNewPassword(SendNewPasswordCommand command, CancellationToken cancellationToken);
        Task<DBResult> getFull(CancellationToken cancellationToken);
        Task<DBResult> getFullCompany(GetFullCompanyCommand command, CancellationToken cancellationToken);
        Task<DBResult> UpdateProfile(UpdateProfileCommand command, CancellationToken cancellationToken);
        Task<DBResult> checkBasicInformationByAdmin(CheckBasicInformationByAdminCommand command, CancellationToken cancellationToken);
        Task<DBResult> sendAlarmDiscountCodeByCompany(GetDiscountForAlarmByCompanyCommand command, CancellationToken cancellationToken);
        Task<DBResult> insertClientByCompany(InsertClientByCompanyCommand command, CancellationToken cancellationToken);
    }
}
