﻿using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Models.Database.Systems;
using Farakonesh.Models.SystemSetting;
using Farakonesh.Shared.Enums;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.ICache
{
    public interface IRedisContextService
    {
        Task<ResponseCache> GetWebserviceAsync(
      WebServiceType webServiceType,
      CancellationToken cancellationToken);
        Task<List<Get_Order_SettingList_WithoutToken.Outputs>> GetOrderSettingListWithoutTokenUseInTelegramAsync(int? moduleType, CancellationToken cancellationToken);
        Task<Get_Setting_WindowsService.Outputs> GetSettingWindowsServiceAsync(CancellationToken cancellationToken);
        Task<List<GetCurrencyList_Servant.Outputs>> GetCurrencyListServantAsync(GetCurrencyList_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<List<GetCountryList.Outputs>> GetCountryListAsync(GetCountryList.Inputs inputs, CancellationToken cancellationToken);
        Task<List<GetCurrencyList.Outputs>> GetCurrencyListAsync(GetCurrencyList.Inputs inputs, CancellationToken cancellationToken);
        Task<Get_Setting_Telegram.Outputs> GetSettingTelegramAsync(CancellationToken cancellationToken);
        Task<Get_Setting_Auth.Outputs> GetSettingAuthAsync(CancellationToken cancellationToken);
        Task<Get_Setting_Purchase_Verify.Outputs> GetSettingPurchaseAsync(CancellationToken cancellationToken);
        Task<Get_Config_User_Wallet_ByCustomer.Outputs> getSettingConfigWalletAsync(string token, CancellationToken cancellationToken);
        Task<Get_Setting_Email.Outputs> GetSettingEmailAsync(CancellationToken cancellationToken);
        Task<Get_Setting_SMS.Outputs> getSettingSmsAsync(CancellationToken cancellationToken);
        Task<Get_Setting_Basic_System.Outputs> GetSettingBasicSystemAsync(CancellationToken cancellationToken);
        Task<Get_Order_Setting.Outputs> getSettingOrderAsync(int? orderType, string token, CancellationToken cancellationToken);
        Task<Get_Order_Setting_WithoutToken.Outputs> getSettingOrderWithoutTokenAsync(int? orderType, Guid? orderId, CancellationToken cancellationToken);
    }
}
