﻿using Farakonesh.Shared.Enums;
using Farakonesh.Models.API.Nipoto.Response;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.API.Nipoto.Creating.Request;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Farakonesh.Models.API.Nipoto.Request;
using Farakonesh.Models.API.Nipoto.Deal.Response;

namespace Farakonesh.Logic.IServices.IRestRequest
{
    public interface IHttpRequestNipoto
    {
        Task<DBResult<FeeNipotoResponseModel>> GetFee(NipotoTokenType type, string accessToken, CancellationToken cancellationToken);
        Task<DBResult<MarketNipotoResponseModel>> GetMarket(NipotoTokenType type, string accessToken, CancellationToken cancellationToken);
        Task<DBResult<BalanceResponseNipotoModel>> GetBalance(NipotoTokenType type, string accessToken, BalanceRequestNipotoModel model, CancellationToken cancellationToken);
        Task<DBResult<InfoDepositResponseModel>> GetDepositById(NipotoTokenType type, string accessToken, string depositId, CancellationToken cancellationToken);
        Task<DBResult<CreateWalletResponseModel>> CreateWallet(NipotoTokenType type, string accessToken, CreateWalletRequestModel model, CancellationToken cancellationToken);
        Task<DBResult<LoginResponseNipotoModel>> GetToken(NipotoTokenType type, CancellationToken cancellationToken);
        Task<DBResult<List<InfoDepositResponseModel>>> GetDepositList(NipotoTokenType type, string accessToken, InfoDepositRequestModel model, CancellationToken cancellationToken);
    }
}
