﻿using Farakonesh.Models.API.ZarinLink;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IRestRequest
{
    public interface IHttpRequestZarinLink
    {
        Task<ResponseRefundZarinLink> AddRefund(RequestRefundZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseZarinLinkCurrentBalance> GetCurrentBalance(string terminalId, string server, string token, CancellationToken cancellationToken);
        Task<ResponseSetCardHolder> SetCardHolder(string trackingCode, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGetBankAccountZarinLink> getBankAccount(string server, string token, CancellationToken cancellationToken);
        Task<ResponseSettlementZarinLink> settlementZarinLinkSetting(RequestSettlementZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseCancelZarinLink> cancelZarinLink(RequestCancelZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGetTransactionByIdZarinLink> getTransactionByIdByZarinLinkId(RequestGetTransactionZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGetTransactionZarinLink> getTransactionListByZarinLinkId(RequestGetTransactionZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGetZarinLink> getZarinLinkById(RequestGetZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGenerateZarinLinkV2> generateZarinLinkV2(RequestGenerateZarinLinkV2 model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGenerateZarinLink> generateZarinLink(RequestGenerateZarinLink model, string server, string token, CancellationToken cancellationToken);
        Task<ResponseGetZarinLink> getZarinLink(RequestGetZarinLink model, string server, string token, CancellationToken cancellationToken);
    }
}
