﻿using Farakonesh.Logic.ISecurity;
using Farakonesh.Models.Database;
using Farakonesh.Shared.Helpers;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.Security.Claims;
using System.Text;

namespace Farakonesh.Logic.Security
{
    public class TokenGenerator : ITokenGenerator
    {
        private readonly ITokenUserService _tokenUserService;
        public TokenGenerator(ITokenUserService tokenUserService)
        {

            _tokenUserService = tokenUserService;

        }
        private const int TokenValidationHours = 24;

        public string Token { get; set; }
        public string RefreshToken { get; set; }
        public string UserId { get; set; }
        public bool? IsAccessAdmin { get; set; }
        public string Email { get; set; }
        public string Mobile { get; set; }
        public bool? IsAccessCompanyPanel { get; set; } = false;
        public string TokenJWT { get; set; }
        public string TokenJWTRefresh { get; set; }
        private Claim[] getClaims()
        {
            var rst = new Claim[]
            {
                new Claim(JwtRegisteredClaimNames.Jti, Guid.NewGuid().ToString()),
                new Claim(ClaimTypes.Name, this.Token),
                new Claim("UserId", this.UserId.ToString()),
                new Claim("IsAccessAdmin", this.IsAccessAdmin.ToString()),
                new Claim("IsAccessCompanyPanel", this.IsAccessCompanyPanel.ToString()),
            };

            return rst;
        }

        private Claim[] getClaimsRefresh()
        {
            var rst = new Claim[]
            {
                new Claim(JwtRegisteredClaimNames.Jti, Guid.NewGuid().ToString()),
                new Claim(ClaimTypes.Name, this.RefreshToken),
                new Claim("UserId", this.UserId.ToString())
            };

            return rst;
        }

        public DBResult getJWT(DateTime? expireDate = null)
        {
            //Get user claims
            var claims = getClaims();
            var claimsRefresh = getClaimsRefresh();
            //Set token expire date-time
            if (expireDate == null)
                expireDate = DateTimeHelper.GetLocalTime(add: TimeSpan.FromHours(TokenValidationHours));
            //Generate and set the JWT
            this.TokenJWT = _tokenUserService.generate(claims, expireDate.Value);

            this.TokenJWTRefresh = _tokenUserService.generate(claimsRefresh, expireDate.Value);
            //Return result as DBResult object
            return new DBResult(new { access_token = TokenJWT, refresh_token = TokenJWTRefresh, IsAccessAdmin = IsAccessAdmin, UserId = UserId }, 1);
        }
    }
}
