﻿using Farakonesh.Commands.Services;
using Farakonesh.Shared.Enums;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IApp.ICompany;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using System;
using System.Collections.Generic;
using Farakonesh.Shared.Helpers;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Company
{
    public class CompanyServices : ICompanyServices
    {
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        public CompanyServices(ISmsHelper ISmsHelper, IMailHelper iMailHelper)
        {
            _ISmsHelper = ISmsHelper;
            _IMailHelper = iMailHelper;

        }
        /// <summary>
        /// ارسال پیغام شارژ سود همکاری به صاحب شرکت
        /// </summary>
        /// <returns></returns>
        public async Task SendCommission(DoCompeleteCommand command, CancellationToken cancellationToken)
        {
            if (command.TransactionType != null && command.TransactionType > 0 && (command.Commission > 0 || command.CooperRewardToman > 0))
            {
                string transactionTypeSms = "سود_همکاری_در_فروش";
                string transactionTypeSubjet = $"واریز سود همکاری در فروش";
                string transactionTypeText = $"کاربر عزیز فراکنش ، مبلغ {command.CooperRewardToman.moneyFormat()} تومان به عنوان سود همکاری در فروش به کیف پول شما واریز گردید.";
                if (command.TransactionType == (int)TransactionType.ProfitCooperationSalesWithDiscountCode)
                {
                    transactionTypeSms = "سود_خرید_با_کد_تخفیف";
                    transactionTypeSubjet = $"واریز سود خرید با کد تخفیف";
                    transactionTypeText = $"کاربر عزیز فراکنش ، مبلغ {command.Commission.moneyFormat()} تومان به عنوان سود خرید با کد تخفیف به کیف پول شما واریز گردید.";
                }
                else if (command.TransactionType == (int)TransactionType.ProfitCooperationSales)
                {
                    transactionTypeSms = "سود_خرید_با_معرفی_مشتری";
                    transactionTypeSubjet = $"واریز سود خرید مشتری معرفی شده";
                    transactionTypeText = $"کاربر عزیز فراکنش ، مبلغ {command.Commission.moneyFormat()} تومان به عنوان سود خرید مشتری معرفی شده به کیف پول شما واریز گردید.";
                }

                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = transactionTypeSubjet,
                    Body = transactionTypeText,
                    Email = (command.TransactionType == (int)TransactionType.ProfitCooperationSalesWithDiscountCode || command.TransactionType == (int)TransactionType.ProfitCooperationSales) ? command.EmailCompanyUser : command.Email
                }, cancellationToken);

                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = (command.TransactionType == (int)TransactionType.ProfitCooperationSalesWithDiscountCode || command.TransactionType == (int)TransactionType.ProfitCooperationSales) ? command.MobileCompanyUser : command.Mobile,
                    Pattern = 61066,
                    Code = (command.TransactionType == (int)TransactionType.ProfitCooperationSalesWithDiscountCode || command.TransactionType == (int)TransactionType.ProfitCooperationSales) ? command.Commission.moneyFormat() : command.CooperRewardToman.moneyFormat(),
                    Code2 = transactionTypeSms
                }, cancellationToken);
            }

        }
    }
}
