﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.API.Nipoto.Creating.Request;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using System.Linq;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Wallet;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Models.Servant.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.HistoryDeposit;
using Farakonesh.Models.API.Nipoto.Request;
using Farakonesh.Models.API.Nipoto.Response;
using Farakonesh.Models.API.Nipoto.Deal.Response;
using Farakonesh.Logic.IServices.ICache;

namespace Farakonesh.Logic.Services.App.CryptoCurrency
{
    public class NipotoService : INipotoService
    {
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IOrderContext _IOrderContext;
        private readonly ICurrencyBlockChainContext _currencyBlockChainContext;
        private readonly IWalletBlockChainContext _walletBlockChainContext;
        private readonly IHistoryDepositBlockChainContext _historyDepositBlockChainContext;
        private readonly IPublicContext _IPublicContext;
        private readonly ISettingContext _ISettingContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly IQueueContext _IQueueContext;
        private readonly IHttpRequestNipoto _httpRequestNipoto;
        private readonly RedisService _redis;
        private readonly ITokenUserService _tokenUserService;
        private readonly IMailHelper _IMailHelper;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IRedisContextService _redisContextService;
        public NipotoService(IAutomaticOrderOperationService IAutomaticOrderOperationService
            , ISettingContext iSettingContext, IOrderContext iOrderContext
            , IPublicContext iPublicContext, ITransActionContext iTransActionContext
            , IQueueContext iQueueContext, RedisService redis, IHttpRequestNipoto httpRequestNipoto,
             ITokenUserService tokenUserService,
            ICurrencyBlockChainContext currencyBlockChainContext
            , IWalletBlockChainContext walletBlockChainContext, IMailHelper IMailHelper,
            ISmsHelper ISmsHelper, IHistoryDepositBlockChainContext historyDepositBlockChainContext
            , IRedisContextService redisContextService)
        {
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _ISettingContext = iSettingContext;
            _IOrderContext = iOrderContext;
            _IPublicContext = iPublicContext;
            _ITransActionContext = iTransActionContext;
            _redis = redis;
            _IQueueContext = iQueueContext;
            _httpRequestNipoto = httpRequestNipoto;
            _tokenUserService = tokenUserService;
            _currencyBlockChainContext = currencyBlockChainContext;
            _walletBlockChainContext = walletBlockChainContext;
            _IMailHelper = IMailHelper;
            _ISmsHelper = ISmsHelper;
            _historyDepositBlockChainContext = historyDepositBlockChainContext;
            _redisContextService = redisContextService;
        }

        public async Task<DBResult> startPay(StartPayOrderByCryptoCurrencyCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.PaymentCryptocurrency,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation,
            }, cancellationToken);
            if (allowedAmount != null && allowedAmount > 0)
            {
                dbResultOrder.Data.FinalAmount = allowedAmount;
            }
            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = true
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var settingOrder = await _redisContextService.getSettingOrderAsync(dbResultOrder.Data.OrderType, token, cancellationToken);

            if (settingOrder.IsActivePayByCryptoCurrency == null || settingOrder.IsActivePayByCryptoCurrency == false)
                throw new LogicalException("روش پرداخت با رمز ارز غیرفعال می باشد ، لطفا از روش دیگری برای پرداخت استفاده نمایید");

            var currencyModel = await _currencyBlockChainContext.Get_Currency(new Get_Currency.Inputs
            {
                MarketCode = command.MarketCode,
                NetworkId = command.NetworkId,
                Token = token
            }, cancellationToken);
            if (currencyModel == null || currencyModel.Data == null || !currencyModel.Data.Any())
            {
                throw new LogicalException("خطا در دریافت اطلاعات رمز ارز ، در صورت تکرار خطا مراتب را به پشتیبانان اطلاع دهید");
            }
            command.CurrencyId = currencyModel.Data?.FirstOrDefault()?.CurrencyId;
            var paymentId = Guid.NewGuid().ToString();

            var checkDuplicateWallet = await _walletBlockChainContext.Check_Validation_Wallet(new Check_Validation_Wallet.Inputs
            {
                CurrencyId = currencyModel.Data?.FirstOrDefault()?.CurrencyId
            ,
                NetworkId = currencyModel.Data?.FirstOrDefault()?.NetworkId,
                Token = token
            }, cancellationToken);
            if (checkDuplicateWallet.Data != null && checkDuplicateWallet.Data.WalletId != null)
            {
                var transactionResponse = await _ITransActionContext.Insert_TransactionCryptocurrency(new Insert_TransactionCryptocurrency.Inputs
                {
                    Code = command.Code,
                    OrderId = command.OrderId,
                    OnlinePortal = (int)OnlinePortal.Nipoto,
                    PaidCode = paymentId,
                    Token = token,
                    NetworkId = command.NetworkId,
                    PaidAmount = dbResultOrder.Data.FinalAmount,
                    CurrencyWalletId = command.CurrencyId
                }, cancellationToken);

                return new DBResult(new
                {
                    checkDuplicateWallet.Data.Address,
                    checkDuplicateWallet.Data.Currency,
                    checkDuplicateWallet.Data.NetworkCode,
                    checkDuplicateWallet.Data.MinimumAmount,
                    transactionResponse.Data.PaidAmount,
                    dbResultOrder.Data.OrderNumber,
                    checkDuplicateWallet.Data.Fee,
                    transactionResponse.Data.AmountCryptocurrency,
                    paymentId
                });
            }
            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseCreateWallet = await _httpRequestNipoto.CreateWallet(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , new CreateWalletRequestModel
                {
                    currency = currencyModel.Data.FirstOrDefault().MarketCode,
                    network = currencyModel.Data.FirstOrDefault().NetworkCode,
                    paymentID = paymentId
                }
            , cancellationToken);
            if (responseCreateWallet != null && responseCreateWallet.Data != null && !string.IsNullOrWhiteSpace(responseCreateWallet.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);

                responseCreateWallet = await _httpRequestNipoto.CreateWallet(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , new CreateWalletRequestModel
                {
                    currency = currencyModel.Data.FirstOrDefault().MarketCode,
                    network = currencyModel.Data.FirstOrDefault().NetworkCode
                }
                , cancellationToken);
            }

            var transactionNewResponse = await _ITransActionContext.Insert_TransactionCryptocurrency(new Insert_TransactionCryptocurrency.Inputs
            {
                Code = command.Code,
                OrderId = command.OrderId,
                OnlinePortal = (int)OnlinePortal.Nipoto,
                PaidCode = paymentId,
                Token = token,
                NetworkId = command.NetworkId,
                PaidAmount = dbResultOrder.Data.FinalAmount,
                WalletCode = responseCreateWallet.Data.walletID,
                Currency = responseCreateWallet.Data.currency,
                Network = responseCreateWallet.Data.network,
                WalletAddress = responseCreateWallet.Data.address,
                CurrencyWalletId = command.CurrencyId
            }, cancellationToken);

            return new DBResult(new
            {
                Address = responseCreateWallet.Data.address,
                Currency = responseCreateWallet.Data.currency,
                NetworkCode = responseCreateWallet.Data.network,
                checkDuplicateWallet.Data.MinimumAmount,
                transactionNewResponse.Data.PaidAmount,
                dbResultOrder.Data.OrderNumber,
                transactionNewResponse.Data.Fee,
                transactionNewResponse.Data.AmountCryptocurrency,
                paymentId
            });
        }



        public async Task<DBResult> checkPayByDeposit(string depositId, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetDepositById(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , depositId
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetDepositById(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , depositId
                , cancellationToken);
            }
            if (responseInfoDeposit.Data.statusCode == 404)
            {
                throw new ExternalServiceException("تراکنش مورد نظر واریز نشده است");
            }
            else if (responseInfoDeposit.Data.status == "done")
            {
                var responseDepositHistory = await _historyDepositBlockChainContext.Get_HistoryDepositByPayment(new Get_HistoryDepositByPayment.Inputs
                {
                    Token = token,
                    DepositId = depositId
                }, cancellationToken);
                return new DBResult(new { responseInfoDeposit.Data, History = responseDepositHistory.Data });
            }
            else if (responseInfoDeposit.Data.status == "processing")
            {
                throw new ExternalServiceException("تراکنش مورد نظر در حال پردازش است ، لطفا چند دقیقه دیگر مجددا بررسی بفرمایید");
            }

            throw new ExternalServiceException(responseInfoDeposit.Data.error);

        }

        public async Task<DBResult> getPayByDeposit(string depositId, CancellationToken cancellationToken)
        {
         
            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetDepositById(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , depositId
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetDepositById(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , depositId
                , cancellationToken);
            }

            var transactionUpdated = await _ITransActionContext.Update_TransactionCryptocurrency(new Update_TransactionCryptocurrency.Inputs
            {
                Address = responseInfoDeposit.Data.instrument,
                DepositId = depositId,
                Fee = responseInfoDeposit.Data.fee,
                AmountCryptoCurrency = responseInfoDeposit.Data.amount,
                Hash = responseInfoDeposit.Data.hash,
                HistoryDateTime = responseInfoDeposit.Data.createdAt,
                HumanId = responseInfoDeposit.Data.humanID,
                Sender = responseInfoDeposit.Data.sender,
                Status = responseInfoDeposit.Data.status == "done" ? (int)TransactionCryptoCurrencyStatus.SuccessfulDeposit : (int)TransactionCryptoCurrencyStatus.DepositNotReceived,
                Terminal = responseInfoDeposit.Data.terminal,
                TrackingCode = responseInfoDeposit.Data.trackingCode,
            }, cancellationToken);
            if (responseInfoDeposit.Data.status == "done")
            {

                if (transactionUpdated.Data.StatusOrder == 182)
                {
                    return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                    {
                        Email = transactionUpdated.Data.Email,
                        Mobile = transactionUpdated.Data.Mobile,
                        OrderId = transactionUpdated.Data.OrderId,
                        OrderNumber = transactionUpdated.Data.OrderNumber,
                        OrderType = transactionUpdated.Data.OrderType,
                        PurchaseId = transactionUpdated.Data.PaidCode,
                        StatusOrder = transactionUpdated.Data.StatusOrder,
                        Commission = transactionUpdated.Data.Commission,
                        EmailCompanyUser = transactionUpdated.Data.EmailCompanyUser,
                        MobileCompanyUser = transactionUpdated.Data.MobileCompanyUser,
                        TransactionType = transactionUpdated.Data.TransactionType,
                        CooperRewardToman = transactionUpdated.Data.CooperRewardToman,
                        NumberOfSuccessfulOrders = transactionUpdated.Data.NumberOfSuccessfulOrders,
                        FinalAmount = transactionUpdated.Data.FinalAmount.ToString(),
                        CompanyId = transactionUpdated.Data.CompanyOwnerId,
                        Setting = null,
                        PaidCode = transactionUpdated.Data.PaidCode,
                        TransactionCode = transactionUpdated.Data.TransactionCode,
                        TrackingCode = transactionUpdated.Data.TrackingCode
                    }, cancellationToken);
                }
                else
                {
                    string lessMore = "کمتر";
                    if (transactionUpdated.Data.MorePaid == true)
                    {
                        lessMore = "بیشتر";
                    }

                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"مغایرت در مبلغ واریز سفارش شماره #{transactionUpdated.Data.OrderNumber}",
                        Body = $"کاربر عزیز فراکنش ، مبلغی که به کیف پول ما واریز کرده اید {lessMore} از مبلغ فاکتور شماره {transactionUpdated.Data.OrderNumber}# می باشد ، لطفا منتظر بررسی و اعلام نتیجه از سمت کارشناسان ما بمانید ",
                        Email = transactionUpdated.Data.Email
                    }, cancellationToken);

                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = transactionUpdated.Data.Mobile,
                        Pattern = 61072,
                        Code = lessMore,
                        Code2 = transactionUpdated.Data.OrderNumber.ToString()
                    }, cancellationToken);
                }

            }
            return new DBResult();
        }


        public async Task<DBResult<List<InfoDepositResponseModel>>> getPayByDepositList(InfoDepositRequestModel model, CancellationToken cancellationToken)
        {
            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetDepositList(NipotoTokenType.Creating,
                dbResult.Data.NipotoCreatingAccessToken
                , model
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && responseInfoDeposit.Data.Count > 0 && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data[0].code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetDepositList(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , model
                , cancellationToken);
            }


            return new DBResult<List<InfoDepositResponseModel>>() { Data = responseInfoDeposit.Data };
        }

        public async Task<DBResult<BalanceResponseNipotoModel>> getBalance(BalanceRequestNipotoModel model, CancellationToken cancellationToken)
        {

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating,
                    cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetBalance(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , model
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetBalance(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , model
                , cancellationToken);
            }


            return new DBResult<BalanceResponseNipotoModel>() { Data = responseInfoDeposit.Data };
        }

        public async Task<DBResult<MarketNipotoResponseModel>> getMarketList(GetMarketListNipotoCommand command, CancellationToken cancellationToken, bool checkJobToken = true)
        {
            if (checkJobToken)
            {
                var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
                if (dbSetting.Data.JobToken != command.JobToken)
                {
                    throw new LogicalException("کلید اتصال نامعتبر می باشد");
                }
            }

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای دریافت لیست قیمت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetMarket(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای دریافت لیست قیمت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetMarket(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , cancellationToken);
            }


            return new DBResult<MarketNipotoResponseModel>() { Data = responseInfoDeposit.Data };
        }

        public async Task<DBResult<FeeNipotoResponseModel>> getFeeList(GetMarketListNipotoCommand command, CancellationToken cancellationToken, bool checkJobToken = true)
        {
            if (checkJobToken)
            {
                var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
                if (dbSetting.Data.JobToken != command.JobToken)
                {
                    throw new LogicalException("کلید اتصال نامعتبر می باشد");
                }
            }

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای دریافت لیست کارمزد ها ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetFee(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data.code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای دریافت لیست کارمزد ها ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetFee(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , cancellationToken);
            }
            return new DBResult<FeeNipotoResponseModel>() { Data = responseInfoDeposit.Data };
        }

        public async Task<DBResult> checkPay(InfoDepositRequestModel model, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var historyDeposit = await _historyDepositBlockChainContext.Get_HistoryDepositByPayment(new Get_HistoryDepositByPayment.Inputs
            {
                PaymentId = model.PaymentId,
                Token = token
            }, cancellationToken);
            if (historyDeposit != null && historyDeposit.Data != null && !string.IsNullOrWhiteSpace(historyDeposit.Data.HashDeposit))
            {
                return new DBResult(true);
            }
            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.NipotoCreatingWallet }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.NipotoCreatingAccessToken))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
                    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
            }
            var responseInfoDeposit = await _httpRequestNipoto.GetDepositList(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , model
            , cancellationToken);
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null && responseInfoDeposit.Data.Count > 0 && !string.IsNullOrWhiteSpace(responseInfoDeposit.Data[0].code))
            {
                var responseNipotoToken = await _httpRequestNipoto.GetToken(NipotoTokenType.Creating
    , cancellationToken);
                if (responseNipotoToken == null || string.IsNullOrWhiteSpace(responseNipotoToken.Data.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای ساخت کیف پول ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { NipotoCreatingAccessToken = responseNipotoToken.Data.accessToken }, cancellationToken);
                responseInfoDeposit = await _httpRequestNipoto.GetDepositList(NipotoTokenType.Creating, dbResult.Data.NipotoCreatingAccessToken
                , model
                , cancellationToken);
            }
            if (responseInfoDeposit != null && responseInfoDeposit.Data != null
                && responseInfoDeposit.Data.Count > 0)
            {
                var response = await getPayByDeposit(responseInfoDeposit.Data.FirstOrDefault()?.id, cancellationToken);
                return new DBResult(true);
            }

            return new DBResult(false);
        }
    }
}
