﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.JibitOcr;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App
{

    public class FileService : IFileService
    {

        private readonly IHttpRequestJibit _httpRequestJibit;
        private readonly IUserContext _iUserContext;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        public FileService(
            IHttpRequestJibit httpRequestJibit, IUserContext iUserContext, ITokenUserService tokenUserService,
            IRedisContextService redisContextService)
        {

            _httpRequestJibit = httpRequestJibit;
            _iUserContext = iUserContext;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
        }


        public async Task<DBResult> verifyFileNationalCard(VerifyFileNationalCardCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            bool isAccept = false;
            var dbResultUser = await _iUserContext.GetUser(new GetUser.Inputs { Token = token }, cancellationToken);
            if (string.IsNullOrWhiteSpace(dbResultUser.Data.NationalCode))
                throw new LogicalException("لطفا ابتدا کد ملی را وارد کنید");
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.OcrJibit, cancellationToken);
            if (webServiceInfo == null)
            {
                return new DBResult(new { ListId = command.FileId, IsAccept = isAccept }, 1);
            }
            var responseOcr = await _httpRequestJibit.getNationalCardOcrJibit(new RequestJibitOcr
            {
                BaseUrl = webServiceInfo.BaseUrlService,
                Token = webServiceInfo.RealApiKey,
                FileUrl = command.Url
            }, cancellationToken);

            if (responseOcr != null && responseOcr.data != null && !string.IsNullOrWhiteSpace(responseOcr.data.id_num) && responseOcr.data.id_num.ToEnglishNumbers().Equals(dbResultUser.Data.NationalCode))
            {
                isAccept = true;
                await _iUserContext.Insert_Document_Accept(new Insert_Document_Accept.Inputs
                {
                    FileId = command.FileId,
                    DocumentType = 136,
                    Title = "تصویر جلوی کارت ملی",
                    Token = token
                }, cancellationToken);
            }

            return new DBResult(new { ListId = command.FileId, IsAccept = isAccept }, 1);
        }



    }
}
