﻿using Newtonsoft.Json;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Order
{
    public class AlarmOrderService: IAlarmOrderService
    {
        private readonly IUserContext _IUserContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly IRedisContextService _redisContextService;
        private readonly ITokenUserService _tokenUserService;
        public AlarmOrderService(IUserContext IUserContext, IMailHelper iMailHelper,
            ISmsHelper iSmsHelper, ITokenUserService tokenUserService,
            IRedisContextService redisContextService)
        {
            _IUserContext = IUserContext;
            _IMailHelper = iMailHelper;
            _ISmsHelper = iSmsHelper;
            _redisContextService = redisContextService;
            _tokenUserService = tokenUserService;
        }

        public async Task<DBResult> sendAlarmOrder(AlarmOrderCommand command, CancellationToken cancellationToken)
        {

            var dbResultUser = await _IUserContext.GetUserByIdAdmin(new GetUserByIdAdmin.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                UserId = command.UserId
            },cancellationToken);

            await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"سفارش "+ command.OrderNumber.ToString()+"#",
                Body = $"کاربر عزیز ، یک سفارش جدید به شماره {command.OrderNumber}# برای شما ایجاد شده است ، لطفا جهت مشاهده جزئیات به پنل کاربری خود مراجعه فرمایید",
                Email = dbResultUser.Data.Email
            }, cancellationToken);


            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResultUser.Data.Mobile,
                Pattern = 61059,
                Code = command.OrderNumber.ToString()+"#"
            }, cancellationToken);



            return new DBResult();

        }

        public async Task<DBResult> sendLinkOrder(AlarmOrderCommand command, CancellationToken cancellationToken)
        {

            var dbResultUser = await _IUserContext.GetUserByIdAdmin(new GetUserByIdAdmin.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                UserId = command.UserId
            }, cancellationToken);
            
            var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);

            await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"سفارش " + command.OrderNumber.ToString() + "#",
                Body = $"کاربر عزیز ، یک سفارش جدید به شماره {command.OrderNumber}# برای شما ایجاد شده است ، لطفا جهت پرداخت روی لینک زیر کلیک نمائید : <br> <a href='{setting.SiteUrlRootPanel}payment?order={command.OrderNumber}' target='_blank'>لینک پرداخت فاکتور</a>",
                Email = dbResultUser.Data.Email
            }, cancellationToken);

            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResultUser.Data.Mobile,
                Pattern = 61058,
                Code = command.OrderNumber.ToString() + "#",
                Code2= "payment?order="+ command.OrderNumber
            }, cancellationToken);



            return new DBResult();

        }
    }
}
