﻿using Microsoft.AspNetCore.Mvc.Formatters;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Farakonesh.Commands.Queue;
using Farakonesh.Commands.Services;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.Database.Order;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.ICompany;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Shared.Helpers;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.API.Zarinpal;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Scenario;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.ComponentModel.Design;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using static Dapper.SqlMapper;
using Farakonesh.Logic.IServices.ICache;

namespace Farakonesh.Logic.Services.App
{
    public class AutomaticOrderOperationService : IAutomaticOrderOperationService
    {
        private readonly IHttpRequestPayeer _httpRequestPayeer;
        private readonly IOrderContext ctx;
        private readonly IRedisContextService _redisContextService;
        private readonly IGiftCardContext ctxGiftCard;
        private readonly ISettingContext settingctx;
        private readonly IPayeerContext _payeerContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly ICompanyServices _ICompanyServices;
        private readonly ISendCurrencyWareHouseQueue _sendCurrencyWareHouseQueue;
        private readonly IScenarioContext _scenarioContext;
        private readonly ITransActionContext _transActionContext;
        private readonly ITokenUserService _tokenUserService;
        private readonly IHttpRequestGeoLocation _httpRequestGeoLocation;
        private readonly IBankAccountContext _IBankAccountContext;
        public AutomaticOrderOperationService(IOrderContext ctx, ISettingContext settingctx
            , IGiftCardContext ctxGiftCard, IPayeerContext payeerContext
            , IRedisContextService redisContextService, ISmsHelper ISmsHelper
            , IMailHelper IMailHelper,
            IHttpRequestPayeer httpRequestPayeer, ISendCurrencyWareHouseQueue sendCurrencyWareHouseQueue,
            ICompanyServices ICompanyServices, IScenarioContext scenarioContext,
            ITransActionContext transActionContext, ITokenUserService tokenUserService,
            IHttpRequestGeoLocation httpRequestGeoLocation, IBankAccountContext IBankAccountContext)
        {
            this.ctx = ctx;
            this.settingctx = settingctx;
            _payeerContext = payeerContext;
            this._redisContextService = redisContextService;
            this.ctxGiftCard = ctxGiftCard;
            _IMailHelper = IMailHelper;
            _ISmsHelper = ISmsHelper;
            _httpRequestPayeer = httpRequestPayeer;
            _sendCurrencyWareHouseQueue = sendCurrencyWareHouseQueue;
            this._ICompanyServices = ICompanyServices;
            _scenarioContext = scenarioContext;
            _transActionContext = transActionContext;
            _tokenUserService = tokenUserService;
            _httpRequestGeoLocation = httpRequestGeoLocation;
            _IBankAccountContext = IBankAccountContext;

        }

        public DBResult getPPGResult(GetDbResultPPGCommand command)
        {
            
            return new DBResult(new
            {
                command.Status,
                command.OrderId,
                FinalAmount = command.FinalAmount.ToString(),
                command.TrackingCode,
                command.IsFree,
                command.Result
                ,
                BackUrl = command.CompanyId != null ? command.Setting?.BaseUrlCompanyPanel : command.Setting?.BaseUrlCustomerPanel,
                command.CompanyId,
                command.PaidDate,
                command.RemainingAmount
            }, 1);
        }

        public async Task CheckIpClientPortal(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.IpCheckerApiIp,cancellationToken);
            if (webServiceInfo != null)
            {
                var responseGeoLocation = await _httpRequestGeoLocation.getGeoLocationIp(webServiceInfo.BaseUrlService
                    , webServiceInfo.RealApiKey, cancellationToken);
                if (responseGeoLocation.countryCode != "IR")
                {
                    throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
                }
            }
        }

        public async Task<DBResult<IEnumerable<GetBankAccount.Outputs>>> checkBankAccountClientPortal(CheckBankAccountClientPortalCommand model, CancellationToken cancellationToken)
        {
            if (model.CheckBankAccount)
            {
                if (model.BankAccountId == null || model.BankAccountId == Guid.Empty)
                {
                    throw new LogicalException("برای پرداخت لطفا کارت بانکی خود را انتخاب کنید");
                }
                var dbResultBankAccount = await _IBankAccountContext.GetBankAccount(new GetBankAccount.Inputs
                {
                    BankAccountId = model.BankAccountId
                    ,
                    Token = model.Token
                }, cancellationToken);

                if (dbResultBankAccount == null || dbResultBankAccount.Data == null || dbResultBankAccount.Data.Count() == 0)
                {
                    throw new LogicalException("برای پرداخت لطفا ابتدا یک حساب بانکی ثبت بفرمایید");
                }
                return dbResultBankAccount;
            }
            return null;
        }

        public async Task<DBResult<IEnumerable<GetBankAccount_WithoutToken.Outputs>>> checkBankAccountClientPortalWithoutToken(CheckBankAccountClientPortalCommand model, CancellationToken cancellationToken)
        {
            if (model.CheckBankAccount)
            {
                if (model.BankAccountId == null || model.BankAccountId == Guid.Empty)
                {
                    throw new LogicalException("برای پرداخت لطفا کارت بانکی خود را انتخاب کنید");
                }
                var dbResultBankAccount = await _IBankAccountContext.GetBankAccount_WithoutToken(new GetBankAccount_WithoutToken.Inputs
                {
                    BankAccountId = model.BankAccountId
                }, cancellationToken);

                if (dbResultBankAccount == null || dbResultBankAccount.Data == null || dbResultBankAccount.Data.Count() == 0)
                {
                    throw new LogicalException("برای پرداخت لطفا ابتدا یک حساب بانکی ثبت بفرمایید");
                }
                return dbResultBankAccount;
            }
            return null;
        }


        public async Task<decimal?> CheckScenario(CheckScenarioCommand command, CancellationToken cancellationToken)
        {
            var dbResultScenario = await _scenarioContext.GetScenario(new GetScenario.Inputs
            {
                OrderType = command.OrderType,
                ModuleType = command.ModuleType
            }, cancellationToken);
            if (command.DiscountedFinalAmount != null && command.DiscountedFinalAmount > 0)
            {
                command.FinalAmount = command.DiscountedFinalAmount;
            }
            if (dbResultScenario != null && dbResultScenario.Data != null && dbResultScenario.Data.Count() > 0)
            {
                var scenarioList = dbResultScenario.Data.ToList();
                #region بررسی صحت روش پرداخت سناریو 
                var canNotAccessPayInFirstScenario = scenarioList.TrueForAll(q => ((q.SortNumber == 1 && (command.PaidAmount == null || command.PaidAmount <= 0)) || (q.SortNumber > 1 && command.PaidAmount != null && command.PaidAmount > 0)) && q.PaymentMethod != (int)command.PaymentMethod);

                if (canNotAccessPayInFirstScenario)
                {
                    switch (command.PaymentMethod)
                    {
                        case PayMentMethod.OnlinePayment:
                            throw new LogicalException("امکان پرداخت این نوع سفارش بصورت آنلاین وجود ندارد");
                        case PayMentMethod.DepositAccount:
                            throw new LogicalException("امکان پرداخت این نوع سفارش بصورت واریز به حساب وجود ندارد");

                        case PayMentMethod.OnlinePaymentSeveralSteps:
                            throw new LogicalException("امکان پرداخت این نوع سفارش بصورت پرداخت چند مرحله ای وجود ندارد");

                        case PayMentMethod.NotificationThroughTicket:
                            throw new LogicalException("امکان پرداخت این نوع سفارش بصورت اطلاع رسانی از طریق تیکت وجود ندارد");

                        case PayMentMethod.PaymentWithID:
                            throw new LogicalException("امکان پرداخت این نوع سفارش با واریز شناسه دار وجود ندارد");

                        case PayMentMethod.PayWithWallet:
                            throw new LogicalException("امکان پرداخت این نوع سفارش با کیف پول وجود ندارد");

                        case PayMentMethod.PayPerson:
                            throw new LogicalException("امکان پرداخت این نوع سفارش بصورت حضوری وجود ندارد");

                        case PayMentMethod.CompleteProcessSupport:
                            throw new LogicalException("امکان پرداخت این نوع سفارش با هماهنگی پشتیبانی وجود ندارد");

                        case PayMentMethod.AutomaticTransfer:
                            throw new LogicalException("امکان ثبت این نوع سفارش بصورت انتقال خودکار وجود ندارد");

                        default:
                            break;
                    }
                }
                #endregion
                #region بررسی سناریوی پرداخت کارمزد
                var isAccessScenarioPaymentOfOrderWage = scenarioList.Any(q => ((q.SortNumber == 1
                && (command.PaidAmount == null || command.PaidAmount <= 0)) || (q.SortNumber > 1 && command.PaidAmount != null && command.PaidAmount > 0)) && q.PaymentOfOrderWage == true && (q.MinimumAmountPaidToStart == null || q.MinimumAmountPaidToStart == -1 || q.MinimumAmountPaidToStart <= command.FinalAmount)
                && (q.MaximumAmountPaidToFinish == null || q.MaximumAmountPaidToFinish == -1 || q.MaximumAmountPaidToFinish >= command.FinalAmount));

                if (isAccessScenarioPaymentOfOrderWage)
                {
                    return command.FinalWageAmount;
                }
                #endregion
                #region بررسی سناریوی پرداخت بدون کارمزد
                var scenarioFilterPaymentWithoutOrderWage = scenarioList.Where(q => ((q.SortNumber > 1
&& (command.PaidAmount != null && command.PaidAmount > 0)) || (q.SortNumber == 1
                && (command.PaidAmount == null || command.PaidAmount <= 0))) && q.PaymentWithoutOrderWage == true
&& (q.MinimumAmountPaidToStart == null || q.MinimumAmountPaidToStart == -1 || q.MinimumAmountPaidToStart <= command.FinalAmount)
&& (q.MaximumAmountPaidToFinish == null || q.MaximumAmountPaidToFinish == -1 || q.MaximumAmountPaidToFinish >= command.FinalAmount));

                if (scenarioFilterPaymentWithoutOrderWage.Any())
                {
                    var scenarioFilterPaymentWithoutOrderWageItem = scenarioFilterPaymentWithoutOrderWage.FirstOrDefault(q => q.PaymentMethod == (int)command.PaymentMethod);
                    if (scenarioFilterPaymentWithoutOrderWageItem != null)
                    {
                        return (command.FinalAmount - command.FinalWageAmount) >= 0 ? (command.FinalAmount - command.FinalWageAmount) : 0;
                    }
                    else
                    {
                        throw new LogicalException($"لطفا وجه سفارش را از طریق روش {scenarioFilterPaymentWithoutOrderWage.FirstOrDefault().PaymentMethodName} پرداخت نمایید");
                    }
                }
                #endregion
                #region بررسی سناریوی پرداخت در حالت ترکیب درگاه پرداخت
                var accessPayInOtherScenario = scenarioList.FirstOrDefault(q => ((q.SortNumber > 1 && command.PaidAmount != null && command.PaidAmount > 0) ||
                (q.SortNumber == 1
                && (command.PaidAmount == null || command.PaidAmount <= 0))) && q.IsCombinationOfPaymentMethods == true &&
                q.MinimumAmountPaidToStart <= command.PaidAmount + 1 && q.PaymentMethod != (int)command.PaymentMethod && (q.MaximumAmountPaidToFinish == null || q.MaximumAmountPaidToFinish >= (command.FinalAmount - command.PaidAmount)));
                if (accessPayInOtherScenario != null)
                {
                    throw new LogicalException($"لطفا وجه سفارش را از طریق روش {accessPayInOtherScenario.PaymentMethodName} پرداخت نمایید");
                }
                #endregion

            }
            return (null);
        }


        public async Task<DBResult> DoCompeleteScenario(DoCompeleteScenarioCommand command, CancellationToken cancellationToken)
        {
            var dbResultScenario = await _scenarioContext.GetScenario(new GetScenario.Inputs
            {
                OrderType = command.OrderType,
                ModuleType = command.ModuleType
            }, cancellationToken);
            var paidAmount = command.FinalAmount - command.RemainingAmount;
            var scenarioItem = new GetScenario.Outputs();
            if (dbResultScenario != null && dbResultScenario.Data != null && dbResultScenario.Data.Count() > 0)
            {
                var scenarioList = dbResultScenario.Data.ToList();
                foreach (var item in scenarioList)
                {
                    if (item.SortNumber != 1 && item.IsCombinationOfPaymentMethods == true && item.MinimumAmountPaidToStart <= paidAmount + 1)
                    {
                        scenarioItem = item;
                        if (item.MaximumAmountPaidToFinish == null || item.MaximumAmountPaidToFinish >= command.RemainingAmount)
                        {
                            scenarioItem = item;

                        }
                    }
                }
                if (!string.IsNullOrWhiteSpace(scenarioItem.PaymentMethodName))
                {

                    decimal? remainingAmount = command.RemainingAmount;

                    if (scenarioItem.MaximumAmountPaidToFinish != null && scenarioItem.MaximumAmountPaidToFinish < command.RemainingAmount)
                    {
                        remainingAmount = command.RemainingAmount - scenarioItem.MaximumAmountPaidToFinish;
                    }

                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = command.Mobile,
                        Pattern = 61068,
                        Code = remainingAmount.moneyFormat(),
                        Code2 = scenarioItem.PaymentMethodName.Replace(" ", "_"),
                    }, cancellationToken);
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                        Body = $"سپاس از پرداخت شما ، لطفا جهت تکمیل فرآیند خرید ، مابقی وجه باقی مانده سفارش به مبلغ {remainingAmount.moneyFormat()} را با روش {scenarioItem.PaymentMethodName} پرداخت نمایید",
                        Email = command.Email
                    }, cancellationToken);
                }
            }
            if (dbResultScenario == null || dbResultScenario.Data == null || dbResultScenario.Data.Count() == 0 || string.IsNullOrWhiteSpace(scenarioItem.PaymentMethodName))
            {
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                    Body = $"سپاس از پرداخت شما ، لطفا جهت تکمیل فرآیند خرید ، وجه باقی مانده سفارش به مبلغ {command.RemainingAmount.moneyFormat()} را پرداخت نمایید",
                    Email = command.Email
                }, cancellationToken);

                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = command.Mobile,
                    Pattern = 61046,
                    Code = command.RemainingAmount.moneyFormat()
                }, cancellationToken);
            }

            return getPPGResult(new GetDbResultPPGCommand
            {
                StatusOrder = command.StatusOrder?.ToString(),
                OrderId = command.OrderId,
                Result = command.resultVerify,
                Status = command.Status,
                CompanyId = command.CompanyId,
                FinalAmount = paidAmount,
                PaidCode = command.PaidCode,
                Setting = command.Setting,
                TrackingCode = command.TrackingCode,
                TransactionCode = command.TransactionCode,
                PaidDate = command.PaidDate,
                RemainingAmount = command.RemainingAmount
            });


        }
        public async Task<DBResult> doCompeleteWalletCharge(DoCompeleteWalletCharge command, CancellationToken cancellationToken)
        {
            await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"شارژ موفق کیف پول",
                Body = $"شارژ کیف پول شما به مبلغ {command.PaidAmount.moneyFormat()} تومان با موفقیت انجام شد",
                Email = command.Email
            }, cancellationToken);

            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = command.Mobile,
                Pattern = 61050,
                Code = command.PaidAmount.moneyFormat()
            }, cancellationToken);
            return getPPGResult(new GetDbResultPPGCommand
            {
                Result = command.Result,
                Status = command.Status,
                CompanyId = command.CompanyId,
                FinalAmount = Convert.ToDecimal(command.PaidAmount),
                PaidCode = command.PaidCode,
                Setting = command.Setting,
                TrackingCode = command.TrackingCode,
                TransactionCode = command.TransactionCode,
                PaidDate = command.PaidDate,
                WalletId = command.WalletId
            });

        }

        public async Task<DBResult> doCompeleteFreeOrder(DoCompeleteFreeOrderCommand command
            , CancellationToken cancellationToken)
        {
            if (command.model.Discount != null && command.model.Discount > 0 && command.model.DiscountedFinalAmount == 0 || command.model.FinalAmount == null || command.model.FinalAmount == 0)
            {
                var commandCompelete = new DoCompeleteCommand();
                if (command.CheckToken == true)
                {
                    string token = _tokenUserService.getUserInfo().Token;
                    var dbResultFreeOrder = await _transActionContext.Update_Transaction_Free_Order(new Update_Transaction_Free_Order.Inputs
                    {
                        Token = token,
                        OnlinePortal = null,
                        OrderId = command.OrderId.Value,
                        Code = command.Code
                    }, cancellationToken);
                    commandCompelete.Email = dbResultFreeOrder.Data.Email;
                    commandCompelete.Mobile = dbResultFreeOrder.Data.Mobile;
                    commandCompelete.OrderNumber = Convert.ToInt64(dbResultFreeOrder.Data.OrderNumber);
                    commandCompelete.OrderType = dbResultFreeOrder.Data.OrderType;
                    commandCompelete.ValueType = dbResultFreeOrder.Data.ValueType;
                    commandCompelete.Commission = dbResultFreeOrder.Data.Commission;
                    commandCompelete.EmailCompanyUser = dbResultFreeOrder.Data.EmailCompanyUser;
                    commandCompelete.MobileCompanyUser = dbResultFreeOrder.Data.MobileCompanyUser;
                    commandCompelete.TransactionType = dbResultFreeOrder.Data.TransactionType;
                    commandCompelete.CooperRewardToman = dbResultFreeOrder.Data.CooperRewardToman;
                    commandCompelete.NumberOfSuccessfulOrders = dbResultFreeOrder.Data.NumberOfSuccessfulOrders;
                }
                else
                {
                    var dbResultFreeOrder = await _transActionContext.Update_Transaction_Free_Order_WithoutToken(new Update_Transaction_Free_Order_WithoutToken.Inputs
                    {
                        UserId = command.model.UserId,
                        OnlinePortal = null,
                        OrderId = command.OrderId.Value,
                        Code = command.Code
                    }, cancellationToken);
                    commandCompelete.Email = dbResultFreeOrder.Data.Email;
                    commandCompelete.Mobile = dbResultFreeOrder.Data.Mobile;
                    commandCompelete.OrderNumber = Convert.ToInt64(dbResultFreeOrder.Data.OrderNumber);
                    commandCompelete.OrderType = dbResultFreeOrder.Data.OrderType;
                    commandCompelete.ValueType = dbResultFreeOrder.Data.ValueType;
                    commandCompelete.Commission = dbResultFreeOrder.Data.Commission;
                    commandCompelete.EmailCompanyUser = dbResultFreeOrder.Data.EmailCompanyUser;
                    commandCompelete.MobileCompanyUser = dbResultFreeOrder.Data.MobileCompanyUser;
                    commandCompelete.TransactionType = dbResultFreeOrder.Data.TransactionType;
                    commandCompelete.CooperRewardToman = dbResultFreeOrder.Data.CooperRewardToman;
                    commandCompelete.NumberOfSuccessfulOrders = dbResultFreeOrder.Data.NumberOfSuccessfulOrders;
                }


                return await doCompelete(commandCompelete, cancellationToken);
            }
            return null;
        }

        /// <summary>
        /// تکمیل فرآیند تراکنش مشتری - اعم از ارسال ووچر یا گیفت کارت ، اطلاع رسانی پرداخت موفق و واریز سود همکاری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        public async Task<DBResult> doCompelete(DoCompeleteCommand command, CancellationToken cancellationToken)
        {
            if(command.Setting == null)
            {
                command.Setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            }
            if (command.NumberOfSuccessfulOrders == null)
            {
                command.NumberOfSuccessfulOrders = 0;
            }

            else if (command.OrderType == (int)OrderType.PayeerCharge)
            {

                await ChargePayeer(command, cancellationToken);
            }


            else if (!string.IsNullOrWhiteSpace(command.ValueType) && command.ValueType == "GFC")
            {

                await SendGiftCard(command, cancellationToken);
                await _ICompanyServices.SendCommission(command, cancellationToken);

                return getPPGResult(new GetDbResultPPGCommand
                {
                    StatusOrder = command.StatusOrder?.ToString(),
                    OrderId = command.OrderId,
                    Result = command.resultVerify,
                    Status = command.Status,
                    CompanyId = command.CompanyId,
                    FinalAmount = Convert.ToDecimal(command.FinalAmount),
                    IsFree = command.IsFree,
                    PaidCode = command.PaidCode,
                    Setting = command.Setting,
                    TrackingCode = command.TrackingCode,
                    TransactionCode = command.TransactionCode,
                    PaidDate = command.PaidDate
                });

            }
            if (command.StatusOrder != null && (OrderStatus)command.StatusOrder == OrderStatus.AwaitingExpertAction)
            {
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"تغییر وضعیت سفارش شماره #{command.OrderNumber}",
                    Body = $"سفارش شما به شماره {command.OrderNumber}# با موفقیت ثبت گردید، بزودی کارشناسان ما با شما ارتباط برقرار خواهند کرد.",
                    Email = command.Email
                }, cancellationToken);


                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = command.Mobile,
                    Pattern = 61083,
                    Code = command.OrderNumber.ToString()
                }, cancellationToken);
            }
            if (command.StatusOrder != null && (OrderStatus)command.StatusOrder == OrderStatus.WaitingInvoiceSent)
            {
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"تغییر وضعیت سفارش شماره #{command.OrderNumber}",
                    Body = $"سفارش شما به شماره {command.OrderNumber}# با موفقیت ثبت گردید، بزودی اطلاعات حساب واریز برای شما ارسال خواهد شد.",
                    Email = command.Email
                }, cancellationToken);


                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = command.Mobile,
                    Pattern = 61082,
                    Code = command.OrderNumber.ToString()
                }, cancellationToken);
            }
            if (command.StatusOrder == null || (OrderStatus)command.StatusOrder == OrderStatus.Paid
                || (OrderStatus)command.StatusOrder == OrderStatus.Done
                || (OrderStatus)command.StatusOrder == OrderStatus.Accepted)
            {
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                    Body = $"سفارش شما به شماره {command.OrderNumber}# با موفقیت پرداخت شد",
                    Email = command.Email
                }, cancellationToken);


                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = command.Mobile,
                    Pattern = 61038,
                    Code = command.OrderNumber.ToString()
                }, cancellationToken);
                await _ICompanyServices.SendCommission(command, cancellationToken);
            }


            return getPPGResult(new GetDbResultPPGCommand
            {
                StatusOrder = command.StatusOrder?.ToString(),
                OrderId = command.OrderId,
                Result = command.resultVerify,
                Status = command.Status,
                CompanyId = command.CompanyId,
                FinalAmount = Convert.ToDecimal(command.FinalAmount),
                IsFree = command.IsFree,
                PaidCode = command.PaidCode,
                Setting = command.Setting,
                TrackingCode = command.TrackingCode,
                TransactionCode = command.TransactionCode,
                PaidDate = command.PaidDate
            });

        }
        /// <summary>
        /// ارسال گیفت کارت
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        private async Task SendGiftCard(DoCompeleteCommand command, CancellationToken cancellationToken)
        {
            var dbResultOrderGiftCardReady = await ctxGiftCard.GiftCardReady_Spend(new GiftCardReady_Spend.Inputs { OrderId = command.OrderId }, cancellationToken);

            await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                Body = $"سفارش شما به شماره #{command.OrderNumber} با موفقیت پرداخت شد ، کد {dbResultOrderGiftCardReady.Data.GiftCardTitle} شما {dbResultOrderGiftCardReady.Data.GiftCard} می باشد",
                Email = command.Email
            }, cancellationToken);

            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = command.Mobile,
                Pattern = 61048,
                Code = command.OrderNumber.ToString(),
                Code2 = dbResultOrderGiftCardReady.Data.GiftCardTitle.Replace(" ", "-")
            ,
                Code3 = dbResultOrderGiftCardReady.Data.GiftCard.Trim()
            }, cancellationToken);
        }

        /// <summary>
        /// شارژ حساب پایر
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        private async Task ChargePayeer(DoCompeleteCommand command, CancellationToken cancellationToken)
        {
            var dbResultOrderPayeer = await _payeerContext.GetOrder_PayerAccountChargeAnonymous(new GetOrder_PayerAccountChargeAnonymous.Inputs
            { OrderId = command.OrderId }, cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            if (config["manualTransmissionLimitPayeer"] == null ||
                (string)config["manualTransmissionLimitPayeer"] == "" ||
                (string)config["manualTransmissionLimitPayeer"] == "0"
                || Convert.ToInt32((string)config["manualTransmissionLimitPayeer"]) <= command.NumberOfSuccessfulOrders)
            {
                var responsePayeer = await _httpRequestPayeer.purchasePayeer(new RequestTransferPayeerModel
                {
                    account = webServiceInfo.Username,
                    apiId = (string)config["shopNumberBuy"],
                    apiPass = (string)config["apiKeyBuy"],
                    sum = dbResultOrderPayeer.Data.Amount,
                    comment = "Buying Payeer by " + dbResultOrderPayeer.Data.Name + " " + dbResultOrderPayeer.Data.Family,
                    curIn = dbResultOrderPayeer.Data.Code.ToUpper(),
                    curOut = dbResultOrderPayeer.Data.Code.ToUpper(),
                    to = dbResultOrderPayeer.Data.PayerWallet,
                    referenceId = dbResultOrderPayeer.Data.OrderId.ToString()
                },
            webServiceInfo.BaseUrlService, cancellationToken);

                if (responsePayeer == null || responsePayeer.success == false)
                {
                    await ctx.Update_Order_Status_WithouToken(new Update_Order_Status_WithouToken.Inputs
                    {
                        OrderId = command.OrderId,
                        Status = (int)OrderStatus.AwaitingExpertAction
                    }, cancellationToken);
                    throw new ExternalServiceException("پرداخت شما تایید شده است ، اما متاسفانه در فرآیند شارژ پایر شما خطایی رخ داده است ، بزودی کارشناسان ما این فرآیند را برای شما تکمیل خواهند کرد");
                }

                await _payeerContext.Update_OrderPayeerChargeByCustomer(new Update_OrderPayeerChargeByCustomer.Inputs
                {
                    OrderId = command.OrderId,
                    HistoryId = responsePayeer.historyId.ToString()
                }, cancellationToken);

                await _sendCurrencyWareHouseQueue.sendToQueue(new CurrencyWareHouseCommand
                {
                    orderId = command.OrderId,
                    amount = dbResultOrderPayeer.Data.Amount,
                    price = dbResultOrderPayeer.Data.CurrencyAmount,
                    key = "payeer"
                });
            }
        }



    }
}
