﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.ICompany;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.IPPG;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Models.API.Whatsapp;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.staticData;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using StackExchange.Redis;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App
{
    public class OrderService : IOrderService
    {
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly ICurrencyContext _ICurrencyContext;
        private readonly IOrderContext _IOrderContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly IQuestionsContext _IQuestionsContext;
        private readonly IStaticContext _IStaticContext;
        private readonly IPublicContext _IPublicContext;
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IShepaService _IShepaService;
        private readonly IVandarService _IVandarService;
        private readonly IJibitService _IJibitService;
        private readonly IZarinpalService _IZarinpalService;
        private readonly IZarinLinkService _zarinLinkService;
        private readonly ITokenUserService _tokenUserService;
        private readonly ICompanyServices _ICompanyServices;
        private readonly IRedisContextService _redisContextService;
        private readonly ITicketContext _ticketContext;
        private readonly IWhatsappHelper _whatsappHelper;
        private readonly ITelegramHelper _telegramHelper;
        public OrderService(ISmsHelper ISmsHelper, IMailHelper IMailHelper, ICurrencyContext ICurrencyContext,
            IOrderContext IOrderContext, IQuestionsContext IQuestionsContext, IPublicContext IPublicContext,
            IAutomaticOrderOperationService IAutomaticOrderOperationService, IShepaService IShepaService
            , IVandarService IVandarService, IJibitService IJibitService,
            IStaticContext IStaticContext, ITransActionContext ITransActionContext
            , ITokenUserService tokenUserService, ICompanyServices ICompanyServices
            , IZarinpalService IZarinpalService, IZarinLinkService zarinLinkService
            , IRedisContextService redisContextService, ITicketContext ticketContext, IWhatsappHelper whatsappHelper, ITelegramHelper telegramHelper)
        {
            _ISmsHelper = ISmsHelper;
            _IMailHelper = IMailHelper;
            _ICurrencyContext = ICurrencyContext;
            _IOrderContext = IOrderContext;
            _IQuestionsContext = IQuestionsContext;
            _IPublicContext = IPublicContext;
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _IShepaService = IShepaService;
            _IVandarService = IVandarService;
            _IJibitService = IJibitService;
            _IZarinpalService = IZarinpalService;
            _IStaticContext = IStaticContext;
            _ITransActionContext = ITransActionContext;
            _tokenUserService = tokenUserService;
            _ICompanyServices = ICompanyServices;
            _zarinLinkService = zarinLinkService;
            _redisContextService = redisContextService;
            _ticketContext = ticketContext;
            _whatsappHelper = whatsappHelper;
            _telegramHelper = telegramHelper;
        }

        public async Task<DBResult> getFull(GetFullOrderCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            return new DBResult()
            {
                Data = new
                {
                    Currency = await _ICurrencyContext.GetCurrencyListByCustomer(new GetCurrencyListByCustomer.Inputs
                    {
                        OrderType = command.OrderType,
                        Token = token
                    }, cancellationToken),
                    Question = await _IQuestionsContext.Get_Question(new Get_Question.Inputs
                    {
                        OrderType = command.OrderType
                    }, cancellationToken),
                    Steps = await _IOrderContext.GetStatus_Step_Order(new GetStatus_Step_Order.Inputs
                    {
                        OrderType = command.OrderType,
                        OrderId = command.OrderId,
                        Token = token
                    }, cancellationToken),
                    Static = await _IStaticContext.Get_StaticById(new Get_StaticById.Inputs
                    {
                        StaticId = command.OrderType,
                        Token = token
                    }, cancellationToken),
                    Setting = await _IPublicContext.Get_Order_Setting(new Get_Order_Setting.Inputs
                    {
                        OrderType = command.OrderType,
                        IsArchive = false,
                        Token = token
                    }, cancellationToken),

                },
                ActualSize = 0
            };
        }

        public async Task<DBResult> updateFreeOrder(UpdateFreeOrderCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            if ((dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 && dbResultOrder.Data.DiscountedFinalAmount < 1000) || (dbResultOrder.Data.FinalAmount == null || dbResultOrder.Data.FinalAmount < 1000))
            {
                var dbResultFreeOrder = await _ITransActionContext.Update_Transaction_Free_Order(new Update_Transaction_Free_Order.Inputs
                {
                    Token = token,
                    OnlinePortal = null,
                    OrderId = command.OrderId.Value,
                    Code = command.Code
                }, cancellationToken);

                return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                {
                    Email = dbResultFreeOrder.Data.Email,
                    Mobile = dbResultFreeOrder.Data.Mobile,
                    OrderId = command.OrderId,
                    OrderNumber = Convert.ToInt64(dbResultFreeOrder.Data.OrderNumber),
                    OrderType = dbResultFreeOrder.Data.OrderType,
                    PurchaseId = command.OrderId.ToString(),
                    ValueType = dbResultFreeOrder.Data.ValueType,
                    IsFree = true,
                    Commission = dbResultFreeOrder.Data.Commission,
                    EmailCompanyUser = dbResultFreeOrder.Data.EmailCompanyUser,
                    MobileCompanyUser = dbResultFreeOrder.Data.MobileCompanyUser,
                    TransactionType = dbResultFreeOrder.Data.TransactionType,
                    CooperRewardToman = dbResultFreeOrder.Data.CooperRewardToman,
                    NumberOfSuccessfulOrders = dbResultFreeOrder.Data.NumberOfSuccessfulOrders
                }, cancellationToken);

            }
            throw new LogicalException("این سفارش رایگان نمی باشد ، در صورت هرگونه سوال با پشتیبانان ارتباط برقرار فرمایید.");
        }

        public async Task<DBResult> updateStatus(UpdateStatusCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResult = await _IOrderContext.Update_Order_Status_ByAdmin(new Update_Order_Status_ByAdmin.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Status = command.Status,
                CurrencyPrice = command.CurrencyPrice,
                ReasonCancellation = command.ReasonCancellation,
                IsMediator = command.IsMediator,
                IsCash = command.IsCash,
                WageToman = command.WageToman,
                WageMediatorToman = command.WageMediatorToman,
                AccountInformationId = command.AccountInformationId,
                CalculateWage = command.CalculateWage,
                Description = command.Description,
                HistoryType = command.HistoryType,
                IsChangeInventory = command.IsChangeInventory,
                IsChangeInventoryToman = command.IsChangeInventoryToman,
                NoteText = command.NoteText,
                Wage = command.Wage,
                WageMediator = command.WageMediator,
                OperatorPaymentTypeWareHouse = command.OperatorPaymentTypeWareHouse,
                OperatorPaymentTypeWareHouseToman = command.OperatorPaymentTypeWareHouseToman,
                RoleOfPayerWareHouse = command.RoleOfPayerWareHouse,
                RoleOfPayerWareHouseToman = command.RoleOfPayerWareHouseToman,
                TypeOfPaymentWareHouse = command.TypeOfPaymentWareHouse,
                TypeOfPaymentWareHouseToman = command.TypeOfPaymentWareHouseToman,
                ConcernCurrencyWareHouse = command.ConcernCurrencyWareHouse,
                ConcernCurrencyWareHouseToman = command.ConcernCurrencyWareHouseToman,
                Category = command.Category,
                DescriptionToman = command.DescriptionToman,
                CalculateWageToman = command.CalculateWageToman,
                WageTomanDeduction = command.WageTomanDeduction,
                IsCalculateComission = command.IsCalculateComission,
                FileIdHistoryWareHouse = command.FileIdHistoryWareHouse,
                FileIdHistoryWareHouseToman = command.FileIdHistoryWareHouseToman,
                OutOfFlowAmount = command.OutOfFlowAmount,
                OutOfFlowAmountToman = command.OutOfFlowAmountToman,
                ClosedDate = command.ClosedDate,
                IsMediatorToman = command.IsMediatorToman,
            }, cancellationToken);
            if (dbResult.Data != null)
            {

                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"تغییر وضعیت سفارش",
                    Body = $"سفارش شما به شماره #{dbResult.Data.OrderNumber} در وضعیت {dbResult.Data.StatusName} قرار گرفت",
                    Email = dbResult.Data.Email
                }, cancellationToken);


                int pattern = 0;
                switch (command.Status)
                {
                    case (int)OrderStatus.NotConfirmed:
                        pattern = 61039;
                        break;
                    case (int)OrderStatus.Doing:
                        pattern = (int)Pattern.InprogressOrderStatus;
                        break;
                    case (int)OrderStatus.Accepted:
                        if (dbResult.Data.StatusOld == (int)OrderStatus.CheckingDepositDocument)
                            pattern = 61037;
                        else
                            pattern = 61036;
                        break;
                    case (int)OrderStatus.Done:
                        pattern = 61053;
                        break;
                    case (int)OrderStatus.Canceled:
                        pattern = 61034;
                        break;
                }


                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = pattern
                ,
                    Code = dbResult.Data.OrderNumber.ToString()
                }, cancellationToken);

                await _ICompanyServices.SendCommission(new DoCompeleteCommand
                {
                    Commission = dbResult.Data.Commission,
                    CompanyId = dbResult.Data.CompanyId,
                    CooperRewardToman = dbResult.Data.CooperRewardToman,
                    Email = dbResult.Data.Email,
                    EmailCompanyUser = dbResult.Data.EmailCompanyUser,
                    Mobile = dbResult.Data.Mobile,
                    MobileCompanyUser = dbResult.Data.MobileCompanyUser,
                    TransactionType = dbResult.Data.TransactionType

                }, cancellationToken);


            }
            return new DBResult(new { }, 0);
        }

        public async Task<DBResult> updateStatusSetAppointmentByCustomer(UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);
            var remainAmount = dbResultOrder.Data.FinalAmount - (dbResultOrder.Data.PaidAmount ?? 0);
            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.PayPerson,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation,
            }, cancellationToken);
            if (allowedAmount == null || allowedAmount <= 0)
            {
                allowedAmount = remainAmount;
            }
            if (allowedAmount != null && allowedAmount > 0)
            {
                dbResultOrder.Data.FinalAmount = allowedAmount;
            }
          
            await _IOrderContext.Update_Order_Status(new Update_Order_Status.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Status = (int)OrderStatus.AwaitingAppointment,
                Code = command.Code,
                PaymentMethod = command.PaymentMethod,
                PayableAmount = dbResultOrder.Data.FinalAmount
            }, cancellationToken);

            return new DBResult(new { }, 0);
        }

        public async Task<DBResult> updateStatusWaitingByCustomer(UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);
            if (dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException("سفارش مورد نظر یافت نشد");
            }
            var remainAmount = dbResultOrder.Data.FinalAmount - (dbResultOrder.Data.PaidAmount ?? 0);

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data?.OrderType,
                PaidAmount = dbResultOrder.Data?.PaidAmount,
                FinalAmount = dbResultOrder.Data?.FinalAmount,
                FinalWageAmount = dbResultOrder.Data?.FinalWageAmount,
                PaymentMethod = PayMentMethod.CompleteProcessSupport,
                DiscountedFinalAmount = dbResultOrder.Data?.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation,
            }, cancellationToken);

            if (allowedAmount == null || allowedAmount <= 0)
            {
                allowedAmount = remainAmount;
            }
            if (allowedAmount != null && allowedAmount > 0)
            {
                dbResultOrder.Data.FinalAmount = allowedAmount;
            }
            await _IOrderContext.Update_Order_Status(new Update_Order_Status.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Status = (int)OrderStatus.AwaitingExpertAction,
                Code = command.Code,
                PaymentMethod = command.PaymentMethod,
                PayableAmount = dbResultOrder.Data.FinalAmount
            }, cancellationToken);

            return new DBResult(new { }, 0);
        }

        public async Task<DBResult> UpdateStatusDocumentByCustomer(UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);
            var remainAmount = dbResultOrder.Data.FinalAmount - (dbResultOrder.Data.PaidAmount ?? 0);
            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = (PayMentMethod)command.PaymentMethod,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);
            if (allowedAmount == null || allowedAmount <= 0)
            {
                allowedAmount = remainAmount;
            }
            if (allowedAmount != null && allowedAmount > 0)
            {
                dbResultOrder.Data.FinalAmount = allowedAmount;
            }
            var response = await _IOrderContext.Update_Order_Status(new Update_Order_Status.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Status = (int)OrderStatus.AwaitingPaymentReceipt,
                Code = command.Code,
                PaymentMethod = command.PaymentMethod,
                PayableAmount = dbResultOrder.Data.FinalAmount,
            }, cancellationToken);
            if (response.Data.IsSmartPayment == true)
            {
                if (response == null || response.Data == null || response.Data.AccountNumberId == null)
                {
                    throw new LogicalException("شماره حساب فعالی جهت واریز وجه یافت نشد ، جهت پرداخت لطفا با پشتیبانی تماس بگیرید");
                }
                if (response.Data.UserId == null)
                {
                    throw new LogicalException("شناسه شما یافت نشد ، لطفا برای حل مشکل با پشتیبانی تماس بگیرید");
                }
                if (response.Data.UserIdSenderTicket == null)
                {
                    throw new LogicalException("راهبر ارسال کننده تیکت یافت نشد ، لطفا برای حل مشکل با پشتیبانی تماس بگیرید");
                }

                if ((response.Data.MaximumNumberOfTransactionsPerMonth != null &&
    response.Data.MaximumNumberOfTransactionsPerMonth > 0 && response.Data.MaximumNumberOfTransactionsPerMonth <= response.Data.History_count)
    || (response.Data.MaximumTransactionAmountPerMonth != null && response.Data.MaximumTransactionAmountPerMonth > 0 && response.Data.MaximumTransactionAmountPerMonth <= Convert.ToInt64(remainAmount)))
                {
                    await _IOrderContext.Update_Order_Status_WithouToken(new Update_Order_Status_WithouToken.Inputs
                    {
                        OrderId = command.OrderId,
                        Status = (int)OrderStatus.AwaitingExpertAction,
                        ReasonAutoChangeStatus = $"تمام حساب های بانکی به سقف مجاز رسیده، سفارش بطور اتوماتیک در وضعیت  {OrderStatus.AwaitingExpertAction.GetDescription()} قرار گرفت"
                    }, cancellationToken);
                    throw new AccountLimitationException("تمام حساب های بانکی به سقف مجاز رسیده اند ، لطفااز روش پرداخت دیگری استفاده نمایید ، درصورت هرگونه سوال و یا مشکل می توانید با کارشناسان ما ارتباط برقرار کنید");
                }

                allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
                {
                    OrderType = response.Data.OrderType,
                    PaidAmount = dbResultOrder.Data.PaidAmount,
                    FinalAmount = response.Data.FinalAmount,
                    FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                    PaymentMethod = PayMentMethod.SmartDeposit,
                    DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                    ModuleType = dbResultOrder.Data.SaveLocation,
                }, cancellationToken);
                if (allowedAmount == null || allowedAmount <= 0)
                {
                    allowedAmount = remainAmount;
                }

                var settingOrder = await _redisContextService.getSettingOrderAsync(response.Data.OrderType, token, cancellationToken);

                if ((settingOrder.IsActiveAccountByAccountSmart == null || settingOrder.IsActiveAccountByAccountSmart == false)
                    && (settingOrder.IsActiveAccountByAccount == null || settingOrder.IsActiveAccountByAccount == false))
                    throw new LogicalException("روش پرداخت حساب به حساب غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");

                response.Data.ShebaNumber = "IR" + response.Data.ShebaNumber;
                string telLink = response.Data.PhoneNumber;
                if (!string.IsNullOrWhiteSpace(response.Data.PhoneNumber))
                {
                    response.Data.PhoneNumber = response.Data.PhoneNumber.Replace("tel:", "");
                }
                var body = $"کاربر گرامی با سلام و احترام {Environment.NewLine} جهت پرداخت سفارش شماره {response.Data.OrderNumber}#، لطفا مبلغ {allowedAmount.moneyFormat()} تومان را به حساب زیر واریز نمایید. {Environment.NewLine} شماره کارت: {response.Data.CardNumber} {Environment.NewLine} شماره حساب: {response.Data.DepositNumber} {Environment.NewLine} شماره شبا: {response.Data.ShebaNumber} {Environment.NewLine}  بنام: {response.Data.AccountOwnerFullName} {Environment.NewLine} لطفا پس از واریز، در پنل کاربری رسید را آپلود نمایید و روی دکمه «واریز انجام شد» کلیک کنید، در صورت نیاز به راهنمایی و بروز هرگونه مشکل با شماره پشتیبانی {response.Data.PhoneNumber} در ارتباط باشید {Environment.NewLine} سپاس از همراهی شما";
                var ticket = new DBResult<Insert_Ticket_Auto.Outputs>();
                if (response.Data.SendTicketToCustomer == true)
                {
                    ticket = await _ticketContext.Insert_Ticket_Auto(new Insert_Ticket_Auto.Inputs
                    {
                        Title = $"اطلاعات حساب جهت واریز وجه سفارش",
                        Text = body.Replace(Environment.NewLine, "<br />"),
                        PartId = response.Data.PartId,
                        SubjectId = response.Data.SubjectId,
                        Token = token,
                        UserIdReceiver = response.Data.UserId,
                        UserIdSender = response.Data.UserIdSenderTicket
                    }, cancellationToken);
                }

                if (response.Data.SendEmailToCustomer == true)
                {
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"فراکنش؛ اطلاعات حساب جهت واریز وجه سفارش",
                        Body = body,
                        Email = response.Data.Email
                    }, cancellationToken);
                }
                if (response.Data.SendSmsToCustomer == true)
                {
                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = response.Data.Mobile,
                        Pattern = 61080,
                        Code = response.Data.OrderNumber.ToString() + "#",
                        Code2 = allowedAmount.moneyFormat(),
                        Code3 = response.Data.CardNumber.ToCardFormat(),
                        Code4 = response.Data.ShebaNumber,
                        Code5 = response.Data.DepositNumber,
                        Code6 = response.Data.AccountOwnerFullName,
                    }, cancellationToken);
                }
                if (response.Data.SendWhatsappToCustomer == true)
                {
                    await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                    {
                        Receivers = response.Data.PrefixPhone + response.Data.Mobile,
                        Message = body
                    }, null, cancellationToken);
                }
                if (response.Data.SendTelegramToCustomer == true && !string.IsNullOrWhiteSpace(response.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Channel = response.Data.ChatIdTelegram,
                        Message = body
                    }, cancellationToken);
                }

            }
                return new DBResult(new { }, 0);
        }

        public async Task<DBResult> updateByCommission(UpdateByCommissionCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResult = await _IOrderContext.Update_Wallet_Company_ByCommission(new Update_Wallet_Company_ByCommission.Inputs
            {
                Token = token,
                OrderId = command.OrderId
            }, cancellationToken);
            if (dbResult.Data != null)
            {
                await _ICompanyServices.SendCommission(new DoCompeleteCommand
                {
                    Commission = dbResult.Data.Commission
                    ,
                    CooperRewardToman = dbResult.Data.CooperRewardToman,
                    Email = dbResult.Data.Email,
                    Mobile = dbResult.Data.Mobile,
                    TransactionType = dbResult.Data.TransActionType,
                    CompanyId = dbResult.Data.CompanyId,
                    EmailCompanyUser = dbResult.Data.EmailCompanyUser,
                    MobileCompanyUser = dbResult.Data.MobileCompanyUser
                }, cancellationToken);
            }
            return new DBResult(new { }, 0);
        }


        public async Task<DBResult> updateStatusStartPay(UpdateStatusStartPayCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            await _IOrderContext.Update_Order_Status(new Update_Order_Status.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Status = 181,
                PayableAmount = null,
            }, cancellationToken);

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            if (setting.IsDefaultJibit == true)
            {
                return await _IJibitService.startPay(new StartPayOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code
                }, cancellationToken);
            }

            else if (setting.IsDefaultVandar == true)
            {
                return await _IVandarService.startPay(new StartPayOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code
                }, cancellationToken);
            }

            else if (setting.IsDefaultShepa == true)
            {

                return await _IShepaService.startPay(new StartPayOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code
                }, cancellationToken);


            }

            else if (setting.IsDefaultZarinLink == true)
            {
                return await _zarinLinkService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code
                }, cancellationToken);

            }

            throw new ExternalServiceException("خطا در انتقال به درگاه پرداخت ، در صورت تکرار لطفا با پشتیبانی برنامه ارتباط برقرار کنید");
        }


        public async Task<DBResult> paymentLink(PaymentLinkCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            if (setting.IsDefaultJibit == true)
            {
                return await _IJibitService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code,
                    OrderNumber = command.OrderNumber
                }, cancellationToken);

            }

            else if (setting.IsDefaultVandar == true)
            {
                return await _IVandarService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code,
                    OrderNumber = command.OrderNumber
                }, cancellationToken);
            }

            else if (setting.IsDefaultShepa == true)
            {
                return await _IShepaService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code,
                    OrderNumber = command.OrderNumber
                }, cancellationToken);

            }
            else if (setting.IsDefaultZarinpal == true)
            {
                return await _IZarinpalService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code,
                    OrderNumber = command.OrderNumber
                }, cancellationToken);

            }


            else if (setting.IsDefaultZarinLink == true)
            {
                return await _zarinLinkService.startPayPublic(new StartPayPublicOrderCommand
                {
                    OrderId = command.OrderId,
                    Code = command.Code,
                    OrderNumber = command.OrderNumber
                }, cancellationToken);

            }

            throw new ExternalServiceException("خطا در انتقال به درگاه پرداخت ، در صورت تکرار لطفا با پشتیبانی برنامه ارتباط برقرار کنید");
        }

        public async Task<DBResult> saveReceipt(SaveReceiptCommand command, CancellationToken cancellationToken)
        {

            var dbResultOrder = await _IOrderContext.Update_Order_Receipt(new Update_Order_Receipt.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                OrderId = command.OrderId,
                FileId = command.FileId,
                DocumentType = command.DocumentType,
                HistoryWareHouseId = command.HistoryWareHouseId,
                HistoryWareHouseTomanId = command.HistoryWareHouseTomanId
            }, cancellationToken);

            await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"بارگذاری سند",
                Body = $"کاربر عزیز ، برای سفارش شماره {dbResultOrder.Data.OrderNumber}# یک سند بارگذاری شده است ، برای مشاهده ی آن به بخش سفارش ها در پنل کاربری خود مراجعه بفرمایید",
                Email = dbResultOrder.Data.Email
            }, cancellationToken);


            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResultOrder.Data.Mobile,
                Pattern = 61057,
                Code = dbResultOrder.Data.OrderNumber.ToString()
            }, cancellationToken);
            return new DBResult();

        }
    }
}
