﻿using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Farakonesh.Commands.Services;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App
{
    public class OrderServicesWallet: IOrderServicesWallet
    {
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IOrderContext _IOrderContext;
        private readonly ISettingContext _ISettingContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly RedisService _redis;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        public OrderServicesWallet(IAutomaticOrderOperationService IAutomaticOrderOperationService
            , ISettingContext iSettingContext, IOrderContext iOrderContext
            ,  ITransActionContext iTransActionContext, RedisService redis
            , ITokenUserService tokenUserService, IRedisContextService redisContextService)
        {
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _ISettingContext = iSettingContext;
            _IOrderContext = iOrderContext;
            _ITransActionContext = iTransActionContext;
            _redis = redis;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
        }

        public async Task<DBResult> startPayWithWallet(StartPayWithWalletCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            if (setting.IsActivePayWallet == false)
            {
                throw new LogicalException($"در حال حاضر روش پرداخت با کیف پول غیر فعال می باشد ، لطفا از روش دیگری استفاده کنید");
            }

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.PayWithWallet,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            if ((dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 && dbResultOrder.Data.DiscountedFinalAmount == 0) || (dbResultOrder.Data.FinalAmount == null || dbResultOrder.Data.FinalAmount == 0))
            {
                var dbResultFreeOrder = await _ITransActionContext.Update_Transaction_Free_Order(new Update_Transaction_Free_Order.Inputs
                {
                    Token = token,
                    OnlinePortal = null,
                    OrderId = command.OrderId.Value,
                    Code = command.Code
                }, cancellationToken);

                return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                {
                    Email = dbResultFreeOrder.Data.Email,
                    Mobile = dbResultFreeOrder.Data.Mobile,
                    OrderId = command.OrderId,
                    OrderNumber = Convert.ToInt64(dbResultFreeOrder.Data.OrderNumber),
                    OrderType = dbResultFreeOrder.Data.OrderType,
                    PurchaseId = command.OrderId.ToString(),
                    ValueType = dbResultFreeOrder.Data.ValueType,
                    IsFree = true,
                    Commission = dbResultFreeOrder.Data.Commission,
                    EmailCompanyUser = dbResultFreeOrder.Data.EmailCompanyUser,
                    MobileCompanyUser = dbResultFreeOrder.Data.MobileCompanyUser,
                    TransactionType = dbResultFreeOrder.Data.TransactionType,
                    CooperRewardToman = dbResultFreeOrder.Data.CooperRewardToman,
                    NumberOfSuccessfulOrders = dbResultFreeOrder.Data.NumberOfSuccessfulOrders
                }, cancellationToken);

            }



            var actionUpdateTransactionDBResult = await _ITransActionContext.Update_Transaction_Wallet_Order(new Update_Transaction_Wallet_Order.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                Code = command.Code,
                AllowedAmount = allowedAmount
            }, cancellationToken);

            return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
            {
                Email = actionUpdateTransactionDBResult.Data.Email,
                Mobile = actionUpdateTransactionDBResult.Data.Mobile,
                OrderId = command.OrderId,
                OrderNumber = Convert.ToInt64(actionUpdateTransactionDBResult.Data.OrderNumber),
                OrderType = actionUpdateTransactionDBResult.Data.OrderType,
                PurchaseId = command.OrderId.ToString(),
                ValueType = actionUpdateTransactionDBResult.Data.ValueType,
                IsFree = false,
                Commission = actionUpdateTransactionDBResult.Data.Commission,
                EmailCompanyUser = actionUpdateTransactionDBResult.Data.EmailCompanyUser,
                MobileCompanyUser = actionUpdateTransactionDBResult.Data.MobileCompanyUser,
                TransactionType = actionUpdateTransactionDBResult.Data.TransactionType,
                CooperRewardToman = actionUpdateTransactionDBResult.Data.CooperRewardToman,
                NumberOfSuccessfulOrders = actionUpdateTransactionDBResult.Data.NumberOfSuccessfulOrders,
                StatusOrder = actionUpdateTransactionDBResult.Data.StatusOrder
            }, cancellationToken);

        }
    }
}
