﻿using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.staticData;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Order.PremiumAccount
{

    public class PremiumAccountService : IPremiumAccountService
    {
        private readonly IPremiumAccountContext _IPremiumAccountContext;
        private readonly ICurrencyContext _ICurrencyContext;
        private readonly IOrderContext _IOrderContext;
        private readonly IStaticContext _IStaticContext;
        private readonly IPublicContext _IPublicContext;
        private readonly IQuestionsContext _IQuestionsContext;
        private readonly ITokenUserService _tokenUserService;
        public PremiumAccountService(IPremiumAccountContext IPremiumAccountContext
            , ICurrencyContext ICurrencyContext, IOrderContext IOrderContext
            , IStaticContext IStaticContext, IPublicContext IPublicContext, IQuestionsContext iQuestionsContext,
            ITokenUserService tokenUserService)
        {
            _ICurrencyContext = ICurrencyContext;
            _IPremiumAccountContext = IPremiumAccountContext;
            _IOrderContext = IOrderContext;
            _IStaticContext = IStaticContext;
            _IPublicContext = IPublicContext;
            _IQuestionsContext = iQuestionsContext;
            _tokenUserService = tokenUserService;

        }
        public async Task<DBResult> getFull(GetFullPremiumAccountCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            return new DBResult()
            {
                Data = new
                {
                    ActivationType = await _IPremiumAccountContext.GetActivationTypePremiumAccountList(new GetActivationTypePremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Country = await _IPremiumAccountContext.GetCountryPremiumAccountList(new GetCountryPremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType
            ,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken)
                ,
                    Language = await _IPremiumAccountContext.GetLanguagePremiumAccountList(new GetLanguagePremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType
            ,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Type = await _IPremiumAccountContext.GetTypePremiumAccountList(new GetTypePremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType
            ,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken)
                ,
                    Period = await _IPremiumAccountContext.GetPeriodPremiumAccountList(new GetPeriodPremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Pelan = await _IPremiumAccountContext.GetPelanPremiumAccountList(new GetPelanPremiumAccountList.Inputs
                    {
                        OrderType = command.OrderType,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Currency = await _ICurrencyContext.GetCurrencyAmountListByCustomer(new GetCurrencyAmountListByCustomer.Inputs
                    {
                        OrderType = command.OrderType,
                        PageSize = 50,
                        Sort = command.Sort,
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Question = await _IQuestionsContext.Get_Question(new Get_Question.Inputs
                    {
                        OrderType = command.OrderType
                    }, cancellationToken),
                    Steps = await _IOrderContext.GetStatus_Step_Order(new GetStatus_Step_Order.Inputs
                    {
                        OrderType = command.OrderType,
                        OrderId = command.OrderId,
                        Token = token
                    }, cancellationToken),
                    Static = await _IStaticContext.Get_StaticById(new Get_StaticById.Inputs
                    {
                        StaticId = command.OrderType,
                        Token = token
                    }, cancellationToken),
                    setting = await _IPublicContext.Get_Order_Setting(new Get_Order_Setting.Inputs
                    {
                        OrderType = command.OrderType,
                        IsArchive = false,
                        Token = token
                    }, cancellationToken),

                },
                ActualSize = 0
            };
        }
    }
}
