﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.IPPG;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using StackExchange.Redis;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Transactions;

namespace Farakonesh.Logic.Services.App.PPG
{
    public class AutoVerifyService : IAutoVerifyService
    {

        private readonly ITransActionContext _ITransActionContext;
        private readonly ISettingContext _ISettingContext;
        private readonly IMailHelper _IMailHelper;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IZarinpalService _zarinpalService;
        private readonly ISepalService _sepalService;
        private readonly IRedisContextService _redisContextService;
        private readonly IJibitService _jibitService;
        private readonly IShepaService _shepaService;
        private readonly IZarinLinkService _zarinLinkService;
        private readonly IVandarService _vandarService;
        private readonly ITokenUserService _tokenUserService;
        public AutoVerifyService(
            ISettingContext ISettingContext,
            IMailHelper IMailHelper, ISmsHelper ISmsHelper, ITransActionContext ITransActionContext,
            IZarinpalService zarinpalService, IRedisContextService redisContextService
            , IJibitService jibitService, IShepaService shepaService,
            IZarinLinkService zarinLinkService, IVandarService vandarService, ITokenUserService tokenUserService,
            ISepalService sepalService)
        {
            _tokenUserService = tokenUserService;
            _jibitService = jibitService;
            _shepaService = shepaService;
            _zarinLinkService = zarinLinkService;
            _ISettingContext = ISettingContext;
            _IMailHelper = IMailHelper;
            _ISmsHelper = ISmsHelper;
            _ITransActionContext = ITransActionContext;
            _zarinpalService = zarinpalService;
            _redisContextService = redisContextService;
            _vandarService = vandarService;
            _sepalService = sepalService;

        }
        public async Task<DBResult> verifyPayDatabase(VerifyPayDatabaseCommand command, CancellationToken cancellationToken)
        {

            var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
            if (dbSetting.Data.JobToken != command.JobToken)
            {
                throw new LogicalException("کلید اتصال نامعتبر می باشد");
            }

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            
            var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);

            var dbResultGetTransaction = await _ITransActionContext.GetTransActionByPaidCode(new GetTransActionByPaidCode.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal? price = 0;
            if (dbResultGetTransaction.Data.OnlinePortal == (int)OnlinePortal.ZarinLink)
            {
                price = Convert.ToDecimal(command.PaidAmount);
            }
            else
            {
                price = Convert.ToDecimal(command.PaidAmount) / 10;
            }

            if (dbResultGetTransaction.Data.OnlinePortal == (int)OnlinePortal.Zarinpal)
            {
                await _zarinpalService.verifyAutoTransAction(new VerifyAutoTransActionZarinpal
                {
                    PaidAmount = Convert.ToInt64(command.PaidAmount),
                    PurchaseId = command.PurchaseId
                }, cancellationToken);
            }
            if (dbResultGetTransaction.Data.OrderId != null)
            {
                var dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction(new Update_Transaction.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = command.PaidAmount != null && command.PaidAmount > 0 ? price : 0,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode,
                    MaximummPrice = maximumAmountOnlinePort
                }, cancellationToken);

                if (command.Status == "SUCCESS" || command.Status == "OK" || command.Status == "Success")
                {
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                        Body = $"سفارش شما به شماره {command.OrderNumber}# با موفقیت پرداخت شد",
                        Email = command.Email
                    }, cancellationToken);


                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = command.Mobile,
                        Pattern = 61038,
                        Code = command.OrderNumber.ToString()
                    }, cancellationToken);
                }
            }
            else if (dbResultGetTransaction.Data.WalletId != null)
            {
                var dbResultUpdateTransactionWallet = await _ITransActionContext.Update_Transaction_Wallet(new Update_Transaction_Wallet.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = command.PaidAmount != null && command.PaidAmount > 0 ? price : 0,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode
                }, cancellationToken);
                if (command.Status == "SUCCESS" || command.Status == "OK" || command.Status == "Success")
                {
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"شارژ موفق کیف پول",
                        Body = $"شارژ کیف پول شما به مبلغ {price.moneyFormat()} تومان با موفقیت انجام شد",
                        Email = dbResultUpdateTransactionWallet.Data.Email
                    }, cancellationToken);

                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResultUpdateTransactionWallet.Data.Mobile,
                        Pattern = 61050,
                        Code = price.moneyFormat()
                    }, cancellationToken);
                }

            }

            return new DBResult(new { });

        }

        public async Task<DBResult> VerifyPayByAdmin(VerifyPayByAdminCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);

            var dbResultGetTransaction = await _ITransActionContext.GetTransActionByPaidCode(new GetTransActionByPaidCode.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal? price = 0;
            if (dbResultGetTransaction.Data.OnlinePortal == (int)OnlinePortal.ZarinLink)
            {
                price = Convert.ToDecimal(command.PaidAmount);
            }
            else
            {
                price = Convert.ToDecimal(command.PaidAmount) / 10;
            }

            if (dbResultGetTransaction.Data.OnlinePortal == (int)OnlinePortal.Zarinpal)
            {
                await _zarinpalService.verifyAutoTransAction(new VerifyAutoTransActionZarinpal
                {
                    PaidAmount = Convert.ToInt64(command.PaidAmount),
                    PurchaseId = command.PurchaseId
                }, cancellationToken);
            }
            if (dbResultGetTransaction.Data.OrderId != null)
            {
                var dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction(new Update_Transaction.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = command.PaidAmount != null && command.PaidAmount > 0 ? price : 0,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode,
                    MaximummPrice = maximumAmountOnlinePort
                }, cancellationToken);

                if (command.Status == "SUCCESS" || command.Status == "OK" || command.Status == "Success")
                {
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"پرداخت موفق سفارش #{command.OrderNumber}",
                        Body = $"سفارش شما به شماره {command.OrderNumber}# با موفقیت پرداخت شد",
                        Email = command.Email
                    }, cancellationToken);


                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = command.Mobile,
                        Pattern = 61038,
                        Code = command.OrderNumber.ToString()
                    }, cancellationToken);
                }
            }
            else if (dbResultGetTransaction.Data.WalletId != null)
            {
                var dbResultUpdateTransactionWallet = await _ITransActionContext.Update_Transaction_Wallet(new Update_Transaction_Wallet.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = command.PaidAmount != null && command.PaidAmount > 0 ? price : 0,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode
                }, cancellationToken);

                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"شارژ موفق کیف پول",
                    Body = $"شارژ کیف پول شما به مبلغ {price.moneyFormat()} تومان با موفقیت انجام شد",
                    Email = dbResultUpdateTransactionWallet.Data.Email
                }, cancellationToken);

                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResultUpdateTransactionWallet.Data.Mobile,
                    Pattern = 61050,
                    Code = price.moneyFormat()
                }, cancellationToken);
            }

            return new DBResult(new { });

        }
        public async Task<DBResult<bool>> InquiryPayByAdmin(InquiryPayByAdminCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var response = await _ITransActionContext.GetTransActionsByAdmin(new GetTransActionsByAdmin.Inputs
            {
                TransActionId = command.TransActionId,
                Token = token
            }, cancellationToken);
            var transAction = response.Data.FirstOrDefault();
            if (transAction.IsPaid == true)
            {
                throw new LogicalException("وضعیت این تراکنش پرداخت شده می باشد");
            }
            if (string.IsNullOrWhiteSpace(transAction.PaidCode))
            {
                throw new LogicalException("این تراکنش کد پرداخت ندارد");
            }

            if (transAction.OnlinePortal == (int)OnlinePortal.Jibit)
            {
                var responseJibit = await _jibitService.getPay(new GetPayJibitCommand { PurchaseId = transAction.PaidCode }, cancellationToken, false);
                if (responseJibit != null && responseJibit.Data != null && responseJibit.Data.state == "SUCCESS")
                {
                    if (transAction.IsPaid == null || transAction.IsPaid == false)
                    {
                        await VerifyPayByAdmin(new VerifyPayByAdminCommand
                        {
                            PurchaseId = transAction.PaidCode,
                            Status = responseJibit.Data.state,
                            TransactionCode = responseJibit.Data.pspReferenceNumber,
                            TrackingCode = responseJibit.Data.clientReferenceNumber,
                            PaidAmount = responseJibit.Data.amount,
                            OnlinePortal = transAction.OnlinePortal,
                            OrderNumber = transAction.OrderNumber,
                            Email = transAction.Email,
                            Mobile = transAction.Mobile,
                        }, cancellationToken);
                        return new DBResult<bool>(true);
                    }
                }
                else if (responseJibit != null && responseJibit.Data != null && (responseJibit.Data.state == "FAILED"
                    || responseJibit.Data.state == "EXPIRED" || responseJibit.Data.state == "REVERSED"))
                {

                    await VerifyPayByAdmin(new VerifyPayByAdminCommand
                    {
                        PurchaseId = transAction.PaidCode,
                        Status = responseJibit.Data.state,
                        TransactionCode = responseJibit.Data.pspReferenceNumber,
                        TrackingCode = responseJibit.Data.clientReferenceNumber,
                        PaidAmount = responseJibit.Data.amount != null ? responseJibit.Data.amount : 0,
                        OnlinePortal = transAction.OnlinePortal,
                        OrderNumber = transAction.OrderNumber,
                        Email = transAction.Email,
                        Mobile = transAction.Mobile,
                    }, cancellationToken);
                    return new DBResult<bool>(true);

                }
                else if (responseJibit != null && responseJibit.Data != null && (responseJibit.Data.state == "UNKNOWN"
                    || responseJibit.Data.state == "READY_TO_VERIFY"))
                {
                    // Verify Bank
                }
            }
            else if (transAction.OnlinePortal == (int)OnlinePortal.Vandar)
            {
                var responseVandar = await _vandarService.getPay(new GetPayVandarCommand { PurchaseId = transAction.PaidCode }, cancellationToken, false);
                if (responseVandar != null && responseVandar.Data != null && responseVandar.Data.code == 2)
                {
                    if (transAction.IsPaid == null || transAction.IsPaid == false)
                    {
                        await VerifyPayByAdmin(new VerifyPayByAdminCommand
                        {
                            PurchaseId = transAction.PaidCode,
                            Status = "OK",
                            TransactionCode = responseVandar.Data.refnumber,
                            TrackingCode = responseVandar.Data.trackingCode,
                            PaidAmount = Convert.ToDecimal(responseVandar.Data.amount),
                            OnlinePortal = transAction.OnlinePortal,
                            OrderNumber = transAction.OrderNumber,
                            Email = transAction.Email,
                            Mobile = transAction.Mobile
                        }, cancellationToken);
                        return new DBResult<bool>(true);
                    }
                }
                if (responseVandar != null && responseVandar.Data != null && (responseVandar.Data.code == 0
                    || responseVandar.Data.code == 3 || responseVandar.Data.code == 4))
                {

                    await VerifyPayByAdmin(new VerifyPayByAdminCommand
                    {
                        PurchaseId = transAction.PaidCode,
                        Status = responseVandar.Data.message,
                        TransactionCode = responseVandar.Data.refnumber,
                        TrackingCode = responseVandar.Data.trackingCode,
                        PaidAmount = responseVandar.Data.amount != null ? Convert.ToDecimal(responseVandar.Data.amount) : 0,
                        OnlinePortal = transAction.OnlinePortal,
                        OrderNumber = transAction.OrderNumber,
                        Email = transAction.Email,
                        Mobile = transAction.Mobile,
                    }, cancellationToken);
                    return new DBResult<bool>(true);
                }

                if (responseVandar != null && responseVandar.Data != null && responseVandar.Data.code == 1)
                {
                    // Verify Bank
                }
            }
            else if (transAction.OnlinePortal == (int)OnlinePortal.Shepa)
            {
                if (transAction.SaveDate.Value.AddMinutes(20) < DateTimeHelper.GetLocalTime())
                {
                    var responseVandar = await _shepaService.getPay(new GetPayShepaCommand { PurchaseId = transAction.PaidCode }, cancellationToken);
                    if (responseVandar != null && responseVandar.Data != null && responseVandar.Data.success == true)
                    {
                        if (transAction.IsPaid == null || transAction.IsPaid == false)
                        {
                            await VerifyPayByAdmin(new VerifyPayByAdminCommand
                            {
                                PurchaseId = transAction.PaidCode,
                                Status = "OK",
                                TransactionCode = responseVandar.Data.result.transaction_id.ToString(),
                                TrackingCode = responseVandar.Data.result.refid.ToString(),
                                PaidAmount = responseVandar.Data.result.amount,
                                OnlinePortal = transAction.OnlinePortal,
                                OrderNumber = transAction.OrderNumber,
                                Email = transAction.Email,
                                Mobile = transAction.Mobile,
                            }, cancellationToken);
                            return new DBResult<bool>(true);
                        }
                    }
                    if (responseVandar != null && responseVandar.Data != null && responseVandar.Data.success == false
                        && responseVandar.Data.errors != null && responseVandar.Data.errors.Count > 0)
                    {

                        await VerifyPayByAdmin(new VerifyPayByAdminCommand
                        {
                            PurchaseId = transAction.PaidCode,
                            Status = responseVandar.Data.errors[0],
                            TransactionCode = responseVandar.Data.result != null ? responseVandar.Data.result.transaction_id.ToString() : null,
                            TrackingCode = responseVandar.Data.result != null ? responseVandar.Data.result.refid.ToString() : null,
                            PaidAmount = responseVandar.Data.result != null ? responseVandar.Data.result.amount : null,
                            OnlinePortal = transAction.OnlinePortal,
                            OrderNumber = transAction.OrderNumber,
                            Email = transAction.Email,
                            Mobile = transAction.Mobile,
                        }, cancellationToken);
                        return new DBResult<bool>(true);
                    }
                }

            }

            else if (transAction.OnlinePortal == (int)OnlinePortal.Zarinpal)
            {
                var responseZarinpal = await _zarinpalService.getUnverifiedPay(new GetUnverifiedPayZarinpalCommand { }
                , cancellationToken, false);
                if (responseZarinpal != null && responseZarinpal.Data != null && responseZarinpal.Data.Count > 0)
                {
                    foreach (var item in responseZarinpal.Data)
                    {
                        if (item.authority == transAction.PaidCode)
                        {
                            if (transAction.IsPaid == null || transAction.IsPaid == false)
                            {
                                await VerifyPayByAdmin(new VerifyPayByAdminCommand
                                {
                                    PurchaseId = item.authority,
                                    Status = "Success",
                                    TransactionCode = "",
                                    TrackingCode = "",
                                    PaidAmount = item.amount,
                                    OnlinePortal = transAction.OnlinePortal,
                                    OrderNumber = transAction.OrderNumber,
                                    Email = transAction.Email,
                                    Mobile = transAction.Mobile,
                                }, cancellationToken);
                                return new DBResult<bool>(true);
                            }
                        }

                    }

                }



            }

            else if (transAction.OnlinePortal == (int)OnlinePortal.Sepal)
            {
                var responseSepal = await _sepalService.GetPay(new GetPayJibitCommand { PurchaseId = transAction.PaidCode }
                , cancellationToken, false);
                if (responseSepal != null && responseSepal.Data != null
                    && (transAction.IsPaid == null || transAction.IsPaid == false))
                {
                    await VerifyPayByAdmin(new VerifyPayByAdminCommand
                    {
                        PurchaseId = responseSepal.Data.paymentNumber,
                        Status = responseSepal.Data.state == "1" ? "Success" : responseSepal.Data.stateLabel,
                        TransactionCode = "",
                        TrackingCode = "",
                        PaidAmount = transAction.PaidAmount.toRial(),
                        OnlinePortal = transAction.OnlinePortal,
                        OrderNumber = transAction.OrderNumber,
                        Email = transAction.Email,
                        Mobile = transAction.Mobile,
                    }, cancellationToken);
                    if (responseSepal.Data.state != "1")
                    {
                        return new DBResult<bool>(false);
                    }
                    return new DBResult<bool>(true);

                }



            }

            else if (transAction.OnlinePortal == (int)OnlinePortal.ZarinLink)
            {
                var responseZarinLink = await _zarinLinkService.getPay(new GetPayShepaCommand { PurchaseId = transAction.PaidCode }, cancellationToken, false);
                if (responseZarinLink != null && responseZarinLink.Data != null && !string.IsNullOrWhiteSpace(responseZarinLink.Data.TrackingCode))
                {
                    if (transAction.IsPaid == null || transAction.IsPaid == false)
                    {
                        await VerifyPayByAdmin(new VerifyPayByAdminCommand
                        {
                            PurchaseId = transAction.PaidCode,
                            Status = "OK",
                            TransactionCode = responseZarinLink.Data.TransactionCode,
                            TrackingCode = responseZarinLink.Data.TrackingCode,
                            PaidAmount = responseZarinLink.Data.PaidAmount,
                            OnlinePortal = transAction.OnlinePortal,
                            OrderNumber = transAction.OrderNumber,
                            Email = transAction.Email,
                            Mobile = transAction.Mobile,
                        }, cancellationToken);
                        return new DBResult<bool>(true);
                    }
                }

            }
            return new DBResult<bool>(false);
        }
    }
}
