﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.IPPG;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.API.Sepal;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.PPG
{
    public class SepalService : ISepalService
    {
        private readonly IOrderContext _IOrderContext;
        private readonly IQueueContext _queueContext;
        private readonly ISettingContext _ISettingContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpRequestSepalPPG _httpRequestSepalPPG;
        private readonly ITokenUserService _tokenUserService;
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public SepalService(IAutomaticOrderOperationService IAutomaticOrderOperationService
            , ISettingContext iSettingContext, IOrderContext iOrderContext
            , ITransActionContext iTransActionContext, IHttpRequestSepalPPG httpRequestSepalPPG, ITokenUserService tokenUserService,
            IRedisContextService redisContextService, IQueueContext queueContext, IHttpContextAccessor httpContextAccessor)
        {
            _tokenUserService = tokenUserService;
            _httpRequestSepalPPG = httpRequestSepalPPG;
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _ISettingContext = iSettingContext;
            _IOrderContext = iOrderContext;
            _ITransActionContext = iTransActionContext;
            _redisContextService = redisContextService;
            _queueContext = queueContext;
            _httpContextAccessor = httpContextAccessor;
        }


        public async Task<DBResult> StartPay(StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            if(dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException(MessageHelper.NotFoundOrder);
            }

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = true
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }

            var settingOrder = await _redisContextService.getSettingOrderAsync(dbResultOrder.Data.OrderType, token, cancellationToken);


            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortal(
            new CheckBankAccountClientPortalCommand
            {
                BankAccountId = command.BankAccountId,
                CheckBankAccount = settingOrder.CheckBankAccount,
                Token = token
            }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);
            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : (dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0) ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
settingOrder.IsActiveOnlinePayMultiple);
            string cardNumber = null;
            if (settingOrder.CheckBankAccount)
            {
                cardNumber = dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber;
            }
            var responsePurchasesSepalPPG = await _httpRequestSepalPPG.PurchaseSepalPPG(new SepalPayRequestModel
            {
                amount = finalAmountToman.toRial(),
                apiKey = webServiceInfo.RealApiKey,
                callbackUrl = (string)config["callback"] + ("?returnUrl=" + command.ReturnUrl).Trim(),
                invoiceNumber = dbResultOrder.Data.OrderNumber.ToString(),
                description = "سفارش شماره " + dbResultOrder.Data.OrderNumber,
                freeze_card_number = cardNumber
            }, webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesSepalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesSepalPPG.status == false)
                throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");


            await _ITransActionContext.Insert_Transaction(new Insert_Transaction.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesSepalPPG.paymentNumber,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Sepal,
                Code = command.Code
            }, cancellationToken);
            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesSepalPPG.paymentNumber, IsFree = false }, 1);
        }

        public async Task<DBResult> StartPayPublic(StartPayPublicOrderCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderNumber = command.OrderNumber,
                Code = command.Code
            }, cancellationToken);
            if (dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException(MessageHelper.NotFoundOrder);
            }
            command.OrderId = dbResultOrder.Data.OrderId;
            var settingOrder = await _redisContextService.getSettingOrderWithoutTokenAsync(dbResultOrder.Data.OrderType,
                command.OrderId, cancellationToken);

            if (settingOrder.IsActiveSepal == null || settingOrder.IsActiveSepal == false)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");


            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = false
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortalWithoutToken(
            new CheckBankAccountClientPortalCommand
            {
                BankAccountId = command.BankAccountId,
                CheckBankAccount = settingOrder.CheckBankAccount
            }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);


            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
settingOrder.IsActiveOnlinePayMultiple);
            string cardNumber = null;
            if (settingOrder.CheckBankAccount)
            {
                cardNumber = dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber;
            }
            var responsePurchasesSepalPPG = await _httpRequestSepalPPG.PurchaseSepalPPG(new SepalPayRequestModel
            {
                amount = finalAmountToman.toRial(),
                apiKey = webServiceInfo.RealApiKey,
                callbackUrl = (string)config["callback"],
                description = "سفارش شماره " + dbResultOrder.Data.OrderNumber,
                invoiceNumber = dbResultOrder.Data.OrderNumber.ToString(),
                freeze_card_number = cardNumber
            }, webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesSepalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesSepalPPG.status == false)
                throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");


            await _ITransActionContext.Insert_Transaction_WithoutToken(new Insert_Transaction_WithoutToken.Inputs
            {
                UserId = dbResultOrder.Data.UserId,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesSepalPPG.paymentNumber,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Sepal,
                Code = command.Code
            }, cancellationToken);
            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesSepalPPG.paymentNumber, IsFree = false }, 1);
        }

        public async Task<DBResult> VerifyPay(VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultUpdateTransaction = new DBResult<Update_Transaction.Outputs>();
            var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;

            command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();

            decimal price = command.PaidAmount.cleanPrice();

            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction(new Check_Duplicate_Transaction.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode
                });
            }

            if (command.Status == "OK")
            {
                var responsePurchasesSepalPPG = new SepalVerifyResponseModel();
                responsePurchasesSepalPPG = await _httpRequestSepalPPG.VerifySepalPPG(new SepalVerifyRequestModel { apiKey = webServiceInfo.RealApiKey, 
                    paymentNumber = Convert.ToInt64(command.PurchaseId) }
                , webServiceInfo.BaseUrlService, cancellationToken);

                var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);


                if (responsePurchasesSepalPPG != null && responsePurchasesSepalPPG.status == false)
                {
                    var dbResultUpdateStatus = await _IOrderContext.Update_Order_Status_WithouToken(new Update_Order_Status_WithouToken.Inputs
                    {
                        OrderId = dbResultGetTransactionOrder.Data.OrderId,
                        Status = (int)OrderStatus.NotConfirmed
                    }, cancellationToken);
                    throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");
                }

                if (responsePurchasesSepalPPG.status == true)
                {
                    var trackingCode = Guid.NewGuid().ToString();
                    dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction(new Update_Transaction.Inputs
                    {
                        TransactionCode = command.TransactionCode,
                        PaidAmount = price,
                        PaidCode = command.PurchaseId,
                        Status = command.Status,
                        TrackingCode = trackingCode,
                        MaximummPrice = maximumAmountOnlinePort
                    }, cancellationToken);

                    if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                    {
                        return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                        {
                            Status = command.Status,
                            Setting = setting,
                            FinalAmount = price,
                            OrderId = dbResultUpdateTransaction.Data.OrderId,
                            TrackingCode = trackingCode,
                            CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode
                        });
                    }

                    if (dbResultUpdateTransaction.Data.StatusOrder != null && dbResultUpdateTransaction.Data.StatusOrder == 192)
                    {
                        return await _IAutomaticOrderOperationService.DoCompeleteScenario(new DoCompeleteScenarioCommand
                        {
                            OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                            Email = dbResultUpdateTransaction.Data.Email,
                            Mobile = dbResultUpdateTransaction.Data.Mobile,
                            OrderId = dbResultUpdateTransaction.Data.OrderId,
                            OrderType = dbResultUpdateTransaction.Data.OrderType,
                            RemainingAmount = dbResultUpdateTransaction.Data.RemainingAmount,
                            StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                            FinalAmount = dbResultUpdateTransaction.Data.FinalAmount,
                            Status = "OK",
                            CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                            TrackingCode = trackingCode,
                            Setting = setting,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            ModuleType = dbResultUpdateTransaction.Data.SaveLocation
                        }, cancellationToken);
                    }

                    return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                    {
                        Email = dbResultUpdateTransaction.Data.Email,
                        Mobile = dbResultUpdateTransaction.Data.Mobile,
                        OrderId = dbResultUpdateTransaction.Data.OrderId,
                        OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                        OrderType = dbResultUpdateTransaction.Data.OrderType,
                        PurchaseId = command.PurchaseId,
                        ValueType = dbResultUpdateTransaction.Data.ValueType,
                        Status = "OK",
                        StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                        Commission = dbResultUpdateTransaction.Data.Commission,
                        EmailCompanyUser = dbResultUpdateTransaction.Data.EmailCompanyUser,
                        MobileCompanyUser = dbResultUpdateTransaction.Data.MobileCompanyUser,
                        TransactionType = dbResultUpdateTransaction.Data.TransactionType,
                        CooperRewardToman = dbResultUpdateTransaction.Data.CooperRewardToman,
                        NumberOfSuccessfulOrders = dbResultUpdateTransaction.Data.NumberOfSuccessfulOrders,
                        FinalAmount = price.ToString(),
                        TrackingCode = trackingCode,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                        Setting = setting,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode
                    }, cancellationToken);

                }


            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                OrderId = dbResultGetTransactionOrder.Data.OrderId,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode
            });

        }

        public async Task<DBResult> StartPayChargeWallet(StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            if ((setting.IsActiveOnlinePaySingle == null || setting.IsActiveOnlinePaySingle == false))
            {
                throw new LogicalException("روش پرداخت درگاه آنلاین غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");
            }

            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);
            var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(setting.MinimumAmountOnlinePort);

            var finalAmountToman = Convert.ToDecimal(command.PaidAmount);
            finalAmountToman.ValidatePaymentAmount(maximumAmountOnlinePort, minimumAmountOnlinePort);
            var responseCheckTransaction = await _ITransActionContext.Check_TransAction_Wallet(new Check_TransAction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            var responsePurchasesSepalPPG = await _httpRequestSepalPPG.PurchaseSepalPPG(new SepalPayRequestModel
            {
                amount = finalAmountToman.toRial(),
                apiKey = webServiceInfo.RealApiKey,
                callbackUrl = (string)config["callbackWallet"] + ("?returnUrl=" + command.CallbackUrl).Trim(),
                description = "شارژ کیف پول آقا/خانم " + responseCheckTransaction.Data.Name + " " + responseCheckTransaction.Data.Family + " با شماره همراه: " + responseCheckTransaction.Data.Mobile + " و ایمیل: " + responseCheckTransaction.Data.Email,
                invoiceNumber = responseCheckTransaction.Data.WalletId.ToString()
            }, webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesSepalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesSepalPPG.status == false)
                throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");


            await _ITransActionContext.Insert_Transaction_Wallet(new Insert_Transaction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesSepalPPG.paymentNumber,
                TrackingCode = null,
                OnlinePortal = (int)OnlinePortal.Sepal,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesSepalPPG.paymentNumber }, 1);
        }

        public async Task<DBResult> VerifyChargeWallet(VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;
            command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();
            decimal price = command.PaidAmount.cleanPrice();

            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction_Wallet(new Check_Duplicate_Transaction_Wallet.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode,
                    WalletId = dbResultCheckTransaction.Data.WalletId
                });
            }

            if (command.Status == "OK")
            {
                var trackingCode = Guid.NewGuid().ToString();
                var responsePurchasesSepalPPG = new SepalVerifyResponseModel();

                responsePurchasesSepalPPG = await _httpRequestSepalPPG.VerifySepalPPG(new SepalVerifyRequestModel
                {
                    apiKey = webServiceInfo.RealApiKey
                    ,
                    paymentNumber = Convert.ToInt64(command.PurchaseId)
                }
                , webServiceInfo.BaseUrlService, cancellationToken);

                if (responsePurchasesSepalPPG == null)
                {
                    throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
                }

                if (responsePurchasesSepalPPG.status == false)
                {
                    throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");
                }

                if (responsePurchasesSepalPPG.status == true)
                {
                    var dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction_Wallet(new Update_Transaction_Wallet.Inputs
                    {
                        TransactionCode = command.TransactionCode,
                        PaidAmount = price,
                        PaidCode = command.PurchaseId,
                        Status = command.Status,
                        TrackingCode = trackingCode
                    }, cancellationToken);

                    if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                    {
                        return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                        {
                            Status = "OK",
                            FinalAmount = price,
                            TrackingCode = trackingCode,
                            Setting = setting,
                            CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            WalletId = dbResultUpdateTransaction.Data.WalletId
                        });
                    }

                    return await _IAutomaticOrderOperationService.doCompeleteWalletCharge(
                    new DoCompeleteWalletCharge
                    {
                        PaidAmount = dbResultUpdateTransaction.Data.PaidAmount,
                        Email = dbResultUpdateTransaction.Data.Email,
                        Mobile = dbResultUpdateTransaction.Data.Mobile,
                        Status = "OK",
                        TrackingCode = trackingCode,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                        Setting = setting,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                        WalletId = dbResultUpdateTransaction.Data.WalletId
                    }, cancellationToken);
                }

                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    FinalAmount = price,
                    TrackingCode = trackingCode,
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode,
                    WalletId = dbResultCheckTransaction.Data.WalletId
                });

            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode,
                WalletId = dbResultCheckTransaction.Data.WalletId,
            });
        }

        public async Task<bool> VerifyAutoTransAction(VerifyAutoTransActionZarinpal command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var responsePurchasesSepalPPG = new SepalVerifyResponseModel();

            responsePurchasesSepalPPG = await _httpRequestSepalPPG.VerifySepalPPG(new SepalVerifyRequestModel
            {
                apiKey = webServiceInfo.RealApiKey
                ,
                paymentNumber = Convert.ToInt64(command.PurchaseId)
            }
            , webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesSepalPPG == null)
            {
                throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
            }

            if (responsePurchasesSepalPPG.status == false)
            {
                throw new ExternalServiceException($"{responsePurchasesSepalPPG.message}");
            }



            if (responsePurchasesSepalPPG.status == true)
            {
                return true;
            }



            return false;

        }

        public async Task<DBResult<SepalGetStateItemResponseModel>> GetPay(GetPayJibitCommand command, CancellationToken cancellationToken, bool checkJobToken = true)
        {
            if (checkJobToken)
            {
                var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
                if (dbSetting.Data.JobToken != command.JobToken)
                {
                    throw new LogicalException("کلید اتصال نامعتبر می باشد");
                }
            }
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);


            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResult = await _queueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.Sepal }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.SepalToken))
            {
                var responseSepalToken = await _httpRequestSepalPPG.GetToken(webServiceInfo.Username, webServiceInfo.RealPassword,
                    webServiceInfo.BaseUrlService, cancellationToken);
                if (responseSepalToken == null || responseSepalToken.data == null || string.IsNullOrWhiteSpace(responseSepalToken.data.token))
                {
                    throw new ExternalServiceException("خطا در دریافت امضای درگاه پرداخت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                }

                dbResult.Data.SepalToken = responseSepalToken.data.token;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { SepalToken = responseSepalToken.data.token }, cancellationToken);
            }


            var responseSepal = new SepalGetStateResponseModel();
            responseSepal = await _httpRequestSepalPPG.GetState(command.PurchaseId, webServiceInfo.BaseUrlService, dbResult.Data.SepalToken, cancellationToken);

            if (responseSepal != null && responseSepal.code == 401)
            {
                var responseSepalToken = await _httpRequestSepalPPG.GetToken(webServiceInfo.Username, webServiceInfo.RealPassword,
                    webServiceInfo.BaseUrlService, cancellationToken);
                if (responseSepalToken == null || responseSepalToken.data == null || string.IsNullOrWhiteSpace(responseSepalToken.data.token))
                {
                    throw new ExternalServiceException("خطا در دریافت امضای درگاه پرداخت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                }

                dbResult.Data.SepalToken = responseSepalToken.data.token;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { SepalToken = responseSepalToken.data.token }, cancellationToken);
                responseSepal = await _httpRequestSepalPPG.GetState(command.PurchaseId, webServiceInfo.BaseUrlService, dbResult.Data.SepalToken, cancellationToken);
            }

            if (responseSepal != null && (responseSepal.status == null || responseSepal.status == false))
                throw new ExternalServiceException($"{responseSepal.message}");

            if (responseSepal != null)
            {
                return new DBResult<SepalGetStateItemResponseModel> { Data = responseSepal.item };
            }

            throw new ExternalServiceException("تراکنش یافت نشد");

        }

        public async Task<DBResult<List<SepalGetStateListItemsResponseModel>>> GetPayReport(GetPayJibitCommand command, CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResult = await _queueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.Sepal }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.SepalToken))
            {
                var responseSepalToken = await _httpRequestSepalPPG.GetToken(webServiceInfo.Username, webServiceInfo.RealPassword,
                    webServiceInfo.BaseUrlService, cancellationToken);
                if (responseSepalToken == null || responseSepalToken.data == null || string.IsNullOrWhiteSpace(responseSepalToken.data.token))
                {
                    throw new ExternalServiceException("خطا در دریافت امضای درگاه پرداخت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                }

                dbResult.Data.SepalToken = responseSepalToken.data.token;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { SepalToken = responseSepalToken.data.token }, cancellationToken);
            }


            var responseSepal = new SepalGetStateListResponseModel();
            responseSepal = await _httpRequestSepalPPG.GetStateList(new SepalInquiryRequestModel
            {
                limit = command.Size,
                page = command.Page,
                dateFrom = !string.IsNullOrWhiteSpace(command.FromJalali) ? command.FromJalali : null,
                dateTo = !string.IsNullOrWhiteSpace(command.ToJalali) ? command.ToJalali : null
            }, webServiceInfo.BaseUrlService, dbResult.Data.SepalToken, cancellationToken);

            if (responseSepal != null && responseSepal.code == 401)
            {
                var responseSepalToken = await _httpRequestSepalPPG.GetToken(webServiceInfo.Username, 
                    webServiceInfo.RealPassword,
                    webServiceInfo.BaseUrlService, cancellationToken);
                if (responseSepalToken == null || responseSepalToken.data == null || string.IsNullOrWhiteSpace(responseSepalToken.data.token))
                {
                    throw new ExternalServiceException("خطا در دریافت امضای درگاه پرداخت ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                }

                dbResult.Data.SepalToken = responseSepalToken.data.token;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { SepalToken = responseSepalToken.data.token }, cancellationToken);
                responseSepal = await _httpRequestSepalPPG.GetStateList(new SepalInquiryRequestModel
                {
                    limit = command.Size,
                    page = command.Page,
                    dateFrom = command.From != null ? command.From.Value.ToString() : null,
                    dateTo = command.To != null ? command.To.Value.ToString() : null
                }, webServiceInfo.BaseUrlService, dbResult.Data.SepalToken, cancellationToken);
            }

            if (responseSepal != null && (responseSepal.status == null || responseSepal.status == false))
                throw new ExternalServiceException($"{responseSepal.message}");

            if (responseSepal != null)
            {
                return new DBResult<List<SepalGetStateListItemsResponseModel>> { Data = responseSepal.items,ActualSize = responseSepal.limit.HasValue && responseSepal.totalPages.HasValue?(responseSepal.limit.Value * responseSepal.totalPages.Value):0 };
            }

            throw new ExternalServiceException("خطا در دریافت گزارش");

        }


    }
}
