﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.IPPG;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.Shepa;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.PPG
{
    public class ShepaService : IShepaService
    {
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IOrderContext _IOrderContext;
        private readonly ISettingContext _ISettingContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly IHttpRequestShepaPPG _httpRequestShepaPPG;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public ShepaService(IAutomaticOrderOperationService IAutomaticOrderOperationService
            , ISettingContext iSettingContext, IOrderContext iOrderContext
            , ITransActionContext iTransActionContext,
            IHttpRequestShepaPPG httpRequestShepaPPG, ITokenUserService tokenUserService
            , IRedisContextService redisContextService,
            IHttpContextAccessor httpContextAccessor)
        {
            _httpRequestShepaPPG = httpRequestShepaPPG;
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _ISettingContext = iSettingContext;
            _IOrderContext = iOrderContext;
            _ITransActionContext = iTransActionContext;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
            _httpContextAccessor = httpContextAccessor;
        }

        public async Task<DBResult> startPay(StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            if (dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException(MessageHelper.NotFoundOrder);
            }

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = true
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }

            var settingOrder = await _redisContextService.getSettingOrderAsync(dbResultOrder.Data.OrderType,token
                ,cancellationToken);
      
        
            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortal(
            new CheckBankAccountClientPortalCommand
            {
                BankAccountId = command.BankAccountId,
                CheckBankAccount = settingOrder.CheckBankAccount,
                Token = token
            }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);

            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
                minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
                settingOrder.IsActiveOnlinePayMultiple);
       

            var responsePurchasesShepaPPG = await _httpRequestShepaPPG.purchaseShepaPPG(new RequestPurchasesShepaPPG
            {
                amount = finalAmountToman.toRial(),
                api = webServiceInfo.RealApiKey,
                callback = (string)config["callbac"],

                cardnumber = settingOrder.CheckBankAccount ? dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber : null
            }, webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesShepaPPG == null)
            {
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");
            }

            if (responsePurchasesShepaPPG.errors != null && responsePurchasesShepaPPG.errors.Count > 0)
                throw new ExternalServiceException($"{responsePurchasesShepaPPG.errors[0]}");


            await _ITransActionContext.Insert_Transaction(new Insert_Transaction.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesShepaPPG.result.token,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Shepa,
                Code = command.Code
            }, cancellationToken);

            return new DBResult(new { redirectUrl = responsePurchasesShepaPPG.result.url, IsFree = false
                
            }, 1);
        }


        public async Task<DBResult> startPayPublic(StartPayPublicOrderCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderNumber = command.OrderNumber,
                Code = command.Code
            }, cancellationToken);

            command.OrderId = dbResultOrder.Data.OrderId;

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);
            var settingOrder = await _redisContextService.getSettingOrderWithoutTokenAsync(dbResultOrder.Data.OrderType,
    command.OrderId, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = false
            }, cancellationToken);

            if (responseFreeOrder != null)
                return responseFreeOrder;

            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortalWithoutToken(
             new CheckBankAccountClientPortalCommand
             {
                 BankAccountId = command.BankAccountId,
                 CheckBankAccount = settingOrder.CheckBankAccount
             }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);

            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
      minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
      settingOrder.IsActiveOnlinePayMultiple);
            var responsePurchasesShepaPPG = await _httpRequestShepaPPG.purchaseShepaPPG(new RequestPurchasesShepaPPG
            {
                amount = finalAmountToman.toRial(),
                api = webServiceInfo.RealApiKey,
                callback = (string)config["callback"],

                cardnumber = settingOrder.CheckBankAccount ? dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber : null
            }, webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesShepaPPG == null)
            {
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");
            }

            if (responsePurchasesShepaPPG.errors != null && responsePurchasesShepaPPG.errors.Count > 0)
                throw new ExternalServiceException($"{responsePurchasesShepaPPG.errors[0]}");


            await _ITransActionContext.Insert_Transaction_WithoutToken(new Insert_Transaction_WithoutToken.Inputs
            {
                UserId = dbResultOrder.Data.UserId,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesShepaPPG.result.token,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Shepa,
                Code = command.Code
            }, cancellationToken);
            return new DBResult(new { redirectUrl = responsePurchasesShepaPPG.result.url, IsFree = false }, 1);
        }

        public async Task<DBResult> verifyPay(VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction(new Check_Duplicate_Transaction.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = command.Status,
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    FinalAmount = dbResultCheckTransaction.Data.PaidAmount,
                    OrderId = dbResultCheckTransaction.Data.OrderId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode
                });
            }

            var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);
            
            var dbResultUpdateTransaction = new DBResult<Update_Transaction.Outputs>();

            if (command.Status == "success")
            {
                var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
                {
                    PaidCode = command.PurchaseId
                }, cancellationToken);
                decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;

                command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();

                decimal price = 0;
                if (command.PaidAmount.ToString().Contains("."))
                    price = Convert.ToDecimal(command.PaidAmount.ToString().Split(".")[0]);
                else
                    price = Convert.ToDecimal(command.PaidAmount);

                var responsePurchasesVerifyShepaPPG = new ResponseVerifyShepaPPG();

                responsePurchasesVerifyShepaPPG = await _httpRequestShepaPPG.verifyShepaPPG(new RequestVerifyShepaPPG { api = webServiceInfo.RealApiKey, 
                    token = command.PurchaseId, amount = price.toRial() }
                , webServiceInfo.BaseUrlService, cancellationToken);

                if (responsePurchasesVerifyShepaPPG == null || responsePurchasesVerifyShepaPPG.result == null)
                {
                    throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
                }

                if (responsePurchasesVerifyShepaPPG != null && responsePurchasesVerifyShepaPPG.result != null)
                {
                    command.TrackingCode = responsePurchasesVerifyShepaPPG.result.refid != null ? responsePurchasesVerifyShepaPPG.result.refid.ToString() : null;
                    command.TransactionCode = responsePurchasesVerifyShepaPPG.result.transaction_id != null ? responsePurchasesVerifyShepaPPG.result.transaction_id.ToString() : null;
                    command.PaidAmount = responsePurchasesVerifyShepaPPG.result.amount != null ? responsePurchasesVerifyShepaPPG.result.amount.ToString() : null;
                }

                if (responsePurchasesVerifyShepaPPG != null && responsePurchasesVerifyShepaPPG.errors != null && responsePurchasesVerifyShepaPPG.errors.Count > 0)
                {

                    var dbResultUpdateStatus = await _IOrderContext.Update_Order_Status_WithouToken(new Update_Order_Status_WithouToken.Inputs
                    {
                        OrderId = dbResultGetTransactionOrder.Data.OrderId,
                        Status = (int)OrderStatus.NotConfirmed
                    }, cancellationToken);
                    throw new ExternalServiceException($"{responsePurchasesVerifyShepaPPG.errors[0]}");
                }

                if (command.PaidAmount.ToString().Contains("."))
                    price = Convert.ToDecimal(command.PaidAmount.ToString().Split(".")[0]);
                else
                    price = Convert.ToDecimal(command.PaidAmount);

                dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction(new Update_Transaction.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = paidAmountOrder,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode,
                    MaximummPrice = maximumAmountOnlinePort
                }, cancellationToken);

                if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                {
                    return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                    {
                        Status = command.Status,
                        Setting = setting,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                        OrderId = dbResultUpdateTransaction.Data.OrderId,
                        FinalAmount = dbResultUpdateTransaction.Data.FinalAmount,
                        TrackingCode = dbResultUpdateTransaction.Data.TrackingCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode
                    });

                }

                if (responsePurchasesVerifyShepaPPG.success == true && responsePurchasesVerifyShepaPPG.result != null
                    && (responsePurchasesVerifyShepaPPG.result.isDuplicate == null || responsePurchasesVerifyShepaPPG.result.isDuplicate == false))
                {
                    responsePurchasesVerifyShepaPPG.message = null;
                    if (dbResultUpdateTransaction.Data.StatusOrder != null && dbResultUpdateTransaction.Data.StatusOrder == 192)
                    {
                        return await _IAutomaticOrderOperationService.DoCompeleteScenario(new DoCompeleteScenarioCommand
                        {
                            OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                            Email = dbResultUpdateTransaction.Data.Email,
                            Mobile = dbResultUpdateTransaction.Data.Mobile,
                            OrderId = dbResultUpdateTransaction.Data.OrderId,
                            OrderType = dbResultUpdateTransaction.Data.OrderType,
                            RemainingAmount = dbResultUpdateTransaction.Data.RemainingAmount,
                            StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                            result = responsePurchasesVerifyShepaPPG.result,
                            FinalAmount = dbResultUpdateTransaction.Data.FinalAmount,
                            Status = "OK",
                            CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                            Setting = setting,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            TrackingCode = dbResultUpdateTransaction.Data.TrackingCode,
                            ModuleType = dbResultUpdateTransaction.Data.SaveLocation
                        }, cancellationToken);

                    }
                    return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                    {
                        Email = dbResultUpdateTransaction.Data.Email,
                        Mobile = dbResultUpdateTransaction.Data.Mobile,
                        OrderId = dbResultUpdateTransaction.Data.OrderId,
                        OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                        OrderType = dbResultUpdateTransaction.Data.OrderType,
                        PurchaseId = command.PurchaseId,
                        ValueType = dbResultUpdateTransaction.Data.ValueType,
                        Status = "OK",
                        StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                        resultVerify = responsePurchasesVerifyShepaPPG.result,
                        Commission = dbResultUpdateTransaction.Data.Commission,
                        EmailCompanyUser = dbResultUpdateTransaction.Data.EmailCompanyUser,
                        MobileCompanyUser = dbResultUpdateTransaction.Data.MobileCompanyUser,
                        TransactionType = dbResultUpdateTransaction.Data.TransactionType,
                        CooperRewardToman = dbResultUpdateTransaction.Data.CooperRewardToman,
                        NumberOfSuccessfulOrders = dbResultUpdateTransaction.Data.NumberOfSuccessfulOrders,
                        FinalAmount = dbResultUpdateTransaction.Data.FinalAmount.ToString(),
                        CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                        Setting = setting,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                        TrackingCode = dbResultUpdateTransaction.Data.TrackingCode
                    }, cancellationToken);

                }


            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                OrderId = dbResultCheckTransaction.Data.OrderId,
                FinalAmount = dbResultCheckTransaction.Data.PaidAmount,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode
            });

        }

        public async Task<DBResult> startPayChargeWallet(StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            if ((setting.IsActiveOnlinePaySingle == null || setting.IsActiveOnlinePaySingle == false))
            {
                throw new LogicalException("روش پرداخت درگاه آنلاین غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");
            }

            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);

            var finalAmountToman = Convert.ToDecimal(command.PaidAmount);
            finalAmountToman.ValidatePaymentAmount(Convert.ToDecimal(setting.MaximumAmountOnlinePort)
                , Convert.ToDecimal(setting.MinimumAmountOnlinePort));
          
            await _ITransActionContext.Check_TransAction_Wallet(new Check_TransAction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            var responsePurchasesShepaPPG = await _httpRequestShepaPPG.purchaseShepaPPG(new RequestPurchasesShepaPPG
            {
                amount = finalAmountToman.toRial(),
                api = webServiceInfo.RealApiKey,
                callback = (string)config["callbackWallet"] + ("?returnUrl=" + command.CallbackUrl).Trim()
            }, webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesShepaPPG == null)
            {
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");
            }

            if (responsePurchasesShepaPPG.errors != null && responsePurchasesShepaPPG.errors.Count > 0)
                throw new ExternalServiceException($"{responsePurchasesShepaPPG.errors[0]}");


            await _ITransActionContext.Insert_Transaction_Wallet(new Insert_Transaction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesShepaPPG.result.token,
                TrackingCode = null,
                OnlinePortal = (int)OnlinePortal.Shepa,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            return new DBResult(new { redirectUrl = responsePurchasesShepaPPG.result.url }, 1);
        }

        public async Task<DBResult> verifyChargeWallet(VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

        
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction_Wallet(new Check_Duplicate_Transaction_Wallet.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    FinalAmount = dbResultCheckTransaction.Data.PaidAmount,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode,
                    WalletId = dbResultCheckTransaction.Data.WalletId
                });
 
            }

            if (command.Status == "success")
            {
                var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
                {
                    PaidCode = command.PurchaseId
                }, cancellationToken);
                decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;
                command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();
                decimal price = command.PaidAmount.cleanPrice();


                var responsePurchasesVerifyShepaPPG = new ResponseVerifyShepaPPG();
                responsePurchasesVerifyShepaPPG = await _httpRequestShepaPPG.verifyShepaPPG(new RequestVerifyShepaPPG
                { api = webServiceInfo.RealApiKey, token = command.PurchaseId, amount = price.toRial() }
                , webServiceInfo.BaseUrlService, cancellationToken);

                if (responsePurchasesVerifyShepaPPG == null || responsePurchasesVerifyShepaPPG.result == null)
                {
                    throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
                }

                if (responsePurchasesVerifyShepaPPG != null && responsePurchasesVerifyShepaPPG.result != null)
                {
                    command.TrackingCode = responsePurchasesVerifyShepaPPG.result.refid != null ? responsePurchasesVerifyShepaPPG.result.refid.ToString() : null;
                    command.TransactionCode = responsePurchasesVerifyShepaPPG.result.transaction_id != null ? responsePurchasesVerifyShepaPPG.result.transaction_id.ToString() : null;
                    command.PaidAmount = responsePurchasesVerifyShepaPPG.result.amount != null ? responsePurchasesVerifyShepaPPG.result.amount.ToString() : null;
                }

                if (responsePurchasesVerifyShepaPPG != null && responsePurchasesVerifyShepaPPG.errors != null && responsePurchasesVerifyShepaPPG.errors.Count > 0)
                {
                    throw new ExternalServiceException($"{responsePurchasesVerifyShepaPPG.errors[0]}");
                }

                price = command.PaidAmount.cleanPrice();

                var dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction_Wallet(new Update_Transaction_Wallet.Inputs
                {
                    TransactionCode = command.TransactionCode,
                    PaidAmount = paidAmountOrder,
                    PaidCode = command.PurchaseId,
                    Status = command.Status,
                    TrackingCode = command.TrackingCode
                }, cancellationToken);

                if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                {
                    return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                    {
                        Status = "OK",
                        Setting = setting,
                        Result = responsePurchasesVerifyShepaPPG.result,
                        FinalAmount = dbResultUpdateTransaction.Data.PaidAmount,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                        TrackingCode = dbResultUpdateTransaction.Data.TrackingCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        WalletId  = dbResultUpdateTransaction.Data.WalletId
                    });
                }

                if (responsePurchasesVerifyShepaPPG.success == true && (responsePurchasesVerifyShepaPPG.result.isDuplicate == null || responsePurchasesVerifyShepaPPG.result.isDuplicate == false))
                {
                    responsePurchasesVerifyShepaPPG.message = null;
                    return await _IAutomaticOrderOperationService.doCompeleteWalletCharge(
                        new DoCompeleteWalletCharge
                        {
                            Result = responsePurchasesVerifyShepaPPG.result,
                            PaidAmount = dbResultUpdateTransaction.Data.PaidAmount,
                            Email = dbResultUpdateTransaction.Data.Email,
                            Mobile = dbResultUpdateTransaction.Data.Mobile,
                            Status = "OK",
                            CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                            Setting = setting,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            TrackingCode = dbResultUpdateTransaction.Data.TrackingCode,
                            WalletId = dbResultUpdateTransaction.Data.WalletId
                        }, cancellationToken);
                }

                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    Result = responsePurchasesVerifyShepaPPG.result,
                    FinalAmount = dbResultUpdateTransaction.Data.PaidAmount,
                    CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                    PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                    WalletId = dbResultUpdateTransaction.Data.WalletId
                });
            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                FinalAmount = 0,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode,
                WalletId = dbResultCheckTransaction.Data.WalletId
            });

        }

        public async Task<DBResult<ResponseVerifyShepaPPG>> getPay(GetPayShepaCommand command, CancellationToken cancellationToken,bool checkJobToken = true)
        {
            if(checkJobToken)
            {
                var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
                if (dbSetting.Data.JobToken != command.JobToken)
                {
                    throw new LogicalException("کلید اتصال نامعتبر می باشد");
                }
            }
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);

            command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();
            decimal price = 0;
            if (command.PaidAmount.ToString().Contains("."))
                price = Convert.ToDecimal(command.PaidAmount.ToString().Split(".")[0]);
            else
                price = Convert.ToDecimal(command.PaidAmount);


            var responsePurchasesVerifyShepaPPG = new ResponseVerifyShepaPPG();
            responsePurchasesVerifyShepaPPG = await _httpRequestShepaPPG.verifyShepaPPG(new RequestVerifyShepaPPG
            { api = webServiceInfo.RealApiKey, token = command.PurchaseId, amount = price.toRial() }
            , webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesVerifyShepaPPG != null)
            {

                return new DBResult<ResponseVerifyShepaPPG>(responsePurchasesVerifyShepaPPG, 1);
            }


            return new DBResult<ResponseVerifyShepaPPG>(new ResponseVerifyShepaPPG { }, 1);

        }
    }
}
