﻿using Farakonesh.Commands.Services;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Models.API.Zarinpal;
using Microsoft.AspNetCore.Http;
using System.Threading;
using System.Linq;
using Farakonesh.Shared.Helpers;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.Logic.Services.App.PPG
{
    public class ZarinpalService : IZarinpalService
    {
        private readonly IOrderContext _IOrderContext;
        private readonly ISettingContext _ISettingContext;
        private readonly ITransActionContext _ITransActionContext;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpRequestZarinpalPPG _httpRequestZarinpalPPG;
        private readonly ITokenUserService _tokenUserService;
        private readonly IAutomaticOrderOperationService _IAutomaticOrderOperationService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public ZarinpalService(IAutomaticOrderOperationService IAutomaticOrderOperationService
            , ISettingContext iSettingContext, IOrderContext iOrderContext
            , ITransActionContext iTransActionContext, IHttpRequestZarinpalPPG httpRequestZarinpalPPG, ITokenUserService tokenUserService,
            IRedisContextService redisContextService, IHttpContextAccessor httpContextAccessor)
        {
            _tokenUserService = tokenUserService;
            _httpRequestZarinpalPPG = httpRequestZarinpalPPG;
            _IAutomaticOrderOperationService = IAutomaticOrderOperationService;
            _ISettingContext = iSettingContext;
            _IOrderContext = iOrderContext;
            _ITransActionContext = iTransActionContext;
            _redisContextService = redisContextService;
            _httpContextAccessor = httpContextAccessor;
        }


        public async Task<DBResult> startPay(StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderId = command.OrderId,
                Code = command.Code
            }, cancellationToken);

            if (dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException(MessageHelper.NotFoundOrder);
            }

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = true
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }
            var settingOrder = await _redisContextService.getSettingOrderAsync(dbResultOrder.Data.OrderType, token, cancellationToken);

            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortal(
            new CheckBankAccountClientPortalCommand
            {
                BankAccountId = command.BankAccountId,
                CheckBankAccount = settingOrder.CheckBankAccount,
                Token = token
            }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);
            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : (dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0) ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
settingOrder.IsActiveOnlinePayMultiple);
            var metadataList = new List<RequestMetadataZarinpalPPG>();
            if (settingOrder.CheckBankAccount)
            {
                metadataList.Add(new RequestMetadataZarinpalPPG { card_pan = dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber });
            }
            var responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.purchaseZarinpalPPG(new RequestPurchasesZarinpalPPG
            {
                amount = finalAmountToman.toRial(),
                merchant_id = webServiceInfo.RealApiKey,
                callback_url = (string)config["callback"],
                metadata = metadataList,
                description = "سفارش شماره " + dbResultOrder.Data.OrderNumber
            }, webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesZarinpalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
                throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");


            await _ITransActionContext.Insert_Transaction(new Insert_Transaction.Inputs
            {
                Token = token,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesZarinpalPPG.data.authority,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Zarinpal,
                Code = command.Code
            }, cancellationToken);
            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesZarinpalPPG.data.authority, IsFree = false }, 1);
        }

        public async Task<DBResult> startPayPublic(StartPayPublicOrderCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var dbResultOrder = await _IOrderContext.GetOrderByIdWithoutToken(new GetOrderByIdWithoutToken.Inputs
            {
                OrderNumber = command.OrderNumber,
                Code = command.Code
            }, cancellationToken);
            if (dbResultOrder == null || dbResultOrder.Data == null)
            {
                throw new LogicalException(MessageHelper.NotFoundOrder);
            }
            command.OrderId = dbResultOrder.Data.OrderId;
            var settingOrder = await _redisContextService.getSettingOrderWithoutTokenAsync(dbResultOrder.Data.OrderType,
                command.OrderId, cancellationToken);

            var allowedAmount = await _IAutomaticOrderOperationService.CheckScenario(new CheckScenarioCommand
            {
                OrderType = dbResultOrder.Data.OrderType,
                PaidAmount = dbResultOrder.Data.PaidAmount,
                FinalAmount = dbResultOrder.Data.FinalAmount,
                FinalWageAmount = dbResultOrder.Data.FinalWageAmount,
                PaymentMethod = PayMentMethod.OnlinePayment,
                DiscountedFinalAmount = dbResultOrder.Data.DiscountedFinalAmount,
                ModuleType = dbResultOrder.Data.SaveLocation
            }, cancellationToken);

            var responseFreeOrder = await _IAutomaticOrderOperationService.doCompeleteFreeOrder(new DoCompeleteFreeOrderCommand
            {
                Code = command.Code,
                OrderId = command.OrderId,
                model = dbResultOrder.Data,
                CheckToken = false
            }, cancellationToken);
            if (responseFreeOrder != null)
                return responseFreeOrder;

            var dbResultBankAccount = await _IAutomaticOrderOperationService.checkBankAccountClientPortalWithoutToken(
            new CheckBankAccountClientPortalCommand
            {
                BankAccountId = command.BankAccountId,
                CheckBankAccount = settingOrder.CheckBankAccount
            }, cancellationToken);

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);


            var maximumAmountOnlinePort = Convert.ToDecimal(settingOrder.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(settingOrder.MinimumAmountOnlinePort);
            var finalAmountToman = (allowedAmount != null && allowedAmount > 0) ? allowedAmount : dbResultOrder.Data.Discount != null && dbResultOrder.Data.Discount > 0 ? dbResultOrder.Data.DiscountedFinalAmount : dbResultOrder.Data.FinalAmount;
            finalAmountToman = finalAmountToman.Value.ValidatePaymentAmountMultiPayment(maximumAmountOnlinePort,
minimumAmountOnlinePort, dbResultOrder.Data.PaidAmount, settingOrder.IsActiveOnlinePaySingle,
settingOrder.IsActiveOnlinePayMultiple);
            var metadataList = new List<RequestMetadataZarinpalPPG>();
            if (settingOrder.CheckBankAccount)
            {
                metadataList.Add(new RequestMetadataZarinpalPPG { card_pan = dbResultBankAccount?.Data?.FirstOrDefault()?.CardNumber });
            }
            var responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.purchaseZarinpalPPG(new RequestPurchasesZarinpalPPG
            {
                amount = finalAmountToman.toRial(),
                merchant_id = webServiceInfo.RealApiKey,
                callback_url = (string)config["callback"],
                description = "سفارش شماره " + dbResultOrder.Data.OrderNumber,
                metadata = metadataList
            }, webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesZarinpalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
                throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");


            await _ITransActionContext.Insert_Transaction_WithoutToken(new Insert_Transaction_WithoutToken.Inputs
            {
                UserId = dbResultOrder.Data.UserId,
                OrderId = command.OrderId,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesZarinpalPPG.data.authority,
                TrackingCode = null,
                MaximummPrice = maximumAmountOnlinePort,
                OnlinePortal = (int)OnlinePortal.Zarinpal,
                Code = command.Code
            }, cancellationToken);
            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesZarinpalPPG.data.authority, IsFree = false }, 1);
        }

        public async Task<DBResult> verifyPay(VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGJibit, cancellationToken);


            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var dbResultUpdateTransaction = new DBResult<Update_Transaction.Outputs>();
            var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;

            command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();

            decimal price = command.PaidAmount.cleanPrice();

            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction(new Check_Duplicate_Transaction.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode
                });
            }

            if (command.Status == "OK")
            {
                var responsePurchasesZarinpalPPG = new ResponsePurchasesZarinpalMainPPG();
                responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.verifyZarinpalPPG(new RequestVerifyPurchasesZarinpalPPG { merchant_id = webServiceInfo.RealApiKey, authority = command.PurchaseId, amount = price.toRial() }
                , webServiceInfo.BaseUrlService, cancellationToken);

                var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);


                if (responsePurchasesZarinpalPPG != null && responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
                {
                    var dbResultUpdateStatus = await _IOrderContext.Update_Order_Status_WithouToken(new Update_Order_Status_WithouToken.Inputs
                    {
                        OrderId = dbResultGetTransactionOrder.Data.OrderId,
                        Status = (int)OrderStatus.NotConfirmed
                    }, cancellationToken);
                    throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");
                }

                if (responsePurchasesZarinpalPPG.data.code == 100)
                {
                    dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction(new Update_Transaction.Inputs
                    {
                        TransactionCode = command.TransactionCode,
                        PaidAmount = price,
                        PaidCode = command.PurchaseId,
                        Status = command.Status,
                        TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                        MaximummPrice = maximumAmountOnlinePort
                    }, cancellationToken);

                    if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                    {
                        return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                        {
                            Status = command.Status,
                            Setting = setting,
                            FinalAmount = price,
                            OrderId = dbResultUpdateTransaction.Data.OrderId,
                            TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                            CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode
                        });
                    }

                    if (dbResultUpdateTransaction.Data.StatusOrder != null && dbResultUpdateTransaction.Data.StatusOrder == 192)
                    {
                        return await _IAutomaticOrderOperationService.DoCompeleteScenario(new DoCompeleteScenarioCommand
                        {
                            OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                            Email = dbResultUpdateTransaction.Data.Email,
                            Mobile = dbResultUpdateTransaction.Data.Mobile,
                            OrderId = dbResultUpdateTransaction.Data.OrderId,
                            OrderType = dbResultUpdateTransaction.Data.OrderType,
                            RemainingAmount = dbResultUpdateTransaction.Data.RemainingAmount,
                            StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                            FinalAmount = dbResultUpdateTransaction.Data.FinalAmount,
                            Status = "OK",
                            CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                            TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                            Setting = setting,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            ModuleType = dbResultUpdateTransaction.Data.SaveLocation
                        }, cancellationToken);
                    }

                    return await _IAutomaticOrderOperationService.doCompelete(new DoCompeleteCommand
                    {
                        Email = dbResultUpdateTransaction.Data.Email,
                        Mobile = dbResultUpdateTransaction.Data.Mobile,
                        OrderId = dbResultUpdateTransaction.Data.OrderId,
                        OrderNumber = dbResultUpdateTransaction.Data.OrderNumber,
                        OrderType = dbResultUpdateTransaction.Data.OrderType
   ,
                        PurchaseId = command.PurchaseId,
                        ValueType = dbResultUpdateTransaction.Data.ValueType,
                        Status = "OK",
                        StatusOrder = dbResultUpdateTransaction.Data.StatusOrder,
                        Commission = dbResultUpdateTransaction.Data.Commission,
                        EmailCompanyUser = dbResultUpdateTransaction.Data.EmailCompanyUser,
                        MobileCompanyUser = dbResultUpdateTransaction.Data.MobileCompanyUser,
                        TransactionType = dbResultUpdateTransaction.Data.TransactionType,
                        CooperRewardToman = dbResultUpdateTransaction.Data.CooperRewardToman,
                        NumberOfSuccessfulOrders = dbResultUpdateTransaction.Data.NumberOfSuccessfulOrders,
                        FinalAmount = price.ToString(),
                        TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyOwnerId,
                        Setting = setting,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode
                    }, cancellationToken);

                }


            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                OrderId = dbResultGetTransactionOrder.Data.OrderId,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode
            });

        }

        public async Task<DBResult> startPayChargeWallet(StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            if (webServiceInfo == null)
                throw new LogicalException("درگاه پرداخت غیر فعال می باشد ، لطفا درگاه پرداخت دیگری را انتخاب کنید");

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            if ((setting.IsActiveOnlinePaySingle == null || setting.IsActiveOnlinePaySingle == false))
            {
                throw new LogicalException("روش پرداخت درگاه آنلاین غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");
            }

            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(), localIp);
            if (isExternal)
            {
                throw new LogicalException(MessageHelper.ExrenalServerErrorPayment);
            }

            await _IAutomaticOrderOperationService.CheckIpClientPortal(cancellationToken);
            var maximumAmountOnlinePort = Convert.ToDecimal(setting.MaximumAmountOnlinePort);
            var minimumAmountOnlinePort = Convert.ToDecimal(setting.MinimumAmountOnlinePort);

            var finalAmountToman = Convert.ToDecimal(command.PaidAmount);
            finalAmountToman.ValidatePaymentAmount(maximumAmountOnlinePort, minimumAmountOnlinePort);
            var responseCheckTransaction = await _ITransActionContext.Check_TransAction_Wallet(new Check_TransAction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            var responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.purchaseZarinpalPPG(new RequestPurchasesZarinpalPPG
            {
                amount = finalAmountToman.toRial(),
                merchant_id = webServiceInfo.RealApiKey,
                callback_url = (string)config["callbackWallet"] + ("?returnUrl=" + command.CallbackUrl).Trim(),
                description = "شارژ کیف پول آقا/خانم " + responseCheckTransaction.Data.Name + " " + responseCheckTransaction.Data.Family + " با شماره همراه: " + responseCheckTransaction.Data.Mobile + " و ایمیل: " + responseCheckTransaction.Data.Email
            }, webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesZarinpalPPG == null)
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");

            if (responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
                throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");


            await _ITransActionContext.Insert_Transaction_Wallet(new Insert_Transaction_Wallet.Inputs
            {
                Token = token,
                PaidAmount = finalAmountToman,
                PaidCode = responsePurchasesZarinpalPPG.data.authority,
                TrackingCode = null,
                OnlinePortal = (int)OnlinePortal.Zarinpal,
                TransactionType = (int)TransactionType.RechargeWallet
            }, cancellationToken);

            return new DBResult(new { redirectUrl = (string)config["redirectUrl"] + responsePurchasesZarinpalPPG.data.authority }, 1);
        }

        public async Task<DBResult> verifyChargeWallet(VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var dbResultGetTransactionOrder = await _ITransActionContext.Get_Order_Transaction_WithouToken(new Get_Order_Transaction_WithouToken.Inputs
            {
                PaidCode = command.PurchaseId
            }, cancellationToken);
            decimal paidAmountOrder = dbResultGetTransactionOrder.Data.PaidAmount.Value;
            command.PaidAmount = Math.Round(dbResultGetTransactionOrder.Data.PaidAmount.Value).ToString();
            decimal price = command.PaidAmount.cleanPrice();

            var dbResultCheckTransaction = await _ITransActionContext.Check_Duplicate_Transaction_Wallet(new Check_Duplicate_Transaction_Wallet.Inputs
            {
                PaidCode = command.PurchaseId,
                Status = command.Status
            }, cancellationToken);

            if (dbResultCheckTransaction != null && dbResultCheckTransaction.Data != null && dbResultCheckTransaction.Data.IsDuplicate == true)
            {
                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode,
                    WalletId = dbResultCheckTransaction.Data.WalletId
                });
            }

            if (command.Status == "OK")
            {
                var responsePurchasesZarinpalPPG = new ResponsePurchasesZarinpalMainPPG();

                responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.verifyZarinpalPPG(new RequestVerifyPurchasesZarinpalPPG
                {
                    merchant_id = webServiceInfo.RealApiKey
                    ,
                    authority = command.PurchaseId,
                    amount = price.toRial()
                }
                , webServiceInfo.BaseUrlService, cancellationToken);

                if (responsePurchasesZarinpalPPG == null)
                {
                    throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
                }

                if (responsePurchasesZarinpalPPG != null && responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
                {
                    throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");
                }

                if (responsePurchasesZarinpalPPG.data.code == 100)
                {
                    var dbResultUpdateTransaction = await _ITransActionContext.Update_Transaction_Wallet(new Update_Transaction_Wallet.Inputs
                    {
                        TransactionCode = command.TransactionCode,
                        PaidAmount = price,
                        PaidCode = command.PurchaseId,
                        Status = command.Status,
                        TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id
                    }, cancellationToken);

                    if (dbResultUpdateTransaction != null && dbResultUpdateTransaction.Data != null && dbResultUpdateTransaction.Data.IsDuplicate == true)
                    {
                        return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                        {
                            Status = "OK",
                            FinalAmount = price,
                            TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                            Setting = setting,
                            CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                            TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                            PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                            WalletId = dbResultUpdateTransaction.Data.WalletId
                        });
                    }

                    return await _IAutomaticOrderOperationService.doCompeleteWalletCharge(
                    new DoCompeleteWalletCharge
                    {
                        PaidAmount = dbResultUpdateTransaction.Data.PaidAmount,
                        Email = dbResultUpdateTransaction.Data.Email,
                        Mobile = dbResultUpdateTransaction.Data.Mobile,
                        Status = "OK",
                        TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                        CompanyId = dbResultUpdateTransaction.Data.CompanyId,
                        Setting = setting,
                        PaidCode = dbResultUpdateTransaction.Data.PaidCode,
                        TransactionCode = dbResultUpdateTransaction.Data.TransactionCode,
                        WalletId = dbResultUpdateTransaction.Data.WalletId
                    }, cancellationToken);
                }

                return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
                {
                    Status = "OK",
                    FinalAmount = price,
                    TrackingCode = responsePurchasesZarinpalPPG?.data?.ref_id,
                    Setting = setting,
                    CompanyId = dbResultCheckTransaction.Data.CompanyId,
                    TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                    PaidCode = dbResultCheckTransaction.Data.PaidCode,
                    WalletId = dbResultCheckTransaction.Data.WalletId
                });

            }

            return _IAutomaticOrderOperationService.getPPGResult(new GetDbResultPPGCommand
            {
                Status = command.Status,
                Setting = setting,
                CompanyId = dbResultCheckTransaction.Data.CompanyId,
                TrackingCode = dbResultCheckTransaction.Data.TrackingCode,
                TransactionCode = dbResultCheckTransaction.Data.TransactionCode,
                PaidCode = dbResultCheckTransaction.Data.PaidCode,
                WalletId = dbResultCheckTransaction.Data.WalletId
            });
        }

        public async Task<bool> verifyAutoTransAction(VerifyAutoTransActionZarinpal command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);


            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var responsePurchasesZarinpalPPG = new ResponsePurchasesZarinpalMainPPG();

            responsePurchasesZarinpalPPG = await _httpRequestZarinpalPPG.verifyZarinpalPPG(new RequestVerifyPurchasesZarinpalPPG
            {
                merchant_id = webServiceInfo.RealPassword
                ,
                authority = command.PurchaseId,
                amount = command.PaidAmount
            }
            , webServiceInfo.BaseUrlService, cancellationToken);

            if (responsePurchasesZarinpalPPG == null)
            {
                throw new ExternalServiceException("خطا در دریافت نتیجه ی درگاه پرداخت ، در صورت کسر وجه مبلغ پرداخت شده طی 24 ساعت به حساب شما برگشت داده خواهد شد");
            }

            if (responsePurchasesZarinpalPPG != null && responsePurchasesZarinpalPPG.errors != null && (responsePurchasesZarinpalPPG.errors.code < 0 || responsePurchasesZarinpalPPG.errors.code == 101))
            {
                throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPG.errors.code)}");
            }



            if (responsePurchasesZarinpalPPG.data.code == 100)
            {
                return true;
            }



            return false;

        }

        public async Task<DBResult<List<ResponsePurchasesZarinpalPPGUnverifiedItemsData>>> getUnverifiedPay(GetUnverifiedPayZarinpalCommand command, CancellationToken cancellationToken, bool checkJobToken = true)
        {
            if (checkJobToken)
            {
                var dbSetting = await _ISettingContext.Get_Setting_Job(new Get_Setting_Job.Inputs { }, cancellationToken);
                
                if (dbSetting.Data.JobToken != command.JobToken)
                {
                    throw new LogicalException("کلید اتصال نامعتبر می باشد");
                }

                IHttpContextAccessor ctxAccess = new HttpContextAccessor();
                if (ctxAccess.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString() != dbSetting.Data.JobIp)
                {
                    throw new LogicalException("شما مجاز به درخواست نمی باشید");
                }
            }

            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);


            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var responsePurchasesZarinpalPPGUnverifiedMain = new ResponsePurchasesZarinpalPPGUnverifiedMain();
            responsePurchasesZarinpalPPGUnverifiedMain = await _httpRequestZarinpalPPG.getUnVerifiedZarinpalPPG(new RequestVerifyPurchasesZarinpalPPG
            { merchant_id = webServiceInfo.RealApiKey }
            , webServiceInfo.BaseUrlService, cancellationToken);


            if (responsePurchasesZarinpalPPGUnverifiedMain != null)
            {
                if (responsePurchasesZarinpalPPGUnverifiedMain != null && responsePurchasesZarinpalPPGUnverifiedMain.errors != null && (responsePurchasesZarinpalPPGUnverifiedMain.errors.code < 0 || responsePurchasesZarinpalPPGUnverifiedMain.errors.code == 101))
                {
                    throw new ExternalServiceException($"{getErrorMessage(responsePurchasesZarinpalPPGUnverifiedMain.errors.code)}");
                }
                return new DBResult<List<ResponsePurchasesZarinpalPPGUnverifiedItemsData>>(responsePurchasesZarinpalPPGUnverifiedMain.data.authorities, 1);
            }


            return new DBResult<List<ResponsePurchasesZarinpalPPGUnverifiedItemsData>>(new List<ResponsePurchasesZarinpalPPGUnverifiedItemsData> { }, 1);

        }

        public async Task<DBResult> getPay(InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);

            var responseTransactionListZarinpalPPG = new ResponseTransactionListZarinpalPPG();

            responseTransactionListZarinpalPPG = await _httpRequestZarinpalPPG.getZarinpalTransActionPPG(new RequestTransactionListZarinpalPPG
            {
                terminal_id = (string)config["terminal"],
                filter = command.Filter,
                limit = command.PageSize,
                offset = (command.PageSize * (command.StartIndex - 1))
            }
            , webServiceInfo.BaseUrlService, webServiceInfo.RealPassword, cancellationToken);

            return new DBResult(responseTransactionListZarinpalPPG, 1);

        }

        public async Task<DBResult> getPayByFilter(InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetSettingPurchaseAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var responseTransactionListZarinpalPPG = new ResponseTransactionZarinpalPPGReference();
            responseTransactionListZarinpalPPG = await _httpRequestZarinpalPPG.getZarinpalTransActionPPGByReference(new RequestTransactionListZarinpalPPG
            {
                terminal_id = (string)config["terminal"],
                filter = command.Filter,
                limit = command.PageSize,
                offset = (command.PageSize * (command.StartIndex - 1)),
                reference_id = command.TrackingCode
            }
            , webServiceInfo.BaseUrlService, webServiceInfo.RealPassword, cancellationToken);

            return new DBResult(responseTransactionListZarinpalPPG, 1);

        }
        private string getErrorMessage(int? code)
        {
            switch (code)
            {
                case 101:
                    return "تراکنش تکراری است";
                case -9:
                    return "خطای اعتبار سنجی بوجود آمده است";
                case -10:
                    return "کد اتصال اشتباه است";
                case -11:
                    return "کد اتصال فعال نیست ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -12:
                    return "در یک بازه ی زمانی کوتاه تعداد زیادی درخواست ارسال شده است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -15:
                    return "درگاه پرداخت غیر فعال شده است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -16:
                    return "سطح تایید پذیرنده پایین تر از سطح نقره ای است";
                case -17:
                    return "محدودیت پذیرنده در سطح آبی";
                case -30:
                    return "پذیرنده اجازه دسترسی به سرویس تسویه اشتراکی شناور را ندارد";
                case -31:
                    return "حساب بانکی تسویه را به پنل اضافه کنید. مقادیر وارد شده برای تسهیم درست نیست. پذیرنده جهت استفاده از خدمات سرویس تسویه اشتراکی شناور، باید حساب بانکی معتبری به پنل کاربری خود اضافه نماید.";
                case -32:
                    return "خطای امنیتی: مبلغ وارد شده از مبلغ کل تراکنش بیشتر است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید.";
                case -33:
                    return "درصدهای وارد شده صحیح نیست";
                case -34:
                    return "خطای امنیتی: مبلغ وارد شده از مبلغ کل تراکنش بیشتر است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -35:
                    return "تعداد افراد دریافت کننده تسهیم بیش از حد مجاز است";
                case -36:
                    return "حداقل مبلغ جهت تسهیم باید ۱۰۰۰ تومان باشد";
                case -37:
                    return "یک یا چند شماره شبای وارد شده برای تسهیم از سمت بانک غیر فعال است";
                case -38:
                    return "خطا٬عدم تعریف صحیح شبا٬لطفا دقایقی دیگر تلاش کنید";
                case -39:
                    return "خطایی رخ داده است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -40:
                    return "خطایی ارسال پارامتر ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -41:
                    return "حداکثر مبلغ پرداختی 100 میلیون تومان است";
                case -50:
                    return "خطای امنیتی: مبلغ پرداخت شده با مقدار مبلغ ارسالی در متد وریفای متفاوت است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -51:
                    return "پرداخت ناموفق بود";
                case -52:
                    return "خطای غیر منتظره‌ای رخ داده است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -53:
                    return "پرداخت متعلق به این مرچنت کد نیست ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -54:
                    return "کد پرداخت نامعتبر است ، در صورت تکرار خطا به پشتیبانان ما اطلاع دهید";
                case -55:
                    return "تراکنش مورد نظر یافت نشد";
                case -60:
                    return "امکان بازگردانی تراکنش بانک وجود ندارد";
                case -61:
                    return "تراکنش موفق نیست یا قبلا مبلغ آن برگشت خورده است";
                case -62:
                    return "آی پی درگاه ست نشده است";
                case -63:
                    return "حداکثر زمان (۳۰ دقیقه) برای بازگشت این تراکنش منقضی شده است";
                default:
                    return "";
            }
        }
    }
}
