﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Security.Principal;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Payeer
{
    public class PayeerService : IPayeerService
    {
        private readonly IHttpRequestPayeer _httpRequestPayeer;
        private readonly IRedisContextService _redisContextService;
        private readonly IPayeerContext _IPayeerContext;
        private readonly ICurrencyContext _ICurrencyContext;
        private readonly IMailHelper _IMailHelper;
        private readonly ISmsHelper _ISmsHelper;
        private readonly ITokenUserService _tokenUserService;
        public PayeerService(ICurrencyContext ICurrencyContext, ISmsHelper iSmsHelper,
            IMailHelper IMailHelper, IPayeerContext iPayeerContext, IHttpRequestPayeer httpRequestPayeer,
            ITokenUserService tokenUserService, IRedisContextService redisContextService)
        {
            _httpRequestPayeer = httpRequestPayeer;
            _ICurrencyContext = ICurrencyContext;
            _ISmsHelper = iSmsHelper;
            _IMailHelper = IMailHelper;
            _IPayeerContext = iPayeerContext;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// بررسی اعتبار شماره حساب پایر
        /// </summary>
        /// <param name="account"></param>
        /// <param name="_publicContext"></param>
        /// <param name="settingctx"></param>
        /// <param name="redis"></param>
        /// <param name="logger"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        public async Task<bool> checkAccountName(string account, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var responseCheck = await _httpRequestPayeer.checkAccountPayeer(new RequestCheckUserPayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username,
                user = account

            },
                   webServiceInfo.BaseUrlService, cancellationToken);
            if (responseCheck.success == false)
            {
                throw new ExternalServiceException($"بنظر می رسد حساب پایر شما معتبر نیست ، در صورتی که از اعتبار حساب خود اطمینان دارید با کارشناسان ما ارتباط برقرار فرمایید");
            }
            return true;

        }

        public async Task<DBResult<object>> getCheckAccountName(GetCheckAccountNamePayeerCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var responseCheck = await _httpRequestPayeer.checkAccountPayeer(new RequestCheckUserPayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username,
                user = command.AccountAddress

            },
                   webServiceInfo.BaseUrlService, cancellationToken);
            if (responseCheck.success == false)
            {
                throw new ExternalServiceException($"بنظر می رسد حساب پایر شما معتبر نیست ، در صورتی که از اعتبار حساب خود اطمینان دارید با کارشناسان ما ارتباط برقرار فرمایید");
            }
            return new DBResult<object>() { };

        }

        public async Task<DBResult> getAccountBalance(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var response = await _httpRequestPayeer.getAccountBalancePayeer(new RequestBalancePayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username
            },
                  webServiceInfo.BaseUrlService, cancellationToken);

            return new DBResult() { Data = response };

        }
        /// <summary>
        /// دریافت لیست تراکنش های حساب پایر
        /// </summary>
        /// <param name="settingctx"></param>
        /// <param name="redis"></param>
        /// <param name="logger"></param>
        /// <returns></returns>
        public async Task<DBResult> getHistory(GetHistoryPayeerCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var response = await _httpRequestPayeer.getHistoryPayeer(new RequestHistoryPayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username,
                count = command.Count,
                from = command.From,
                to = command.To
            },
                  webServiceInfo.BaseUrlService, cancellationToken);

            return new DBResult() { Data = response };

        }

        public async Task<DBResult> checkAuthAccount(CancellationToken cancellationToken)
        {

            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var response = await _httpRequestPayeer.getAccountBalancePayeer(new RequestBalancePayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username
            },
                  webServiceInfo.BaseUrlService, cancellationToken);

            return new DBResult() { Data = response };

        }

        public async Task<bool> checkAccountBalance(decimal? amount, Guid? CurrencyId, CancellationToken cancellationToken)
        {

            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();

            var response = await _httpRequestPayeer.getAccountBalancePayeer(new RequestBalancePayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username
            },
                  webServiceInfo.BaseUrlService, cancellationToken);
            var responseCurrency = await _ICurrencyContext.GetCurrencyById(new GetCurrencyById.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token
          ,
                CurrencyId = CurrencyId
            }, cancellationToken);
            if (response.balance == null && response.errors != null && response.errors.Count > 0)
            {
                throw new ExternalServiceException(response.errors[0]);
            }

            if (ObjectHelper.getValue(responseCurrency.Data, "Code").ToString() == "USD" && response.balance.USD.available <= amount)
            {
                throw new ExternalServiceException($"با عرض پوزش در حال حاضر به علت کسری موجودی حساب ما، امکان خرید این تعداد پایر برای شما میسر نمی باشد ، جهت خرید می توانید با کارشناسان ما ارتباط برقرار کنید");
            }

            else if (ObjectHelper.getValue(responseCurrency.Data, "Code").ToString() == "EUR" && response.balance.EUR.available <= amount)
            {
                throw new ExternalServiceException($"با عرض پوزش در حال حاضر به علت کسری موجودی حساب ما، امکان خرید این تعداد پایر برای شما میسر نمی باشد ، جهت خرید می توانید با کارشناسان ما ارتباط برقرار کنید");
            }

            return true;

        }


        public async Task<DBResult> transferPayeer(TransferPayeerCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var response = await _httpRequestPayeer.purchasePayeer(new RequestTransferPayeerModel
            {
                apiId = (string)config["shopNumberBuy"],
                apiPass = (string)config["apiKeyBuy"],
                account = webServiceInfo.Username,
                sum = command.Amount,
                comment = "Transfer Payeer by Operator",
                curIn = command.Code.ToUpper(),
                curOut = command.Code.ToUpper(),
                to = command.AccountAddress,
                referenceId = Guid.NewGuid().ToString()
            },
                  webServiceInfo.BaseUrlService, cancellationToken);

            return new DBResult() { Data = response };
        }

        public async Task<DBResult> updateSellPayeer(UpdateSellPayeerCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IPayeerContext.Update_OrderPayeerSellByCustomer(new Update_OrderPayeerSellByCustomer.Inputs
            {
                OrderId = command.OrderId,
                PaymentNumber = command.PaymentNumber
            ,
                PaymentType = command.PaymentType,
                PaymentDate = command.PaymentDate,
                PaymentPayDate = command.PaymentPayDate
            }, cancellationToken);
            if (dbResult.Data != null)
            {

                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"ثبت درخواست فروش پایر",
                    Body = $"سفارش شما به شماره {dbResult.Data.OrderNumber}# در وضعیت در حال تسویه قرار گرفت",
                    Email = dbResult.Data.Email,
                }, cancellationToken);

                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                { Mobile = dbResult.Data.Mobile, Pattern = 61052, Code = dbResult.Data.OrderNumber.ToString() }, cancellationToken);

            }
            return new DBResult(new { }, 0);

        }



        public async Task<DBResult> getRedirectSellPayeer(GetRedirectSellPayeerCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            return new DBResult(new { urlRedirect = (string)config["redirectAddressSell"] + "?id=" + command.OrderId + "&type=pa" }, 0);


        }
    }
}
