﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IQueue;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Queue
{
    public class CalendarService : ICalendarService
    {
        private readonly IQueueContext _queueContext;
        private readonly IHttpRequestCalendarPnldev _httpRequestCalendarPnldev;
        private readonly ITokenUserService _tokenUserService;
        public CalendarService(IQueueContext queueContext, IHttpRequestCalendarPnldev httpRequestCalendarPnldev,
            ITokenUserService tokenUserService)
        {
            _queueContext = queueContext;
            _httpRequestCalendarPnldev = httpRequestCalendarPnldev;
            _tokenUserService = tokenUserService;
        }
        public async Task saveCalendar(string year, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var result = await _httpRequestCalendarPnldev.getCalendar(year, cancellationToken);
            if (result != null && result.Result != null && result.Result.Count > 0)
            {
                foreach (var month in result.Result)
                {
                    foreach (var day in month.Value)
                    {
                        var dayOfWeekMiladi = 0;
                        var dayOfWeekShamsi = 0;
                        switch (day.Value.Gregorian.DayWeek)
                        {
                            case "Sat":
                                dayOfWeekMiladi = (int)DayOfWeek.Saturday;
                                break;
                            case "Sun":
                                dayOfWeekMiladi = (int)DayOfWeek.Sunday;
                                break;
                            case "Mon":
                                dayOfWeekMiladi = (int)DayOfWeek.Monday;
                                break;
                            case "Tue":
                                dayOfWeekMiladi = (int)DayOfWeek.Tuesday;
                                break;
                            case "Wed":
                                dayOfWeekMiladi = (int)DayOfWeek.Wednesday;
                                break;
                            case "Thu":
                                dayOfWeekMiladi = (int)DayOfWeek.Thursday;
                                break;
                            case "Fri":
                                dayOfWeekMiladi = (int)DayOfWeek.Friday;
                                break;
                            default:
                                break;
                        }
                        switch (day.Value.Solar.DayWeek)
                        {
                            case "ش":
                                dayOfWeekShamsi = (int)DayOfWeek.Saturday;
                                break;
                            case "ی":
                                dayOfWeekShamsi = (int)DayOfWeek.Sunday;
                                break;
                            case "د":
                                dayOfWeekShamsi = (int)DayOfWeek.Monday;
                                break;
                            case "س":
                                dayOfWeekShamsi = (int)DayOfWeek.Tuesday;
                                break;
                            case "چ":
                                dayOfWeekShamsi = (int)DayOfWeek.Wednesday;
                                break;
                            case "پ":
                                dayOfWeekShamsi = (int)DayOfWeek.Thursday;
                                break;
                            case "ج":
                                dayOfWeekShamsi = (int)DayOfWeek.Friday;
                                break;
                            default:
                                break;
                        }
                        await _queueContext.Insert_Calendar(new Insert_Calendar.Inputs
                        {
                            Token = token,
                            CalendarDate = new DateTime(day.Value.Gregorian.Year, day.Value.Gregorian.Month, day.Value.Gregorian.Day),
                            CalendarDateShamsi = day.Value.Solar.Year + "/" + (day.Value.Solar.Month.ToString().Length == 1 ? "0" + day.Value.Solar.Month.ToString() : day.Value.Solar.Month.ToString()) + "/" + (day.Value.Solar.Day.ToString().Length == 1 ? "0" + day.Value.Solar.Day.ToString() : day.Value.Solar.Day.ToString()),
                            CalendarDateGhamari = day.Value.Moon.Year + "/" + (day.Value.Moon.Month.ToString().Length == 1 ? "0" + day.Value.Moon.Month.ToString() : day.Value.Moon.Month.ToString()) + "/" + (day.Value.Moon.Day.ToString().Length == 1 ? "0" + day.Value.Moon.Day.ToString() : day.Value.Moon.Day.ToString()),
                            DayOfWeek = dayOfWeekMiladi,
                            DayOfWeekShamsi = dayOfWeekShamsi,
                            IsHoliday = day.Value.Holiday,
                            Description = day.Value.Event != null && day.Value.Event.Count > 0 ? string.Join(" | ", day.Value.Event) : string.Empty
                        }, cancellationToken);
                    }
                }
            }

        }
    }
}
