﻿using Farakonesh.Commands.Services.Queue;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IQueue;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Queue
{
    public class QueueMessengersService: IQueueMessengersService
    {
        private readonly IQueueContext _queueContext;
        private readonly IRedisContextService _redisContextService;
        private readonly ITokenUserService _tokenUserService;
        private readonly IHttpRequestTelegram _httpRequestTelegram;
        private readonly IConfiguration _configuration;
        public QueueMessengersService(IQueueContext queueContext, IRedisContextService redisContextService,
            ITokenUserService tokenUserService, IHttpRequestTelegram httpRequestTelegram, IConfiguration configuration)
        {
            _queueContext = queueContext;
            _redisContextService = redisContextService;
            _tokenUserService = tokenUserService;
            _httpRequestTelegram = httpRequestTelegram;
            _configuration = configuration;
        }
        public async Task<DBResult> RequestConnect(CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi
                ,cancellationToken);
            
            if(string.IsNullOrWhiteSpace(webServiceInfo.Username))
            {
                throw new LogicalException("نام کاربری ربات تلگرام یافت نشد ، درصورت تکرار خطا با پشتیبانان ما تماس بگیرید");
            }
        
            var response = await _queueContext.Connect_To_MessengersByCustomer(new Connect_To_MessengersByCustomer.Inputs { 
                Token = token,
                MessengerType = (int)MessengerType.Telegram,
                Text = $"همگام سازی حساب کاربر با تلگرام"
            }, cancellationToken);

            return new DBResult() { Data = _configuration.GetSection("TelegramShortUrl").Get<string>()+ webServiceInfo.Username + "?start=" + response.Data.MessengerId };

        }
    }
}
