﻿using Newtonsoft.Json;
using Farakonesh.Commands.Services.Queue;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.Sms
{
    public class SmsService: ISmsService
    {
        private readonly ISmsHelper _ISmsHelper;
        public SmsService(ISmsHelper ISmsHelper)
        {
            _ISmsHelper = ISmsHelper;
        }
        public async Task<DBResult> getKavenegarBalance(CancellationToken cancellationToken)
        {
            var response = await _ISmsHelper.getAccountInfoKavenegar(cancellationToken);
            return new DBResult() { Data= response };

        }
        public async Task<DBResult> getMeliPayamakBalance(CancellationToken cancellationToken)
        {
            var response = await _ISmsHelper.getAccountInfoMeliPayamak(cancellationToken);
            return new DBResult() { Data = response };

        }

        public async Task<DBResult> getSms(HistorySmsCommand command, CancellationToken cancellationToken)
        {
            var response = await _ISmsHelper.getSms(command.MessageId, cancellationToken);

            return new DBResult() { Data = response };

        }
    }
}
