﻿using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.ISystems;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountService;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.Systems;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database;

namespace Farakonesh.Logic.Services.App.Systems
{
    public class BalanceSystems : IBalanceSystems
    {
        private readonly RedisService _redis;
        private readonly ISettingContext _settingContext;
        private readonly ISmsHelper _smsHelper;
        private readonly IMailHelper _mailHelper;
        private readonly IHttpRequestImage _httpRequestImage;
        private readonly IHttpRequestPayeer _httpRequestPayeer;
        private readonly IHttpRequestArvanCloud _httpRequestArvanCloud;
        private readonly IHttpRequestJibitPPG _httpRequestJibitPPG;
        private readonly IHttpRequestShepaPPG _httpRequestShepaPPG;
        private readonly IHttpRequestZarinpalPPG _httpRequestZarinpalPPG;
        private readonly IHttpRequestJibit _httpRequestJibit;

        private readonly IAccountServiceContext _accountServiceContext;
        private readonly ITokenUserService _tokenUserService;
        public BalanceSystems(RedisService redis, ISettingContext settingContext,
            IHttpRequestImage httpRequestImage, ISmsHelper smsHelper
            , IHttpRequestPayeer httpRequestPayeer,
            IHttpRequestArvanCloud httpRequestArvanCloud
            , IHttpRequestShepaPPG httpRequestShepaPPG ,IHttpRequestJibitPPG httpRequestJibitPPG,
            IAccountServiceContext accountServiceContext, IHttpRequestJibit httpRequestJibit,
            IHttpRequestZarinpalPPG httpRequestZarinpalPPG,
            ITokenUserService tokenUserService, IMailHelper mailHelper)
        {
            _redis = redis;
            _settingContext = settingContext;
            _httpRequestImage = httpRequestImage;
            _smsHelper = smsHelper;
            _httpRequestPayeer = httpRequestPayeer;
            _httpRequestZarinpalPPG = httpRequestZarinpalPPG;
            _httpRequestArvanCloud = httpRequestArvanCloud;
            _httpRequestJibitPPG = httpRequestJibitPPG;
            _httpRequestShepaPPG = httpRequestShepaPPG;
            _httpRequestJibit = httpRequestJibit;
            _accountServiceContext = accountServiceContext;
            _tokenUserService = tokenUserService;
            _mailHelper = mailHelper;

        }

        public async Task<DBResult<string>> CheckVolumeFileManager(CancellationToken cancellationToken)
        {
            var responseVolumeFileManager = await _httpRequestImage.GetVolume(cancellationToken);
            return new DBResult<string> { Data  = responseVolumeFileManager };
        }

        public async Task<DBResult<string>> CheckConnectionFileManager(CancellationToken cancellationToken)
        {
            var responseCheckConnectionFileMananger = await _httpRequestImage.CheckConnection(cancellationToken);
            return new DBResult<string> { Data = responseCheckConnectionFileMananger };
        }

        public async Task<DBResult<string>> GetAccountInfoKavenegarAlarm(CancellationToken cancellationToken)
        {
            var responseSmsAccountKavenegar = await _smsHelper.getAccountInfoKavenegarAlarm(cancellationToken);
            return new DBResult<string> { Data = responseSmsAccountKavenegar };
        }

        public async Task<DBResult<string>> GetAccountBalancePayeerAlarm(CancellationToken cancellationToken)
        {
            var responsePayeer = await _httpRequestPayeer.getAccountBalancePayeerAlarm(cancellationToken);
            return new DBResult<string> { Data = responsePayeer };
        }

        public async Task<DBResult<string>> GetPlaneForInquiryArvanCloude(CancellationToken cancellationToken)
        {
            var responseArvanCloud = await _httpRequestArvanCloud.getPlaneForInquiry(cancellationToken);
            return new DBResult<string> { Data = responseArvanCloud };
        }


        public async Task<DBResult<string>> CheckConnectionMail(CancellationToken cancellationToken)
        {
            var responseEmail = await _mailHelper.checkConnection(cancellationToken);
            return new DBResult<string> { Data = responseEmail };
        }

        public async Task<DBResult<string>> CheckConnectionJibit(CancellationToken cancellationToken)
        {
            var responseJibitPPG = await _httpRequestJibitPPG.checkConnectionPPG(cancellationToken);
            return new DBResult<string> { Data = responseJibitPPG };
        }

        public async Task<DBResult<string>> CheckConnectionShepa(CancellationToken cancellationToken)
        {
            var responseShepaPPG = await _httpRequestShepaPPG.checkConnectionPPG(cancellationToken);
            return new DBResult<string> { Data = responseShepaPPG };
        }

        public async Task<DBResult<string>> CheckConnectionZarinpal(CancellationToken cancellationToken)
        {
            var responseZarinpalPPG = await _httpRequestZarinpalPPG.checkConnectionPPG(cancellationToken);
            return new DBResult<string> { Data = responseZarinpalPPG };
        }

        public async Task<DBResult<string>> CheckConnectionInquiryJibit(CancellationToken cancellationToken)
        {
            var responseJibit = await _httpRequestJibit.checkConnection(cancellationToken);
            return new DBResult<string> { Data = responseJibit };
        }
    
        public async Task<object> getBalanceSystems(CancellationToken cancellationToken)
        {
            var token = _tokenUserService.getUserInfo().Token;
            var resultAccountService = await _accountServiceContext.Get_AccountService_Warning(new
                Get_AccountService_Warning.Inputs
            { Token = token },cancellationToken);
            var accountServices = new List<ResponseAccountService>();
            if (resultAccountService.Data != null && resultAccountService.Data.Count() > 0)
            {
                foreach (var item in resultAccountService.Data)
                {
                    if(item.ChargingMode == false)
                    {
                        if (item.ExpireDate.Value <= DateTimeHelper.GetLocalTime())
                        {
                            accountServices.Add(new ResponseAccountService { chargeMode = false,id = item.AccountServiceId, text = $"هشدار: {item.Title} منقضی شده است ، {item.Description} ، جهت جلوگیری از اختلال در کارکرد سیستم هرچه سریعتر آن را تمدید نمایید" });
                        }
                        else if (item.ExpireDate.Value > DateTimeHelper.GetLocalTime())
                        {
                            accountServices.Add(new ResponseAccountService { chargeMode = false, id = item.AccountServiceId, text = $"هشدار: کمتر از {Convert.ToInt32((item.ExpireDate.Value - DateTime.Now).TotalDays)} روز دیگر تا انقضاء {item.Title} باقی مانده است ، {item.Description} ، جهت جلوگیری از اختلال در کارکرد سیستم هرچه سریعتر آن را تمدید نمایید" });
                        }
                    }
                    else
                    {
                        accountServices.Add(new ResponseAccountService { chargeMode = true, id = item.AccountServiceId, text = $"هشدار: اعتبار {item.Title} کمتر از {item.EmergencyAmount.Value.moneyFormat()} تومان می باشد ، جهت جلوگیری از اختلال در کارکرد سیستم هرچه سریعتر اعتبار آن را افزایش دهید" });
                    }


                }
            }

            return new
            {
                accountServices
            };

        }
    }
}
