﻿using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.User
{
    public class AddressService : IAddressService
    {
        private readonly IHttpRequestJibit _httpRequestJibit;
        private readonly IQueueContext _queueContext;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        private readonly IUserContext _userContext;
        public AddressService(IHttpRequestJibit httpRequestJibit, IQueueContext queueContext,
            ITokenUserService tokenUserService, IRedisContextService redisContextService,
            IUserContext userContext)
        {
            _httpRequestJibit = httpRequestJibit;
            _queueContext = queueContext;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
            _userContext = userContext;
        }
        public async Task<DBResult<ResponsePostalJibit>> GetAddressByPostalCodeByCustomer(GetAddressByPostalCodeCommand command, IUserContext _context, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(command.Token))
            {
                command.Token = _tokenUserService.getUserInfo().Token;
            }
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit,cancellationToken);
            if(webServiceInfo == null)
            {
                return null;
            }
            await _userContext.Check_Duplicate_PostalCode(new Check_Duplicate_PostalCode.Inputs
            {
                PostalCode = command.PostalCode,
                Token = command.Token
            }, cancellationToken);

                var dbResult = await _queueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);

                if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
                {
                    var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                        webServiceInfo.RealPassword
                        , webServiceInfo.BaseUrlService, cancellationToken);
                    if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                        throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                    dbResult.Data.JibitToken = responseJibit.accessToken;
                    await _queueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                }
                var responsePostalJibit = new ResponsePostalJibit();

                responsePostalJibit = await _httpRequestJibit.GetAddressPostalCode(new RequestPostalJibit
                {
                    PostalCode = command.PostalCode,
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);
                await responsePostalJibit.handlerInquiryPostalCode(false, command.Token, _context, cancellationToken);

                if (!string.IsNullOrWhiteSpace(responsePostalJibit.code) && responsePostalJibit.code == "forbidden")
                {
                    var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                        webServiceInfo.RealPassword
                        , webServiceInfo.BaseUrlService, cancellationToken);
                    if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                        throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                    dbResult.Data.JibitToken = responseJibit.accessToken;
                    await _queueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                    responsePostalJibit = await _httpRequestJibit.GetAddressPostalCode(new RequestPostalJibit
                    {

                        PostalCode = command.PostalCode,
                        Server = webServiceInfo.BaseUrlService,
                        Token = dbResult.Data.JibitToken
                    }, cancellationToken);


                }
                await responsePostalJibit.handlerInquiryPostalCode(true, command.Token, _context, cancellationToken);
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = command.Token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryPostOffice
                }, cancellationToken);
                return new DBResult<ResponsePostalJibit>() { Data = responsePostalJibit };
            return null;
        }
        public async Task<ResponsePostalJibit> GetAddressByPostalCode(GetAddressByPostalCodeCommand command, IUserContext _context, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(command.Token))
            {
                command.Token = _tokenUserService.getUserInfo().Token;
            }
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit, cancellationToken);
            if (webServiceInfo == null)
            {
                return null;
            }
            var dbResult = await _queueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, 
                    webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }
            var responsePostalJibit = new ResponsePostalJibit();

            responsePostalJibit = await _httpRequestJibit.GetAddressPostalCode(new RequestPostalJibit
            {
                PostalCode = command.PostalCode,
                Server = webServiceInfo.BaseUrlService,
                Token = dbResult.Data.JibitToken
            }, cancellationToken);
            await responsePostalJibit.handlerInquiryPostalCode(false, command.Token, _context, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responsePostalJibit.code) && responsePostalJibit.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                    webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _queueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                responsePostalJibit = await _httpRequestJibit.GetAddressPostalCode(new RequestPostalJibit
                {
                    PostalCode = command.PostalCode,
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);


            }
            await responsePostalJibit.handlerInquiryPostalCode(true, command.Token, _context, cancellationToken);
            return responsePostalJibit;

            return null;
        }
    }
}
