﻿using System;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Models.Database;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;
using Farakonesh.Models.API.Email;
using System.Linq;
using Farakonesh.Models.API.SMS;
using Microsoft.Extensions.Logging;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Newtonsoft.Json.Linq;
using System.Threading;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Shared.Helpers;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Shared.Enums;
using Farakonesh.Models.API.Whatsapp;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using DnsClient.Protocol;

namespace Farakonesh.Logic.Services.App
{
    public class AuthServices : IAuthServices
    {
        private readonly IUserContext _iUserContext;
        private readonly IAddressContext _addressContext;
        private readonly IAuthenticationContext _iAuthenticationContext;
        private readonly IReCaptchaHelper _reCaptchaHelper;
        private readonly ITtsHelper _ttsHelper;
        private readonly ISmsHelper _ISmsHelper;
        private readonly ITelegramHelper _telegramHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly IHttpRequestCaptcha _httpRequestCaptcha;
        private readonly IWhatsappHelper _whatsappHelper;
        private readonly IHttpRequestOAuth _httpRequestOAuth;
        private readonly ITokenGenerator _iTokenGenerator;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        private readonly ICountryContext _countryContext;
        public AuthServices(ITtsHelper ttsHelper, IUserContext iUserContext,
            IAuthenticationContext iAuthenticationContext,
            ISmsHelper ISmsHelper, IMailHelper IMailHelper
            , IHttpRequestCaptcha httpRequestCaptcha, IHttpRequestOAuth httpRequestOAuth,
            IReCaptchaHelper reCaptchaHelper, ITokenGenerator iTokenGenerator, ITokenUserService tokenUserService,
            IRedisContextService redisContextService, ITelegramHelper telegramHelper
            , IWhatsappHelper whatsappHelper, ICountryContext countryContext, IAddressContext addressContext)
        {
            _iTokenGenerator = iTokenGenerator;
            _httpRequestCaptcha = httpRequestCaptcha;
            _iUserContext = iUserContext;
            _iAuthenticationContext = iAuthenticationContext;
            _ttsHelper = ttsHelper;
            _IMailHelper = IMailHelper;
            _ISmsHelper = ISmsHelper;
            _reCaptchaHelper = reCaptchaHelper;
            _httpRequestOAuth = httpRequestOAuth;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
            _telegramHelper = telegramHelper;
            _whatsappHelper = whatsappHelper;
            _countryContext = countryContext;
            _addressContext = addressContext;
        }
        /// <summary>
        /// ورود با نام کاربری و رمز عبور
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>

        public async Task<DBResult> Login(LoginCommand command, CancellationToken cancellationToken)
        {
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);
            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }
            command.Username = command.Username.Trim();
            if (!command.Username.IsValidEmail())
            {
                command.Username = command.Username.NormalizePhoneNumberForLogin();
            }

            var dbResult = await _iAuthenticationContext.Login(new Login.Inputs { Username = command.Username, Password = command.Password }, cancellationToken);

            if (await checkIsActiveLogin(dbResult.Data.Token, cancellationToken))
            {
                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = 61064,
                    Code = GetLoginDateShamsi()
                }, cancellationToken);

                if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Message = $"کاربر عزیز فراکنش ، شما در تاریخ {GetLoginDateShamsi()} وارد برنامه شدید.",
                        Channel = dbResult.Data.ChatIdTelegram.Trim()
                    }, cancellationToken);
                }
            }
            _iTokenGenerator.UserId = dbResult.Data.UserId;
            _iTokenGenerator.IsAccessAdmin = dbResult.Data.IsAccessAdmin;
            _iTokenGenerator.Token = dbResult.Data.Token;
            _iTokenGenerator.RefreshToken = dbResult.Data.RefreshToken;
            _iTokenGenerator.IsAccessCompanyPanel = false;

            return _iTokenGenerator.getJWT();
        }
        /// <summary>
        /// ورود به کمپانی پنل توسط شرکت
        /// </summary>
        /// <param name="ctx"></param>
        /// <param name="settingCtx"></param>
        /// <param name="queueContext"></param>
        /// <param name="redis"></param>
        /// <param name="logger"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        public async Task<DBResult> LoginCompany(LoginCommand command, CancellationToken cancellationToken)
        {
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);
            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }
            command.Username = command.Username.Trim();
            if (!command.Username.IsValidEmail())
            {
                command.Username = command.Username.NormalizePhoneNumberForLogin();
            }
            var dbResult = await _iAuthenticationContext.LoginCompany(new LoginCompany.Inputs { Username = command.Username, Password = command.Password }, cancellationToken);

            if (await checkIsActiveLogin(dbResult.Data.Token, cancellationToken))
            {
                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = 61064,
                    Code = GetLoginDateShamsi()
                }, cancellationToken);
            }

            _iTokenGenerator.UserId = dbResult.Data.UserId;
            _iTokenGenerator.IsAccessAdmin = dbResult.Data.IsAccessAdmin;
            _iTokenGenerator.Token = dbResult.Data.Token;
            _iTokenGenerator.RefreshToken = dbResult.Data.RefreshToken;
            _iTokenGenerator.IsAccessCompanyPanel = true;

            return _iTokenGenerator.getJWT();

        }


        public async Task<DBResult> SendCodeLogin(SendCodeLoginCommand command, CancellationToken cancellationToken)
        {
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }
            command.Address = command.Address.SetValidAddress(command.PrefixPhone, (VerifyType)command.TypeVerify);
            var dbResult = await _iAuthenticationContext.Insert_VerifyCode(new Insert_VerifyCode.Inputs
            {
                Address = command.Address,
                TypeVerify = command.TypeVerify
            }, cancellationToken);
            if (dbResult.Data != null)
            {
                if (command.TypeVerify == (int)VerifyType.Email)
                {
                    var resultEmail = await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"کد یکبار مصرف",
                        Body = "کد یکبار مصرف " + dbResult.Data.Code,
                        Email = command.Address
                    }, cancellationToken);
                    if (!string.IsNullOrWhiteSpace(resultEmail))
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به ایمیل شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                }
                if (command.TypeVerify == (int)VerifyType.Mobile)
                {
                    var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat
                        ,cancellationToken);
                    var settingWhatsapp = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                    if (settingWhatsapp.ParallelSendingWhatsappLogin == true
                        || command.SendCodeToWhatsApp == true)
                    {
                        await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                        {
                            ApiKey = webServiceInfo.RealApiKey,
                            BaseUrl = webServiceInfo.BaseUrlService,
                            Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف: " + dbResult.Data.Code,
                            Receivers = command.PrefixPhone.Replace("+", "") + dbResult.Data.Address
                        }, webServiceInfo, cancellationToken);
                    }
                    var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                    if (settingTelegram.ParallelSendingTelegramLogin == true || command.SendCodeToTelegram == true)
                    {
                        if (string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                        {
                            await _iAuthenticationContext.Expire_VerifyCode(new Expire_VerifyCode.Inputs
                            {
                                Address = command.Address,
                                Token = dbResult.Data.Token
                            }, cancellationToken);
                            throw new LogicalException("حساب شما به تلگرام متصل نیست ، لطفا روش دیگری را جهت ورود/ثبت نام انتخاب نمایید.");
                        }
                        await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                        {
                            Channel = dbResult.Data.ChatIdTelegram.Trim(),
                            Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                            ParseMode = "HTML"
                        }, cancellationToken);
                    }
                    if ((command.SendCodeToWhatsApp != true &&
    command.SendCodeToTelegram != true) || (settingTelegram.ParallelSendingTelegramLogin == true
    && settingWhatsapp.ParallelSendingWhatsappLogin == true))
                    {
                        var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                        {
                            Mobile = dbResult.Data.Address,
                            Pattern = 61031,
                            Code = dbResult.Data.Code
                        }, cancellationToken);
                        if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                            throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");

                    }

                }
                if (command.TypeVerify == (int)VerifyType.Phone)
                {
                    await _ttsHelper.callTTS(dbResult.Data.Address, dbResult.Data.Code, false, cancellationToken);
                }
                return new DBResult { Data = new { Token = dbResult.Data.Token, Address = dbResult.Data.Address, TypeVerify = command.TypeVerify, PrefixPhone = command.PrefixPhone } };
            }

            return new DBResult();


        }
        public async Task<DBResult> Verify(VerifyCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _iAuthenticationContext.VeriyCode_Login_Register(new VeriyCode_Login_Register.Inputs
            {
                Address = command.Address,
                TypeVerify = command.TypeVerify,
                Code = command.Code,
                Token = command.Token,
                CountryId = command.CountryId,
                ChatIdTelegram = command.ChatIdTelegram
            }, cancellationToken);

            if (await checkIsActiveLogin(dbResult.Data.Token, cancellationToken))
            {
                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = 61064,
                    Code = GetLoginDateShamsi()
                }, cancellationToken);

                if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Message = $"کاربر عزیز فراکنش ، شما در تاریخ {GetLoginDateShamsi()} وارد برنامه شدید.",
                        Channel = dbResult.Data.ChatIdTelegram.Trim()
                    }, cancellationToken);
                }

            }

            _iTokenGenerator.UserId = dbResult.Data.UserId;
            _iTokenGenerator.IsAccessAdmin = dbResult.Data.IsAccessAdmin;
            _iTokenGenerator.Token = dbResult.Data.Token;
            _iTokenGenerator.RefreshToken = dbResult.Data.RefreshToken;
            _iTokenGenerator.IsAccessCompanyPanel = false;

            return _iTokenGenerator.getJWT();
        }

        public async Task<DBResult> VerifyByCompany(VerifyCompanyCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResult = await _iAuthenticationContext.VeriyCode_Register_ByCompany(new VeriyCode_Register_ByCompany.Inputs
            {
                Address = command.Address,
                TokenVerify = command.TokenVerify,
                Code = command.Code,
                Token = token,
                CountryId = command.CountryId,
            }, cancellationToken);

            return new DBResult(new { dbResult.Data.UserId }, 1);
        }

        public async Task<DBResult> SendCodeInPanel(SendCodeInPanelCommand command, CancellationToken cancellationToken)
        {
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }

            command.Address = command.Address.SetValidAddress(command.PrefixPhone, (VerifyType)command.TypeVerify);
            var dbResult = await _iAuthenticationContext.Insert_VerifyCodeToken(new Insert_VerifyCodeToken.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Address = command.Address,
                TypeVerify = command.TypeVerify
            }, cancellationToken);
            if (dbResult.Data != null)
            {
                if (command.TypeVerify == (int)VerifyType.Email)
                {
                    var resultEmail = await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = "فعال سازی ایمیل",
                        Body = "کد یکبار مصرف " + dbResult.Data.Code,
                        Email = command.Address
                    }, cancellationToken);
                    if (!string.IsNullOrWhiteSpace(resultEmail))
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به ایمیل شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                }
                if (command.TypeVerify == (int)VerifyType.Mobile)
                {
                    var settingWhatsapp = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                    var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat
                        ,cancellationToken);
                    if (settingWhatsapp.ParallelSendingWhatsappLogin == true
                        || command.SendCodeToWhatsApp == true)
                    {
                        await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                        {
                            ApiKey = webServiceInfo.RealApiKey,
                            BaseUrl = webServiceInfo.BaseUrlService,
                            Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف: " + dbResult.Data.Code,
                            Receivers = command.PrefixPhone.Replace("+", "") + dbResult.Data.Address
                        }, webServiceInfo, cancellationToken);
                    }
                    var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                    if (settingTelegram.ParallelSendingTelegramLogin == true || command.SendCodeToTelegram == true)
                    {
                        if (string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                        {
                            await _iAuthenticationContext.Expire_VerifyCode(new Expire_VerifyCode.Inputs
                            {
                                Address = command.Address,
                                Token = dbResult.Data.Token
                            }, cancellationToken);
                            throw new LogicalException("حساب شما به تلگرام متصل نیست ، لطفا روش دیگری را جهت دریافت کد یکبار مصرف انتخاب نمایید.");
                        }
                        await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                        {
                            Channel = dbResult.Data.ChatIdTelegram.Trim(),
                            Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                            ParseMode = "HTML"

                        }, cancellationToken);
                    }
                    if ((command.SendCodeToWhatsApp != true &&
                        command.SendCodeToTelegram != true) || (settingTelegram.ParallelSendingTelegramLogin == true
                        && settingWhatsapp.ParallelSendingWhatsappLogin == true))
                    {
                        var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                        {
                            Mobile = dbResult.Data.Address,
                            Pattern = 61031,
                            Code = dbResult.Data.Code
                        }, cancellationToken);
                        if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                            throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                    }

                }

                if (command.TypeVerify == (int)VerifyType.Phone)
                {

                    await _ttsHelper.callTTS(dbResult.Data.Address, dbResult.Data.Code, command.SendCodeLandlineNumber.Value, cancellationToken);

                }
                return new DBResult { Data = new { Token = dbResult.Data.Token, Address = dbResult.Data.Address, TypeVerify = command.TypeVerify, PrefixPhone = command.PrefixPhone } };

            }

            return new DBResult();


        }

        public async Task<DBResult> SendCodeInTelegram(SendCodeInTelegramCommand command, CancellationToken cancellationToken)
        {
            var prefix = "";
            if (command.TypeVerify == (int)VerifyType.Mobile)
            {
                prefix = command.Address.ExtractCountryCallingCode();

            }


            command.Address = command.Address.SetValidAddress(prefix, (VerifyType)command.TypeVerify);
            if (!command.IsLogin)
            {
                await _addressContext.Check_ExistsAddress(new Check_ExistsAddress.Inputs
                {
                    Address = command.Address,
                    Type = command.TypeVerify
                }, cancellationToken);
            }

            var dbResult = await _iAuthenticationContext.Insert_VerifyCode(new Insert_VerifyCode.Inputs
            {
                Address = command.Address,
                TypeVerify = command.TypeVerify
            }, cancellationToken);

            if (dbResult.Data != null)
            {
                if (command.TypeVerify == (int)VerifyType.Email)
                {
                    var resultEmail = await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = "فعال سازی ایمیل",
                        Body = "کد یکبار مصرف " + dbResult.Data.Code,
                        Email = command.Address
                    }, cancellationToken);
                    if (!string.IsNullOrWhiteSpace(resultEmail))
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به ایمیل شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                }
                if (command.TypeVerify == (int)VerifyType.Mobile)
                {
                    var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                    var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat,cancellationToken);
                        await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                        {
                            ApiKey = webServiceInfo.RealApiKey,
                            BaseUrl = webServiceInfo.BaseUrlService,
                            Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف " + dbResult.Data.Code,
                            Receivers = prefix.Replace("+", "") + dbResult.Data.Address
                        }, webServiceInfo, cancellationToken);
  
                    var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                    if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                    {
                        await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                        {
                            Channel = dbResult.Data.ChatIdTelegram.Trim(),
                            Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                            ParseMode = "HTML"
                        }, cancellationToken);
                    }

                    var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResult.Data.Address,
                        Pattern = 61031,
                        Code = dbResult.Data.Code
                    }, cancellationToken);
                    if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");

                }

                return new DBResult
                {
                    Data = new
                    {
                        Token = dbResult.Data.Token,
                        Address = dbResult.Data.Address,
                        TypeVerify = command.TypeVerify
                    }
                };

            }

            return new DBResult();

        }

        public async Task<DBResult> SendCodeByCompany(SendCodeInCompanyCommand command, CancellationToken cancellationToken)
        {
            await _iAuthenticationContext.Check_VerifyCodeByCompany(new Check_VerifyCodeByCompany.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Address = command.Address
            }, cancellationToken);

            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }

            command.Address = command.Address.SetValidAddress(command.PrefixPhone, VerifyType.Mobile);

            var dbResult = await _iAuthenticationContext.Insert_VerifyCodeByCompany(new Insert_VerifyCodeByCompany.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Address = command.Address
            }, cancellationToken);

            if (dbResult.Data != null)
            {
                var settingWhatsapp = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat
                    ,cancellationToken);
                if (settingWhatsapp.ParallelSendingWhatsappLogin == true
                    || command.SendCodeToWhatsApp == true)
                {
                    await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                    {
                        ApiKey = webServiceInfo.RealApiKey,
                        BaseUrl = webServiceInfo.BaseUrlService,
                        Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف " + dbResult.Data.Code,
                        Receivers = command.PrefixPhone.Replace("+", "") + dbResult.Data.Address
                    }, webServiceInfo, cancellationToken);
                }
                var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Channel = dbResult.Data.ChatIdTelegram.Trim(),
                        Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                        ParseMode = "HTML"
                    }, cancellationToken);
                }

                if ((command.SendCodeToWhatsApp != true &&
    command.SendCodeToTelegram != true) || (settingTelegram.ParallelSendingTelegramLogin == true
    && settingWhatsapp.ParallelSendingWhatsappLogin == true))
                {
                    var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResult.Data.Address,
                        Pattern = 61031,
                        Code = dbResult.Data.Code
                    }, cancellationToken);
                    if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");

                }


                return new DBResult { Data = new { Token = dbResult.Data.Token, Address = dbResult.Data.Address, PrefixPhone = command.PrefixPhone } };

            }

            return new DBResult();
        }

        public async Task<DBResult> SendCodeByCompanyInPanel(SendCodeInCompanyCommand command, CancellationToken cancellationToken)
        {
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد امنیتی");
            }
            command.Address = command.Address.SetValidAddress(command.PrefixPhone, VerifyType.Mobile);
            var dbResult = await _iAuthenticationContext.Insert_VerifyCodeByCompany_Old_User(new Insert_VerifyCodeByCompany_Old_User.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Address = command.Address
            }, cancellationToken);

            if (dbResult.Data != null)
            {
                var settingWhatsapp = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat,cancellationToken);
                if (settingWhatsapp.ParallelSendingWhatsappLogin == true
                    || command.SendCodeToWhatsApp == true)
                {
                    await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                    {
                        ApiKey = webServiceInfo.RealApiKey,
                        BaseUrl = webServiceInfo.BaseUrlService,
                        Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف " + dbResult.Data.Code,
                        Receivers = command.PrefixPhone.Replace("+", "") + dbResult.Data.Address
                    }, webServiceInfo, cancellationToken);
                }
                var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Channel = dbResult.Data.ChatIdTelegram.Trim(),
                        Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                        ParseMode = "HTML"
                    }, cancellationToken);
                }

                if ((command.SendCodeToWhatsApp != true &&
    command.SendCodeToTelegram != true) || (settingTelegram.ParallelSendingTelegramLogin == true
    && settingWhatsapp.ParallelSendingWhatsappLogin == true))
                {
                    var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResult.Data.Address,
                        Pattern = 61031,
                        Code = dbResult.Data.Code
                    }, cancellationToken);
                    if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                }



                return new DBResult { Data = new { Token = dbResult.Data.Token, Address = dbResult.Data.Address, PrefixPhone = command.PrefixPhone } };

            }

            return new DBResult();
        }

        public async Task<DBResult> ReSendCode(ReSendCodeCommand command, CancellationToken cancellationToken)
        {

            var responseGoogleRecaptcha = await _reCaptchaHelper.validate(command.TokenRecaptcha, cancellationToken);

            if (!responseGoogleRecaptcha)
            {
                throw new InternalServiceException("لطفا ابتدا کپچا را تایید کنید");
            }

            command.Address = command.Address.SetValidAddress(command.PrefixPhone, (VerifyType)command.TypeVerify);
            var dbResult = await _iUserContext.ResendVerifyCode(new ResendVerifyCode.Inputs
            {
                Address = command.Address,
                TypeVerify = command.TypeVerify,
                Token = command.Token
            }, cancellationToken);
            if (dbResult.Data != null)
            {
                if (command.TypeVerify == (int)VerifyType.Email)
                {
                    var resultEmail = await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"کد یکبار مصرف",
                        Body = "کد یکبار مصرف " + dbResult.Data.Code,
                        Email = command.Address
                    }, cancellationToken);
                    if (!string.IsNullOrWhiteSpace(resultEmail))
                        throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به ایمیل شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                }
                if (command.TypeVerify == (int)VerifyType.Mobile)
                {
                    var settingWhatsapp = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
                    var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat, cancellationToken);
                    if (settingWhatsapp.ParallelSendingWhatsappLogin == true
                        || command.SendCodeToWhatsApp == true)
                    {
                        await _whatsappHelper.SendMessage(new SendMessageWhatsappRequestModel
                        {
                            ApiKey = webServiceInfo.RealApiKey,
                            BaseUrl = webServiceInfo.BaseUrlService,
                            Message = "فراکنش" + Environment.NewLine + "کد یکبار مصرف " + dbResult.Data.Code,
                            Receivers = command.PrefixPhone.Replace("+", "") + dbResult.Data.Address
                        }, webServiceInfo, cancellationToken);
                    }
                    var settingTelegram = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
                    if (settingTelegram.ParallelSendingTelegramLogin == true || command.SendCodeToTelegram == true)
                    {
                        if (string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                        {
                            await _iAuthenticationContext.Expire_VerifyCode(new Expire_VerifyCode.Inputs
                            {
                                Address = command.Address,
                                Token = dbResult.Data.Token
                            }, cancellationToken);
                            throw new LogicalException("حساب شما به تلگرام متصل نیست ، لطفا روش دیگری را جهت دریافت کد یکبار مصرف انتخاب نمایید.");
                        }
                        await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                        {
                            Channel = dbResult.Data.ChatIdTelegram.Trim(),
                            Message = $"فراکنش\nکد یکبار مصرف: <code>{dbResult.Data.Code}</code>",
                            ParseMode = "HTML"
                        }, cancellationToken);
                    }
                    if ((command.SendCodeToWhatsApp != true &&
        command.SendCodeToTelegram != true) || (settingTelegram.ParallelSendingTelegramLogin == true
        && settingWhatsapp.ParallelSendingWhatsappLogin == true))
                    {
                        var resultSMS = await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                        {
                            Mobile = command.Address,
                            Pattern = 61031,
                            Code = dbResult.Data.Code
                        }, cancellationToken);
                        if (resultSMS == null || resultSMS.FirstOrDefault().Key <= 0 || resultSMS.FirstOrDefault().Key >= 6)
                            throw new InternalServiceException("خطا در ارسال کد یکبار مصرف به شماره همراه شما رخ داده است ، در صورت تکرار خطا برای حل مشکل با کارشناسان ما ارتباط برقرار فرمایید");
                    }

                }

                if (command.TypeVerify == (int)VerifyType.Phone)
                {

                    await _ttsHelper.callTTS(command.Address, dbResult.Data.Code, command.SendCodeLandlineNumber.Value, cancellationToken);

                }
                return new DBResult { Data = new { Token = dbResult.Data.Token, Address = dbResult.Data.Address, TypeVerify = command.TypeVerify, PrefixPhone = command.PrefixPhone } };

            }


            return new DBResult();


        }

        public async Task<DBResult> verifyGoogle(VerifyGoogleCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.OpenIdGoogle,cancellationToken);

            var response = await _httpRequestOAuth.verifyGoogleToken(command.TokenId,
                 setting.BaseUrlService, cancellationToken);
            if (response == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه ی ورود به سیستم");
            var responseInfo = await _httpRequestOAuth.getTokenInfo(command.TokenId,
               setting.BaseUrlService, cancellationToken);
            if (responseInfo == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه ی ورود به سیستم");
            var dbResult = await _iAuthenticationContext.LoginWithSocial(new LoginWithSocial.Inputs { Username = responseInfo.email }, cancellationToken);


            if (await checkIsActiveLogin(dbResult.Data.Token, cancellationToken))
            {
                if (!string.IsNullOrWhiteSpace(dbResult.Data.ChatIdTelegram))
                {
                    await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                    {
                        Message = $"کاربر عزیز فراکنش ، شما در تاریخ {GetLoginDateShamsi()} وارد برنامه شدید.",
                        Channel = dbResult.Data.ChatIdTelegram.Trim()
                    }, cancellationToken);
                }

                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = 61064,
                    Code = GetLoginDateShamsi()
                }, cancellationToken);
            }
            _iTokenGenerator.UserId = dbResult.Data.UserId;
            _iTokenGenerator.IsAccessAdmin = dbResult.Data.IsAccessAdmin;
            _iTokenGenerator.Token = dbResult.Data.Token;
            _iTokenGenerator.RefreshToken = dbResult.Data.RefreshToken;
            _iTokenGenerator.IsAccessCompanyPanel = false;

            return _iTokenGenerator.getJWT();

        }

        public async Task<DBResult> Refresh(RefreshTokenCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _iAuthenticationContext.RefreshToken(new RefreshToken.Inputs
            { Token = _tokenUserService.getUserInfo().Token, RefreshToken = command.RefreshToken }, cancellationToken);

            _iTokenGenerator.UserId = dbResult.Data.UserId;
            _iTokenGenerator.IsAccessAdmin = dbResult.Data.IsAccessAdmin;
            _iTokenGenerator.Token = dbResult.Data.Token;
            _iTokenGenerator.RefreshToken = dbResult.Data.RefreshToken;
            _iTokenGenerator.IsAccessCompanyPanel = false;

            return _iTokenGenerator.getJWT();
        }

        private async Task<bool> checkIsActiveLogin(string token, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.getSettingConfigWalletAsync(token, cancellationToken);

            return setting.IsActiveLoginAlert.Value;
        }
        private string GetLoginDateShamsi()
        {
            return (DateTimeHelper.GetLocalTime().getShamsiDate() + "_" + DateTimeHelper.GetLocalTime().Hour + ":" + DateTimeHelper.GetLocalTime().Minute).ToPersianNumbers();
        }
    }
}
