﻿using Newtonsoft.Json;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using StackExchange.Redis;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.bank;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Models.Database;
using Farakonesh.Logic.IServices.IApp.IUser;
using System.Net.Http.Headers;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ISecurity;
using System.Threading;
using Farakonesh.Shared.Enums;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Shared.Helpers;

namespace Farakonesh.Logic.Services.App
{
    public class BankAccountService : IBankAccountService
    {
        private readonly IBankAccountContext _IBankAccountContext;
        private readonly IUserContext _IUserContext;
        private readonly IPublicContext _IPublicContext;
        private readonly IQueueContext _IQueueContext;
        private readonly ITokenUserService _tokenUserService;
        private readonly IHttpRequestJibit _httpRequestJibit;
        private readonly IRedisContextService _redisContextService;
        public BankAccountService(IBankAccountContext iBankAccountContext,
            IUserContext iUserContext, IPublicContext IPublicContext
            , IQueueContext IQueueContext,
            IHttpRequestJibit httpRequestJibit, ITokenUserService tokenUserService,
            IRedisContextService redisContextService)
        {
            _httpRequestJibit = httpRequestJibit;
            _IBankAccountContext = iBankAccountContext;
            _IUserContext = iUserContext;
            _IPublicContext = IPublicContext;
            _IQueueContext = IQueueContext;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
        }
        public async Task<DBResult<GetUser.Outputs>> ActionBankAccount(BankAccountCommand command, CancellationToken cancellationToken, bool isUpdate = false)
        {
            string token = _tokenUserService.getUserInfo().Token;

            var dbUser = await _IUserContext.GetUser(new GetUser.Inputs { Token = token }, cancellationToken);

            if(string.IsNullOrWhiteSpace(dbUser.Data.NationalCode))
            {
                throw new LogicalException("لطفا ابتدا کد ملی خود را در بخش اطلاعات پایه وارد نمائید");
            }

            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit,cancellationToken);

            await _IBankAccountContext.Check_BankAccount_User(new Check_BankAccount_User.Inputs
            {
                Token = token,
                CardNumber = command.CardNumber,
            }, cancellationToken);

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);
    
            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                    webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService,cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }

            var responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
            {
                CardBank = command.CardNumber,
                NationalCode = dbUser.Data.NationalCode,
                BirthDate = dbUser.Data.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                Server = webServiceInfo.BaseUrlService,
                Token = dbResult.Data.JibitToken
            }, cancellationToken);

            await responseMatchJibit.handlerInquiryMatched(false,token,_IUserContext,cancellationToken);
        
            if (!string.IsNullOrWhiteSpace(responseMatchJibit.code) && responseMatchJibit.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword, 
                    webServiceInfo.BaseUrlService,cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
                {
                    CardBank = command.CardNumber,
                    NationalCode = dbUser.Data.NationalCode,
                    BirthDate = dbUser.Data.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);
            }
            await responseMatchJibit.handlerInquiryMatched(true,token,_IUserContext,cancellationToken);

            var responseCardBankToSheba = await _httpRequestJibit.getCardBankDetailsJibit(command.CardNumber, dbResult.Data.JibitToken
                , webServiceInfo.BaseUrlService,cancellationToken);

           await responseCardBankToSheba.handlerGetBanckAccountInfo(true, token, _IUserContext, cancellationToken);

            var responseBank = await _IPublicContext.GetBankById(new GetBankById.Inputs
            {
                Token = token,
                BankId = null,
                Code = responseCardBankToSheba.ibanInfo.bank
            }, cancellationToken);


            if (responseBank == null || responseBank.Data == null || responseBank.Data.BankId == Guid.Empty)
                throw new InternalServiceException("بنظر می آید بانک شما پشتیبانی نمی شود ، برای راهنمایی بیشتر با ما تماس بگیرید");

            if (!isUpdate)
            {
                await _IBankAccountContext.Insert_BankAccount(new Insert_BankAccount.Inputs
                {
                    Token = token,
                    CardNumber = command.CardNumber,
                    ShabaNumber = responseCardBankToSheba.ibanInfo.iban.Replace("IR", ""),
                    BankId = responseBank.Data.BankId
                ,
                    DepositNumber = responseCardBankToSheba.ibanInfo.depositNumber
                }, cancellationToken);
            }
            else
            {
                await _IBankAccountContext.Update_BankAccount(new Update_BankAccount.Inputs
                {
                    Token = token,
                    CardNumber = command.CardNumber,
                    ShabaNumber = responseCardBankToSheba.ibanInfo.iban.Replace("IR", ""),
                    BankId = responseBank.Data.BankId
            ,
                    DepositNumber = responseCardBankToSheba.ibanInfo.depositNumber
                }, cancellationToken);
            }
            var responseUserProfile = await _IUserContext.GetUser(new GetUser.Inputs { Token = token }, cancellationToken);

            return responseUserProfile;

        }

        public async Task<DBResult<GetUserByIdAdmin.Outputs>> actionBankAccountByAdmin(BankAccountByAdminCommand command, CancellationToken cancellationToken, bool isUpdate = false)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit,cancellationToken);

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);
   
            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                    webServiceInfo.RealPassword, webServiceInfo.BaseUrlService,cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }
            if(command.Inquiry == true)
            {
                var responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
                {
                    CardBank = command.CardNumber,
                    NationalCode = command.NationalCode,
                    BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);
                await responseMatchJibit.handlerInquiryMatched(false, token, _IUserContext, cancellationToken);

                if (!string.IsNullOrWhiteSpace(responseMatchJibit.code) && responseMatchJibit.code == "forbidden")
                {
                    var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey,
                        webServiceInfo.RealPassword
                        , webServiceInfo.BaseUrlService, cancellationToken);
                    if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                        throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                    dbResult.Data.JibitToken = responseJibit.accessToken;
                    await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                    responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
                    {
                        CardBank = command.CardNumber,
                        NationalCode = command.NationalCode,
                        BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                        Server = webServiceInfo.BaseUrlService,
                        Token = dbResult.Data.JibitToken
                    }, cancellationToken);
                }
                await responseMatchJibit.handlerInquiryMatched(true, token, _IUserContext, cancellationToken);
            }

            var responseCardBankToSheba = await _httpRequestJibit.getCardBankDetailsJibit(command.CardNumber, dbResult.Data.JibitToken,
                webServiceInfo.BaseUrlService,cancellationToken);
            
            await responseCardBankToSheba.handlerGetBanckAccountInfo(false, token, _IUserContext, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseCardBankToSheba.code) && responseCardBankToSheba.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                 responseCardBankToSheba = await _httpRequestJibit.getCardBankDetailsJibit(command.CardNumber, dbResult.Data.JibitToken,
                  webServiceInfo.BaseUrlService, cancellationToken);
            }

            await responseCardBankToSheba.handlerGetBanckAccountInfo(true, token, _IUserContext, cancellationToken);

            var responseBank = await _IPublicContext.GetBankById(new GetBankById.Inputs
            {
                Token = token,
                BankId = null,
                Code = responseCardBankToSheba.ibanInfo.bank
            }, cancellationToken);


            if (responseBank == null || responseBank.Data == null || responseBank.Data.BankId == Guid.Empty)
                throw new InternalServiceException("بنظر می آید بانک شما پشتیبانی نمی شود ، برای راهنمایی بیشتر با ما تماس بگیرید");

            if (!isUpdate)
            {
                await _IBankAccountContext.Insert_BankAccountByAdmin(new Insert_BankAccountByAdmin.Inputs
                {
                    Token = token,
                    CardNumber = command.CardNumber,
                    ShabaNumber = responseCardBankToSheba.ibanInfo.iban.Replace("IR", ""),
                    BankId = responseBank.Data.BankId,
                    UserId = command.UserId,
                    DepositNumber = responseCardBankToSheba.ibanInfo.depositNumber
                }, cancellationToken);
            }
            else
            {
                await _IBankAccountContext.Update_BankAccountByAdmin(new Update_BankAccountByAdmin.Inputs
                {
                    Token = token,
                    CardNumber = command.CardNumber,
                    ShabaNumber = responseCardBankToSheba.ibanInfo.iban.Replace("IR", ""),
                    BankId = responseBank.Data.BankId,
                    UserId = command.UserId,
                    DepositNumber = responseCardBankToSheba.ibanInfo.depositNumber
                }, cancellationToken);
            }
            var responseUserProfile = await _IUserContext.GetUserByIdAdmin(new GetUserByIdAdmin.Inputs
            { Token = token, UserId = command.UserId }, cancellationToken);

            return responseUserProfile;

        }


        public async Task<DBResult> checkBankAccountByAdmin(CheckBankAccountByAdminCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit,cancellationToken);
           
            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);



            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword, 
                    webServiceInfo.BaseUrlService,cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }

            var responseMatchJibit = new ResponseMatchJibit();

            responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
            {
                CardBank = command.CardNumber,
                NationalCode = command.NationalCode,
                BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                Server = webServiceInfo.BaseUrlService,
                Token = dbResult.Data.JibitToken
            }, cancellationToken);
            await responseMatchJibit.handlerInquiryMatched(false, token, _IUserContext, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseMatchJibit.code) && responseMatchJibit.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService,cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                responseMatchJibit = await _httpRequestJibit.checkCardBankJibit(new RequestMatchCardBankJibit
                {
                    CardBank = command.CardNumber,
                    NationalCode = command.NationalCode,
                    BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);
            }
            await responseMatchJibit.handlerInquiryMatched(true, token, _IUserContext, cancellationToken);

            var responseCardBankToSheba = await _httpRequestJibit.getCardBankDetailsJibit(command.CardNumber, dbResult.Data.JibitToken,
                webServiceInfo.BaseUrlService,cancellationToken);

            await responseCardBankToSheba.handlerGetBanckAccountInfo(true, token, _IUserContext, cancellationToken);

            var responseBank = await _IPublicContext.GetBankById(new GetBankById.Inputs
            {
                Token = token,
                BankId = null,
                Code = responseCardBankToSheba.ibanInfo.bank
            }, cancellationToken);

            if (responseBank == null || responseBank.Data == null || responseBank.Data.BankId == Guid.Empty)
                throw new InternalServiceException("بنظر می آید بانک شما پشتیبانی نمی شود ، برای راهنمایی بیشتر با ما تماس بگیرید");

            return new DBResult { };

        }
    }
}
