﻿using Farakonesh.Commands.Services.Queue;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.Goftino;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.App
{
    public class ChatService : IChatService
    {
        private readonly ILog _logger;
        private readonly RedisService _redis;
        private readonly ISettingContext _ISettingContext;
        private readonly IQueueContext _IQueueContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly IHttpRequestGoftino _httpRequestGoftino;
        private readonly IRedisContextService _redisContextService;
        private readonly ITelegramHelper _telegramHelper;
        public ChatService(ISettingContext iSettingContext,
ILog logger,
RedisService redis,
IQueueContext iQueueContext,
IMailHelper iMailHelper, ISmsHelper iSmsHelper, IHttpRequestGoftino httpRequestGoftino,
IRedisContextService redisContextService, ITelegramHelper telegramHelper)
        {
            _httpRequestGoftino = httpRequestGoftino;
            _ISettingContext = iSettingContext;
            _logger = logger;
            _redis = redis;
            _IQueueContext = iQueueContext;
            _IMailHelper = iMailHelper;
            _ISmsHelper = iSmsHelper;
            _telegramHelper = telegramHelper;
            _redisContextService = redisContextService;
        }
        public async Task<DBResult> getChat(GetChatHistoryCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.Goftino,cancellationToken);

            var response = await _httpRequestGoftino.getGoftinoChat(command.ChatId, setting.RealApiKey, setting.BaseUrlService, cancellationToken);

            return new DBResult() { Data = response };

        }

        public async Task<DBResult> saveEvent(ResponseWebHookMessage command, CancellationToken cancellationToken)
        {
            _logger.Information(command.ObjToJson(), 3);
            if (string.IsNullOrWhiteSpace(command.code) && (command.data == null || command.data.sender == null))
            {
                throw new InternalServiceException("خطا در دریافت نتیجه گفتینو");
            }

            var dbResultChat = await _IQueueContext.Insert_Chat(new Insert_Chat.Inputs
            {
                ChatId = command.data.chat_id,
                Role = command.data.sender.from,
                Status = !string.IsNullOrWhiteSpace(command.code) ? Convert.ToInt32(command.code) : 1
            }, cancellationToken);
            if (command.data.sender.from != "operator")
            {
                foreach (var item in dbResultChat.Data)
                {

                    if (item.AlarmNewChat == true && item.SendEmail == true)
                    {
                        await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                        {
                            Subject = $"پیغام جدید در سیستم گفتینو",
                            Body = $"اپراتور گرامی، یک پیغام جدید در سیستم گفتینو ارسال شده ، لطفا هرچه سریعتر نسبت به بررسی آن اقدام فرمایید",
                            Email = item.Email
                        }, cancellationToken);
                    }

                    if (item.AlarmNewChat == true && item.SendSMS == true)
                    {

                        await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                        {
                            Mobile = item.Mobile,
                            Pattern = 61049,
                            Code = "گفتینو",

                        }, cancellationToken);
                    }

                    if (item.AlarmNewChat == true && item.SendTelegram == true && !string.IsNullOrWhiteSpace(item.ChatIdTelegram))
                    {

                        await _telegramHelper.SendMessageToBot(new RequestSendMessageToBotTelegramModel
                        {
                            Channel = item.ChatIdTelegram,
                            Message = $"اپراتور گرامی، یک پیغام جدید در سیستم گفتینو ارسال شده ، لطفا هرچه سریعتر نسبت به بررسی آن اقدام فرمایید",

                        }, cancellationToken);
                    }
                }
            }

            return new DBResult() { };

        }
    }
}
