﻿using Newtonsoft.Json;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.Services.Queue;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.User
{
    public class InboxService : IInboxService
    {
        private readonly ISendEmailQueue _requestSendEmail;
        private readonly IInboxContext _IInboxContext;
        private readonly IUserContext _IUserContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly ITokenUserService _tokenUserService;
        public InboxService(IInboxContext IInboxContext,
            IUserContext IUserContext, ISmsHelper ISmsHelper, ISendEmailQueue requestSendEmail,
            ITokenUserService tokenUserService)
        {
            _IInboxContext  = IInboxContext;
            _IUserContext = IUserContext;
            _ISmsHelper = ISmsHelper;
            _requestSendEmail = requestSendEmail;
            _tokenUserService = tokenUserService;
        }


        public async Task<DBResult> Insert(SaveInboxCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

                await _IInboxContext.Insert_Inbox(new Insert_Inbox.Inputs
                {
                    Token = token,
                    Importance = command.Importance,
                    PartId = command.PartId,
                    SubjectId = command.SubjectId,
                    Text = command.Text,
                    Title = command.Title,
                    UserIdReceiver = command.UserIdReceiver,
                    SendToAll = command.SendToAll
                }, cancellationToken);

            if (command.SendToEmail == true)
            {
                var emailListQueue = new List<EmailSendModel>();
                var emailListResult = await _IUserContext.GetEmailList(new GetEmailList.Inputs { Token = token }, cancellationToken);
                foreach (var email in emailListResult.Data)
                {
                    emailListQueue.Add(new EmailSendModel { text = command.Text, title = command.Title, email = email.Email });
                }

                await _requestSendEmail.sendToQueue(emailListQueue);
            }
            if (command.SendToSMS == true)
            {
                var smsListQueue = new List<string>();
                var mobileListResult = await _IUserContext.GetMobileList(new GetMobileList.Inputs { Token = token }, cancellationToken);
                foreach (var item in mobileListResult.Data)
                {
                    smsListQueue.Add(item.Mobile);
                }

                await _ISmsHelper.sendSMSGroups(smsListQueue, command.Text,cancellationToken);
            }

            return new DBResult(new { }, 0);


        }
    }
}
