﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Commands.Services.User;

namespace Farakonesh.Logic.Services.App.User
{
    public class PointWalletService: IPointWalletService
    {
        private readonly IWalletContext _IWalletContext;
        private readonly ISmsHelper _smsHelper;
        private readonly IMailHelper _mailHelper;
        private readonly ITokenUserService _tokenUserService;
        public PointWalletService(IWalletContext iWalletContext, IMailHelper mailHelper, ISmsHelper smsHelper
            , ITokenUserService tokenUserService)
        {
            _IWalletContext = iWalletContext;
            _mailHelper = mailHelper;
            _smsHelper = smsHelper;
            _tokenUserService = tokenUserService;
        }


        public async Task<DBResult> ConvertPointWalletToWallet(ConvertPointWalletToWalletCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IWalletContext.ConvertPointWalletToWallet(new ConvertPointWalletToWallet.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Point = command.Point
            }, cancellationToken);

                await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"تبدیل امتیاز به کیف نقدی",
                    Body = $"کاربر عزیز ، {command.Point} امتیاز با موفقیت به کیف پول نقدی شما تبدیل شد ، هم اکنون میتونی استفاده ش کنی!",
                    Email = dbResult.Data.Email
                }, cancellationToken);

         
            await _smsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResult.Data.Mobile,
                Pattern = 61075,
                Code = command.Point.ToString()
            }, cancellationToken);


            return new DBResult(new { }, 0);
        }
        public async Task<DBResult> UpdatePointWalletByAdmin(UpdatePointWalletByAdminCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IWalletContext.UpdatePointWallet(new UpdatePointWallet.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Point = command.Point,
                ResetPointWallet = command.ResetPointWallet,
                TransactionType = command.TransactionType,
                UserId = command.UserId,
                PointWalletId = command.PointWalletId,
                ExpirationDay = command.ExpirationDay
            }, cancellationToken);

            if (command.ResetPointWallet == true)
            {
                return new DBResult(new { }, 0);
            }
            int patternMessage = 61077;
            if (command.TransactionType == 683)
            {
                await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"اختصاص امتیاز برای شما",
                    Body = $"کاربر عزیز {command.Point} امتیاز به حساب شما افزوده شد ، جهت مشاهده جزئیات وارد پنل کاربری خود شوید",
                    Email = dbResult.Data.Email
                }, cancellationToken);

            }
            else
            {
                patternMessage = 61078;
                await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"کسر امتیاز از شما",
                    Body = $"کاربر عزیز {command.Point} امتیاز از شما کسر گردید ، جهت مشاهده جزئیات وارد پنل کاربری خود شوید",
                    Email = dbResult.Data.Email
                }, cancellationToken);
            }
            await _smsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResult.Data.Mobile,
                Pattern = patternMessage,
                Code = command.Point.ToString()
            }, cancellationToken);


            return new DBResult(new { }, 0);
        }

    }
}
