﻿using Newtonsoft.Json;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.shortLink;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.staticData;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Models.API.SMS;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database.User;
using Farakonesh.Logic.ISecurity;
using System.Threading;
using Farakonesh.Logic.IServices.ICache;

namespace Farakonesh.Logic.Services.App
{
    public class TicketService : ITicketService
    {
        private readonly ITicketContext _ITicketContext;
        private readonly IQuestionsContext _IQuestionsContext;
        private readonly ISettingContext _ISettingContext;
        private readonly IPublicContext _IPublicContext;
        private readonly IMailHelper _IMailHelper;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IStaticContext _IStaticContext;
        private readonly IPartContext _IPartContext;
        private readonly ISubjectContext _ISubjectContext;
        private readonly ITokenUserService _tokenUserService;
        private readonly RedisService _redis;
        private readonly IRedisContextService _redisContextService;

        public TicketService(ITicketContext ITicketContext
            , ISettingContext ISettingContext, IPublicContext IPublicContext, ISmsHelper ISmsHelper
            , IMailHelper IMailHelper, IStaticContext IStaticContext, IPartContext IPartContext
            , ISubjectContext ISubjectContext, IQuestionsContext IQuestionsContext, RedisService redis,
            ITokenUserService tokenUserService, IRedisContextService redisContextService)
        {
            _ITicketContext = ITicketContext;
            _IPublicContext = IPublicContext;
            _ISettingContext = ISettingContext;
            _IMailHelper = IMailHelper;
            _ISmsHelper = ISmsHelper;
            _ISubjectContext = ISubjectContext;
            _IStaticContext = IStaticContext;
            _IPartContext = IPartContext;
            _IQuestionsContext = IQuestionsContext;
            _redis = redis;
            _tokenUserService = tokenUserService;
            _redisContextService = redisContextService;
        }


        public async Task<DBResult> InsertTicketByAdmin(InsertTicketByAdminCommand command, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
        
            var dbResult = await _ITicketContext.Insert_TicketByAdmin(new Insert_TicketByAdmin.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                UserIdReceiver = command.UserIdReceiver,
                SubjectId = command.SubjectId,
                Title = command.Title,
                Text = command.Text,
                Importance = command.Importance,
                FileList = command.FileList,
            }, cancellationToken);
            if (dbResult.Data != null)
            {
    
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"تیکت جدید به شماره {dbResult.Data.Number}",
                    Body = $"یک تیکت جدید به شماره {dbResult.Data.Number} برای شما ارسال شده است",
                    Email = dbResult.Data.EmailReceiver
                }, cancellationToken);

                if (!string.IsNullOrWhiteSpace(dbResult.Data.MobileReceiver))
                {
                    var dbResultShortLink = await _IPublicContext.Get_ShortLink(new Get_ShortLink.Inputs { CompleteUrl = setting.SiteUrlRootPanel + "dashboard/tickets/showticket/" + dbResult.Data.TicketId.ToString() }, cancellationToken);
                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResult.Data.MobileReceiver,
                        Pattern = 61044,
                        Code = dbResult.Data.Number.ToString(),
                        Code2 = dbResultShortLink.Data.ShortUrl
                    }, cancellationToken);
                }
            }
            return new DBResult(new { }, 0);
        }

        public async Task<DBResult> InsertContent(InsertContentCommand command, CancellationToken cancellationToken)
        {
            var userInfo = _tokenUserService.getUserInfo();
            var userIdClient = Guid.Parse(userInfo.UserId);
            var dbResult = await _ITicketContext.Insert_TicketContent(new Insert_TicketContent.Inputs
            {
                Token = userInfo.Token,
                TicketId = command.TicketId
                ,
                UserId = command.UserId,
                Text = command.Text,
                FileList = command.FileList
            }, cancellationToken);
            if (dbResult.Data != null)
            {
                if (command.UserId != null)
                {
                    string mobile = "";
                    string email = "";
                    if (command.UserId.Equals(userIdClient))
                    {
                        email = dbResult.Data.EmailReceiver;
                        mobile = dbResult.Data.MobileReceiver;
                    }
                    else if (dbResult.Data.UserIdReceiver == null || userIdClient.Equals(dbResult.Data.UserIdReceiver))
                    {
                        email = dbResult.Data.EmailSender;
                        mobile = dbResult.Data.MobileSender;
                    }
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"تیکت شماره {dbResult.Data.Number}#",
                        Body = $"تیکت شما به شماره {dbResult.Data.Number}# پاسخ داده شد",
                        Email = email
                    }, cancellationToken);


                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = mobile,
                        Pattern = 61033,
                        Code = "#" + dbResult.Data.Number.ToString()
                    }, cancellationToken);

                }
                else
                {
                    string mobile = "";
                    string email = "";
                    if (userIdClient.Equals(dbResult.Data.UserIdSender))
                    {
                        mobile = dbResult.Data.MobileReceiver;
                        email = dbResult.Data.EmailReceiver;
                    }
                    else if (userIdClient.Equals(dbResult.Data.UserIdReceiver))
                    {
                        mobile = dbResult.Data.MobileSender;
                        email = dbResult.Data.EmailSender;
                    }
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"تیکت شماره {dbResult.Data.Number}#",
                        Body = $"یک پاسخ جدید برای تیکت به شماره {dbResult.Data.Number}# دریافت شده است",
                        Email = email
                    }, cancellationToken);
                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = mobile,
                        Pattern = 61060,
                        Code = "#" + dbResult.Data.Number.ToString()
                    }, cancellationToken);
                }


            }
            return new DBResult(new { }, 0);
        }

        public async Task<DBResult> GetTicketContent(GetTicketContentCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResult = await _ITicketContext.GetTicketContent(new GetTicketContent.Inputs
            {
                Token = token,
                TicketId = command.TicketId
            }, cancellationToken);

            if (dbResult.Data != null && dbResult.Data.Count() > 0)
            {
                foreach (var item in dbResult.Data)
                {
                    var dbResultAttachment = await _ITicketContext.GetTicketAttachments(new GetTicketAttachments.Inputs
                    {
                        Token = token,
                        TicketContentId = item.TicketContentId
                    }, cancellationToken);
                    if (dbResultAttachment.Data != null)
                    {
                        var actionResponseAttachments = JsonConvert.DeserializeObject<List<GetTicketAttachments.Outputs>>(JsonConvert.SerializeObject(dbResultAttachment.Data));
                        if (actionResponseAttachments != null && actionResponseAttachments.Count > 0)
                            item.Attachments = actionResponseAttachments;
                    }
                }
                return new DBResult(dbResult.Data, dbResult.Data.Count());
            }

            return new DBResult(new { }, 0);

        }

        public async Task<DBResult> GetTicketContentByAdmin(GetTicketContentCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var dbResult = await _ITicketContext.GetTicketContentByAdmin(new GetTicketContentByAdmin.Inputs
            {
                Token = token,
                TicketId = command.TicketId
            }, cancellationToken);

            if (dbResult.Data != null && dbResult.Data.Count() > 0)
            {
                foreach (var item in dbResult.Data)
                {
                    var dbResultAttachment = await _ITicketContext.GetTicketAttachments(new GetTicketAttachments.Inputs
                    {
                        Token = token,
                        TicketContentId = item.TicketContentId
                    }, cancellationToken);
                    if (dbResultAttachment.Data != null)
                    {
                        var actionResponseAttachments = JsonConvert.DeserializeObject<List<GetTicketAttachments.Outputs>>(JsonConvert.SerializeObject(dbResultAttachment.Data));
                        if (actionResponseAttachments != null && actionResponseAttachments.Count > 0)
                            item.Attachments = actionResponseAttachments;
                    }
                }
                return new DBResult(dbResult.Data, dbResult.Data.Count());
            }

            return new DBResult(new { }, 0);


        }

        public async Task<DBResult> getFull(GetFullTicketCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            return new DBResult()
            {
                Data = new
                {
                    Subject = await _ISubjectContext.GetSubject(new GetSubject.Inputs
                    {
                        Token = token
                    }, cancellationToken),
                    Part = await _IPartContext.GetPart(new GetPart.Inputs
                    {
                        Token = token
                    }, cancellationToken)
                ,
                    Level = await _IStaticContext.GetStatic(new GetStatic.Inputs
                    {
                        ParentId = command.ParentId,
                        Token = token
                    }, cancellationToken),
                    Ticket = command.TicketId != null ? await _ITicketContext.GetTicketById(new GetTicketById.Inputs
                    {
                        TicketId = command.TicketId,
                        Token = token
                    }, cancellationToken) : null,
                    Question = await _IQuestionsContext.Get_Question(new Get_Question.Inputs
                    {
                        OrderType = 401
                    }, cancellationToken)

                },
                ActualSize = 0
            };
        }
    }
}
