﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.Database.User;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.menu;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.User
{
    public class UserServices : IUserServices
    {

        private readonly IQueueContext _IQueueContext;
        private readonly IUserContext _IUserContext;
        private readonly IDiscountContext _IDiscountContext;
        private readonly IInboxContext _IInboxContext;
        private readonly IMenusContext _IMenusContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly ICompanyContext _ICompanyContext;
        private readonly IHttpRequestCaptcha _httpRequestCaptcha;
        private readonly IHttpRequestJibit _httpRequestJibit;
        private readonly ITokenUserService _tokenUserService;
        private readonly IRedisContextService _redisContextService;
        public UserServices(IQueueContext IQueueContext, IUserContext IUserContext,
            IInboxContext IInboxContext
            , IMenusContext IMenusContext,
            ISmsHelper ISmsHelper, IMailHelper IMailHelper, ICompanyContext ICompanyContext, IHttpRequestCaptcha httpRequestCaptcha,
            IHttpRequestJibit httpRequestJibit, ITokenUserService tokenUserService, IDiscountContext IDiscountContext
            , IRedisContextService redisContextService)
        {
            _IQueueContext = IQueueContext;
            _IUserContext = IUserContext;
            _IInboxContext = IInboxContext;
            _IMenusContext = IMenusContext;
            _ISmsHelper = ISmsHelper;
            _IMailHelper = IMailHelper;
            _ICompanyContext = ICompanyContext;
            _httpRequestCaptcha = httpRequestCaptcha;
            _httpRequestJibit = httpRequestJibit;
            _tokenUserService = tokenUserService;
            _IDiscountContext = IDiscountContext;
            _redisContextService = redisContextService;
        }

        public async Task<DBResult> SaveNewUser(SaveNewUserCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            if (!string.IsNullOrWhiteSpace(command.Mobile))
                command.Mobile = command.Mobile.SetValidAddress(command.PrefixPhone, VerifyType.Mobile);

            await _IUserContext.Insert_User(new Insert_User.Inputs
            {
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                Gender = command.Gender,
                NationalCode = command.NationalCode,
                Token = token,
                AvatarId = command.AvatarId,
                ChatIdTelegram = command.ChatIdTelegram,
                CountryId = command.CountryId,
                Email = command.Email,
                IsActive = command.IsActive,
                IsVerifyEmail = command.IsVerifyEmail,
                IsVerifyMobile = command.IsVerifyMobile,
                IsVerifyTel = command.IsVerifyTel,
                Key = command.Key,
                Mobile = command.Mobile,
                Tel = command.Tel,
                Username = command.Username,
                UsernameTelegram = command.UsernameTelegram,
            }, cancellationToken);

            return new DBResult(new { }, 1);
        }

        public async Task<DBResult> UpdateUser(UpdateUserCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            if (!string.IsNullOrWhiteSpace(command.Mobile))
                command.Mobile = command.Mobile.SetValidAddress(command.PrefixPhone, VerifyType.Mobile);

            await _IUserContext.Update_User(new Update_User.Inputs
            {
                UserId = command.UserId,
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                Gender = command.Gender,
                NationalCode = command.NationalCode,
                Token = token,
                AvatarId = command.AvatarId,
                ChatIdTelegram = command.ChatIdTelegram,
                CountryId = command.CountryId,
                Email = command.Email,
                IsActive = command.IsActive,
                IsVerifyEmail = command.IsVerifyEmail,
                IsVerifyMobile = command.IsVerifyMobile,
                IsVerifyTel = command.IsVerifyTel,
                Mobile = command.Mobile,
                Tel = command.Tel,
                Username = command.Username,
                UsernameTelegram = command.UsernameTelegram,

            }, cancellationToken);

            return new DBResult(new { }, 1);
        }

        public async Task<DBResult> sendNewPassword(SendNewPasswordCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            var responseCaptcha = await _httpRequestCaptcha.CheckCaptcha(command.CaptchaCode, command.CaptchaId, cancellationToken);
            if (!string.IsNullOrWhiteSpace(responseCaptcha))
            {
                throw new ExternalServiceException("خطا در احراز کد کپچا");
            }
            string password = ConvertHelper.createPassword(7);
            var dbResult = await _IUserContext.Update_Password_Auto_Generate(new Update_Password_Auto_Generate.Inputs
            {
                Token = token,
                Password = password
            }, cancellationToken);

            if (!string.IsNullOrWhiteSpace(dbResult.Data.Mobile))
            {
                await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                {
                    Mobile = dbResult.Data.Mobile,
                    Pattern = 61063,
                    Code = password
                }, cancellationToken);
            }
            else
            {
                await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"رمز عبور جدید",
                    Body = "رمز عبور جدید شما " + password + " لطفا پس از ورود به برنامه نسبت به تغییر آن اقدام نمایید",
                    Email = dbResult.Data.Email
                }, cancellationToken);
            }

            return new DBResult { };


        }

        public async Task<DBResult> sendAlarmDiscountCodeByCompany(GetDiscountForAlarmByCompanyCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;


            var dbResult = await _IDiscountContext.GetDiscountForAlarmByCompany(new GetDiscountForAlarmByCompany.Inputs
            {
                Token = token,
                CompanyId = command.CompanyId,
                DiscountId = command.DiscountId,
                UserId = command.UserId
            }, cancellationToken);
            if (dbResult.Data == null)
            {
                throw new NoDataFoundException("اطلاعاتی یافت نشد");
            }


            await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResult.Data.Mobile,
                Pattern = 61070,
                Code = dbResult.Data.DiscountCode,
                Code2 = dbResult.Data.TitleCompany
            }, cancellationToken);

            return new DBResult { };

        }

        public async Task<DBResult> getFull(CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            return new DBResult()
            {
                Data = new
                {
                    User = await _IUserContext.GetUser(new GetUser.Inputs
                    {
                        Token = token
                    }, cancellationToken),
                    Menu = await _IMenusContext.Get_Menus(new Get_Menus.Inputs
                    {
                        Key = "customermenu"
                    }, cancellationToken),
                    Inbox = await _IInboxContext.GetInbox(new GetInbox.Inputs
                    {
                        PageSize = 5,
                        IsNew = true,
                        Sort = "",
                        ImportanceList = Convert.ToInt32(Importance.Important).ToString() + "," + Convert.ToInt32(Importance.Necessary).ToString(),
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Counts = await _IUserContext.GetCounts(new GetCounts.Inputs
                    {
                        Token = token
                    }, cancellationToken)
                },
                ActualSize = 0
            };
        }

        public async Task<DBResult> getFullCompany(GetFullCompanyCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            return new DBResult()
            {
                Data = new
                {
                    User = await _IUserContext.GetUser(new GetUser.Inputs
                    {
                        Token = token
                    }, cancellationToken),
                    Menu = await _IMenusContext.Get_Menus(new Get_Menus.Inputs
                    {
                        Key = "company"
                    }, cancellationToken),
                    Inbox = await _IInboxContext.GetInbox(new GetInbox.Inputs
                    {
                        PageSize = 5,
                        IsNew = true,
                        Sort = "",
                        StartIndex = 1,
                        Token = token
                    }, cancellationToken),
                    Counts = await _IUserContext.GetCounts(new GetCounts.Inputs
                    {
                        Token = token
                    }, cancellationToken),
                    Company = await _ICompanyContext.GetCompany(new GetCompany.Inputs
                    {
                        Token = token,
                        CompanyId = command.CompanyId
                    }, cancellationToken)
                },
                ActualSize = 0
            };
        }

        private async Task jibitInquiry(JibitInquiryCommand command, IUserContext _context, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit, cancellationToken);

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }
            var responseIdentityJibit = new ResponseRegisteryOfficeJibit();

            responseIdentityJibit = await _httpRequestJibit.getIdentityRegisteryOffice(new RequestRegisteyOfficeJibit
            {

                NationalCode = command.NationalCode,
                BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                Server = webServiceInfo.BaseUrlService,
                Token = dbResult.Data.JibitToken,
                FirstName = command.Name,
                LastName = command.Family
            }, cancellationToken);
            await responseIdentityJibit.handlerIdenticator(false, command.Token, _context, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseIdentityJibit.code) && responseIdentityJibit.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                responseIdentityJibit = await _httpRequestJibit.getIdentityRegisteryOffice(new RequestRegisteyOfficeJibit
                {

                    NationalCode = command.NationalCode,
                    BirthDate = command.BirthDate.Value.getShamsiWithoutSlash().ToString(),
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken,
                    FirstName = command.Name,
                    LastName = command.Family
                }, cancellationToken);


            }
            await responseIdentityJibit.handlerIdenticator(true, command.Token, _context, cancellationToken);

        }

        public async Task JibitInquiryShahkar(JibitInquiryShahkarCommand command, IUserContext _context, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(command.Token))
            {
                command.Token = _tokenUserService.getUserInfo().Token;
            }
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.InquiryJibit, cancellationToken);

            var dbResult = await _IQueueContext.Get_Last_Token(new Get_Last_Token.Inputs { TokenType = (int)TokenType.JibitInquiry }, cancellationToken);

            if (string.IsNullOrWhiteSpace(dbResult.Data.JibitToken))
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
            }
            var responseMatchShahkarJibit = new ResponseMatchJibit();

            responseMatchShahkarJibit = await _httpRequestJibit.CheckShahkar(new RequestMatchShahkarJibit
            {

                NationalCode = command.NationalCode,
                MobileNumber = command.MobileNumber,
                Server = webServiceInfo.BaseUrlService,
                Token = dbResult.Data.JibitToken
            }, cancellationToken);
            await responseMatchShahkarJibit.handlerInquiryMatchedShahkar(false, command.Token, _context, cancellationToken);

            if (!string.IsNullOrWhiteSpace(responseMatchShahkarJibit.code) && responseMatchShahkarJibit.code == "forbidden")
            {
                var responseJibit = await _httpRequestJibit.getTokenJibit(webServiceInfo.RealApiKey, webServiceInfo.RealPassword
                    , webServiceInfo.BaseUrlService, cancellationToken);
                if (responseJibit == null || string.IsNullOrWhiteSpace(responseJibit.accessToken))
                    throw new ExternalServiceException("خطا در دریافت امضای اعتبار سنجی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
                dbResult.Data.JibitToken = responseJibit.accessToken;
                await _IQueueContext.Insert_Token(new Insert_Token.Inputs { JibitToken = responseJibit.accessToken }, cancellationToken);
                responseMatchShahkarJibit = await _httpRequestJibit.CheckShahkar(new RequestMatchShahkarJibit
                {

                    NationalCode = command.NationalCode,
                    MobileNumber = command.MobileNumber,
                    Server = webServiceInfo.BaseUrlService,
                    Token = dbResult.Data.JibitToken
                }, cancellationToken);


            }
            await responseMatchShahkarJibit.handlerInquiryMatchedShahkar(true, command.Token, _context, cancellationToken);

        }





        public async Task<DBResult> UpdateProfile(UpdateProfileCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            await _IUserContext.Check_Duplicate_Profile(new Check_Duplicate_Profile.Inputs
            {
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                Gender = command.Gender,
                NationalCode = command.NationalCode,
                Token = token,

            }, cancellationToken);
            await jibitInquiry(new JibitInquiryCommand
            {
                BirthDate = command.BirthDate,
                Family = command.Family
                ,
                Name = command.Name,
                NationalCode = command.NationalCode,
                Token = token
            }, _IUserContext, cancellationToken);



            await _IUserContext.Update_Profile(new Update_Profile.Inputs
            {
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                Gender = command.Gender,
                NationalCode = command.NationalCode,
                Token = token,
            }, cancellationToken);
            return new DBResult(new { }, 1);
        }

        public async Task<DBResult> insertClientByCompany(InsertClientByCompanyCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            await _ICompanyContext.Check_Duplicate_CompanyClient(new Check_Duplicate_CompanyClient.Inputs
            {
                BirthDate = command.BirthDate,
                CompanyId = command.CompanyId,
                NationalCode = command.NationalCode,
                Token = token,
                Code = command.Code,
                Family = command.Family,
                Name = command.Name,
                TokenVerify = command.TokenVerify,
                Mobile = command.Mobile,
            }, cancellationToken);

            await jibitInquiry(new JibitInquiryCommand
            {
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                NationalCode = command.NationalCode,
                Token = token
            }, _IUserContext, cancellationToken);

            await _ICompanyContext.Insert_CompanyClient(new Insert_CompanyClient.Inputs
            {
                BirthDate = command.BirthDate,
                CompanyId = command.CompanyId,
                NationalCode = command.NationalCode,
                Token = token,
                Code = command.Code,
                Family = command.Family,
                Name = command.Name,
                TokenVerify = command.TokenVerify,
                Mobile = command.Mobile,
            }, cancellationToken);
            return new DBResult(new { }, 1);
        }

        public async Task<DBResult> checkBasicInformationByAdmin(CheckBasicInformationByAdminCommand command, CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;
            await jibitInquiry(new JibitInquiryCommand
            {
                BirthDate = command.BirthDate,
                Family = command.Family,
                Name = command.Name,
                NationalCode = command.NationalCode,
                Token = token
            }, _IUserContext, cancellationToken);


            return new DBResult(new { }, 1);
        }
    }
}
