﻿using Newtonsoft.Json;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App
{
    public class UserVerifyService : IUserVerifyService
    {
        private readonly IUserContext _IUserContext;
        private readonly ISmsHelper _ISmsHelper;
        private readonly IMailHelper _IMailHelper;
        private readonly ITokenUserService _tokenUserService;
        public UserVerifyService(IUserContext IUserContext, ISmsHelper ISmsHelper, IMailHelper IMailHelper,
            ITokenUserService tokenUserService)
        {
            _IUserContext = IUserContext;
            _ISmsHelper = ISmsHelper;
            _IMailHelper = IMailHelper;
            _tokenUserService = tokenUserService;
        }

        public async Task<DBResult> accept(
AcceptUserVerifyCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IUserContext.Accept_Level_User(new Accept_Level_User.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                ImageId = command.ImageId,
                IsAccept = command.IsAccept,
                UserId = command.UserId,
                UserVerifyingId = command.UserVerifyingId,
                Text = command.Text
            }, cancellationToken);
            if (dbResult.Data != null)
            {

                string acceptStatus = command.IsAccept == true ? "تایید" : "عدم_تایید";
                if (!string.IsNullOrWhiteSpace(dbResult.Data.Email))
                {
                    await _IMailHelper.sendWithTemplatePath(new EmailRequestSendModel
                    {
                        Subject = $"نتیجه احراز هویت",
                        Body = $"مدرک {dbResult.Data.TypeVerifyName} ارسالی از جانب شما توسط کارشناسان {acceptStatus} شد برای کسب اطلاعات بیشتر به پنل کاربری خود مراجعه کنید",
                        Email = dbResult.Data.Email
                    }, cancellationToken);

                }

                if (!string.IsNullOrWhiteSpace(dbResult.Data.Mobile))
                {
                    await _ISmsHelper.sendSMSLockup(new SmsRequestSendModel
                    {
                        Mobile = dbResult.Data.Mobile,
                        Pattern = 61040,
                        Code = dbResult.Data.TypeVerifyName.Replace(" ", "_"),
                        Code2 = acceptStatus
                    }, cancellationToken);
                }

                return new DBResult { Data = new { } };

            }


            return new DBResult();


        }
    }
}
