﻿using Newtonsoft.Json;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Shared.Helpers;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;

namespace Farakonesh.Logic.Services.App
{
    public class WalletService : IWalletService
    {
        private readonly IWalletContext _IWalletContext;
        private readonly ISmsHelper _smsHelper;
        private readonly IMailHelper _mailHelper;
        private readonly ITokenUserService _tokenUserService;
        public WalletService(IWalletContext iWalletContext, IMailHelper mailHelper, ISmsHelper smsHelper
            , ITokenUserService tokenUserService)
        {
            _IWalletContext = iWalletContext;
            _mailHelper = mailHelper;
            _smsHelper = smsHelper;
            _tokenUserService = tokenUserService;
        }


        public async Task<DBResult> updateWalletByAdmin(UpdateWalletByAdminCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IWalletContext.UpdateWallet(new UpdateWallet.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Amount = command.Amount
                 ,
                ResetWallet = command.ResetWallet,
                TransactionType = command.TransactionType,
                UserId = command.UserId,
                WalletId = command.WalletId
            }, cancellationToken);

            if (command.ResetWallet == true)
            {
                return new DBResult(new { }, 0);
            }
            int patternMessage = 61054;
            if (command.TransactionType == 683)
            {
                await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"واریز مبلغ به کیف پول",
                    Body = $"کاربر عزیز مبلغ {command.Amount.moneyFormat()} تومان به کیف پول شما افزوده شد ، جهت مشاهده جزئیات وارد پنل کاربری خود شوید",
                    Email = dbResult.Data.Email
                }, cancellationToken);

            }
            else
            {
                patternMessage = 61055;
                await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
                {
                    Subject = $"کسر از کیف پول شما",
                    Body = $"کاربر عزیز مبلغ {command.Amount.moneyFormat()} تومان از کیف پول شما کسر گردید ، جهت مشاهده جزئیات وارد پنل کاربری خود شوید",
                    Email = dbResult.Data.Email
                }, cancellationToken);
            }
            await _smsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResult.Data.Mobile,
                Pattern = patternMessage,
                Code = command.Amount.moneyFormat()
            }, cancellationToken);


            return new DBResult(new { }, 0);
        }


        public async Task<DBResult> insertCashByAdmin(InsertCashByAdminCommand command, CancellationToken cancellationToken)
        {
            var dbResult = await _IWalletContext.Insert_CashByAdmin(new Insert_CashByAdmin.Inputs
            {
                Token = _tokenUserService.getUserInfo().Token,
                Price = command.Price,
                UserIdCustomer = command.UserIdCustomer
            }, cancellationToken);

            await _mailHelper.sendWithTemplatePath(new EmailRequestSendModel
            {
                Subject = $"ثبت درخواست نقد کردن کیف پول",
                Body = $"کاربر عزیز فراکنش ، یک درخواست نقد کردن کیف پول با مبلغ {command.Price.moneyFormat()} تومان از طرف کارشناسان ما برای شما ثبت شده است ، طی 72 ساعت این مبلغ بصورت ریالی به حساب شما واریز خواهد شد ، جهت مشاهده جزئیات به پنل کاربری خود مراجعه بفرمایید.",
                Email = dbResult.Data.Email
            }, cancellationToken);

            await _smsHelper.sendSMSLockup(new SmsRequestSendModel
            {
                Mobile = dbResult.Data.Mobile,
                Pattern = 61071,
                Code = command.Price.moneyFormat()
            }, cancellationToken);


            return new DBResult(new { }, 0);
        }


    }
}
