﻿using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.CommonOperations;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Shared.Enums;
using System.Threading;

namespace Farakonesh.Logic.Services.App.dbo
{
    public class DasboardService : IDasboardService
    {
        private readonly ISettingContext _settingContext;
        private readonly IAdvertisingContext _advertisingContext;
        private readonly IInboxContext _inboxContext;
        private readonly RedisService _redis;
        private readonly ITokenUserService _tokenUserService;
        public DasboardService(ISettingContext settingContext, RedisService redis,
            IAdvertisingContext advertisingContext, IInboxContext inboxContext,
            ITokenUserService tokenUserService)
        {
            _settingContext = settingContext;
            _redis = redis;
            _advertisingContext = advertisingContext;
            _inboxContext = inboxContext;
            _tokenUserService = tokenUserService;
        }
        public async Task<DBResult> getDashboardContent(CancellationToken cancellationToken)
        {
            string token = _tokenUserService.getUserInfo().Token;

            return new DBResult()
            {
                Data = new
                {
                    DasboardContent = await _settingContext.Get_Setting_Dashboard(new Get_Setting_Dashboard.Inputs { }, cancellationToken)
                ,
                    Advertising = await _advertisingContext.GetAdvertisingList(new GetAdvertisingList.Inputs { }, cancellationToken)
                ,
                    Inbox = await _inboxContext.GetInbox(new GetInbox.Inputs
                    {
                        PageSize = 5,
                        StartIndex = 1,
                        Sort = "",
                        Importance = (int)Importance.Necessary,
                        Token = token
                    }, cancellationToken)

                }
            };

        }
    }
}
