﻿using Farakonesh.Commands.Services.dbo;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.Order;
using Farakonesh.Logic.Database.User;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.keys;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.App.dbo
{
    public class ServiceKeysService : IServiceKeysService
    {
        private readonly ISettingContext _settingContext;
        private readonly IServiceKeysContext _serviceKeysContext;
        private readonly RedisService _redis;
        private readonly ITokenUserService _tokenUserService;
        private readonly IConfiguration _configuration;
        public ServiceKeysService(ISettingContext settingContext, RedisService redis,
            IServiceKeysContext serviceKeysContext,
            ITokenUserService tokenUserService, IConfiguration configuration)
        {
            _settingContext = settingContext;
            _redis = redis;
            _serviceKeysContext = serviceKeysContext;
            _tokenUserService = tokenUserService;
            _configuration = configuration;
        }

        public async Task<DBResult> InsertServiceKeys(InsertServiceKeysByAdminCommand command, CancellationToken cancellationToken)
        {
            if(!string.IsNullOrWhiteSpace(command.AdditionalConfig) && !command.AdditionalConfig.IsValidJson())
            {
                throw new LogicalException("فرمت تنظیمات بیشتر باید جیسون معتبر باشد");
            }
            string token = _tokenUserService.getUserInfo().Token;
            var aesKeyBase64 = _configuration["CryptoSettings:AesKey"];
            var crypto = new CryptoHelper(aesKeyBase64);
            var encryptedApiKey = crypto.EncryptApiKey(command.Key);
            var encryptedPassword = crypto.EncryptApiKey(command.Password);
            await _serviceKeysContext.Insert_ServiceKeysByAdmin(new Insert_ServiceKeysByAdmin.Inputs
            {
                AdditionalConfig = command.AdditionalConfig,
                BaseUrlService = command.BaseUrlService,
                ExpireDate = command.ExpireDate,
                IsActive = command.IsActive,
                LastRequestDate = command.LastRequestDate,
                NumberRequests = command.NumberRequests,
                NumberRequestsMade = command.NumberRequestsMade,
                Username = command.Username,
                Title = command.Title,
                Token = token,
                SortNumber = command.SortNumber,
                ServiceKeyType = command.ServiceKeyType,
                NumberRequestsPerMonth = command.NumberRequestsPerMonth,
                NumberRequestsPerHour = command.NumberRequestsPerHour,
                NumberRequestsPerDay = command.NumberRequestsPerDay,
                ApiKeyHash = encryptedApiKey.hash,
                EncryptionKeyIV = encryptedApiKey.iv,
                EncryptedApiKey = encryptedApiKey.encryptedData,
                EncryptedPassword = encryptedPassword.encryptedData,
                EncryptionPasswordIV = encryptedPassword.iv,
                PasswordHash = encryptedPassword.hash,
                Description = command.Description,
            }, cancellationToken);
            return new DBResult();

        }

        public async Task<DBResult> UpdateServiceKeys(UpdateServiceKeysByAdminCommand command, CancellationToken cancellationToken)
        {
            if (!string.IsNullOrWhiteSpace(command.AdditionalConfig) && !command.AdditionalConfig.IsValidJson())
            {
                throw new LogicalException("فرمت تنظیمات بیشتر باید جیسون معتبر باشد");
            }
            string token = _tokenUserService.getUserInfo().Token;
            var aesKeyBase64 = _configuration["CryptoSettings:AesKey"];
            var crypto = new CryptoHelper(aesKeyBase64);
            var encryptedApiKey = crypto.EncryptApiKey(command.Key);
            var encryptedPassword = crypto.EncryptApiKey(command.Password);
            await _serviceKeysContext.Update_ServiceKeysByAdmin(new Update_ServiceKeysByAdmin.Inputs
            {
                AdditionalConfig = command.AdditionalConfig,
                BaseUrlService = command.BaseUrlService,
                ExpireDate = command.ExpireDate,
                IsActive = command.IsActive,
                LastRequestDate = command.LastRequestDate,
                NumberRequests = command.NumberRequests,
                NumberRequestsMade = command.NumberRequestsMade,
                Username = command.Username,
                Title = command.Title,
                Token = token,
                SortNumber = command.SortNumber,
                ServiceKeyType = command.ServiceKeyType,
                NumberRequestsPerMonth = command.NumberRequestsPerMonth,
                NumberRequestsPerHour = command.NumberRequestsPerHour,
                NumberRequestsPerDay = command.NumberRequestsPerDay,
                ApiKeyHash = encryptedApiKey.hash,
                EncryptionKeyIV = encryptedApiKey.iv,
                EncryptedApiKey = encryptedApiKey.encryptedData,
                EncryptedPassword = encryptedPassword.encryptedData,
                EncryptionPasswordIV = encryptedPassword.iv,
                PasswordHash = encryptedPassword.hash,
                ServiceKeysId = command.ServiceKeysId,
                Description = command.Description,
            }, cancellationToken);
            return new DBResult();

        }
    }
}
