﻿using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Cache
{


    public class RedisInitializerHostedService : IHostedService
    {
        private readonly IServiceScopeFactory _scopeFactory;
        private readonly RedisService _redisService;

        public RedisInitializerHostedService(
            IServiceScopeFactory scopeFactory,
            RedisService redisService)
        {
            _scopeFactory = scopeFactory;
            _redisService = redisService;
        }

        public async Task StartAsync(CancellationToken cancellationToken)
        {

            using var scope = _scopeFactory.CreateScope();
            var settingContext = scope.ServiceProvider.GetRequiredService<ISettingServerContext>();

            var dataSetting = await settingContext.Get_Setting_Server(new Get_Setting_Server.Inputs { }, cancellationToken);
            var externalServerIp = dataSetting?.Data?.ExternalServerIp;
            await _redisService.InitAsync(externalServerIp);

        }

        public Task StopAsync(CancellationToken cancellationToken) => Task.CompletedTask;
    }



}
