﻿using RabbitMQ.Client;
using Farakonesh.Commands.Queue;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IQueue;
using Farakonesh.Models.API.RabbitMQ;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Queue
{
    public class SendCurrencyWareHouseQueue: ISendCurrencyWareHouseQueue
    {
        public async Task sendToQueue(CurrencyWareHouseCommand data)
        {

            var factory = new ConnectionFactory();

            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    channel.ExchangeDeclare("currencywarehouse-send-groups", ExchangeType.Direct, true);
                    channel.QueueDeclare("currencywarehouse-send-groups-queue", true, false, false, null);
                    channel.QueueBind("currencywarehouse-send-groups-queue", "currencywarehouse-send-groups", "send-currencywarehouse");
                 
                        var bytes = Encoding.UTF8.GetBytes(data.ObjToJson());
                        channel.BasicPublish("currencywarehouse-send-groups", "send-currencywarehouse", null, bytes);
                }
            }




        }
    }
}
