﻿using Newtonsoft.Json;
using RabbitMQ.Client;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Queue
{
    public class SendEmailQueue : ISendEmailQueue
    {
        private readonly ILog _log;
        public SendEmailQueue(ILog log)
        {
            _log = log;
        }
        public async Task sendToQueue(List<EmailSendModel> data)
        {

            var factory = new ConnectionFactory();

            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "email-send-groups-queue.dlq" }
            };
                    channel.ExchangeDeclare("email-send-groups", ExchangeType.Direct, true);
                    channel.QueueDeclare("email-send-groups-queue", true, false, false, arguments);
                    channel.QueueBind("email-send-groups-queue", "email-send-groups", "send-email");
                    foreach (var item in data)
                    {
                        var jsonData = item.ObjToJson();
                        var bytes = Encoding.UTF8.GetBytes(jsonData);
                        channel.ConfirmSelect();
                        channel.BasicPublish("email-send-groups", "send-email", null, bytes);
                        if (!channel.WaitForConfirms())
                        {
                            _log.Error("Failed to send email to queue in FarakoneshProject with data: " + jsonData);
                        }
                    }

                }
            }
        }

        public async Task sendToQueueTransAction(EmailSendModel data)
        {

            var factory = new ConnectionFactory();

            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                        var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "email-send-transaction-queue.dlq" }
            };
                        channel.ExchangeDeclare("email-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("email-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("email-send-transaction-queue", "email-send-transaction", "send-email-transaction");

                    var jsonData = data.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("email-send-transaction", "send-email-transaction", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send email to queue in FarakoneshProject with data: " + jsonData);
                    }

                }
            }
        }
    }
}
