﻿using RabbitMQ.Client;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.RabbitMQ;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Queue
{
    /// <summary>
    /// ارسال لیست پیامک ها جهت ارسال به گیرنده در صف
    /// </summary>
    /// نکته: این بخش مورد استفاده قرار نگرفته است ، زیرا سامانه های پیامکی خودشان دارای سرویس ارسال گروهی پیامک می باشند
    public class SendSMSQueue : ISendSMSQueue
    {
        private readonly ILog _log;
        public SendSMSQueue(ILog log)
        {
            _log = log;
        }
        public async Task sendToQueue(List<SMSSendModel> data)
        {

            var factory = new ConnectionFactory();

            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "sms-send-groups-queue.dlq" }
            };
                    channel.ExchangeDeclare("sms-send-groups", ExchangeType.Direct, true);

                    channel.QueueDeclare("sms-send-groups-queue", true, false, false, arguments);
                    channel.QueueBind("sms-send-groups-queue", "sms-send-groups", "send-sms");
                    foreach (var item in data)
                    {
                        var jsonData = item.ObjToJson();
                        var bytes = Encoding.UTF8.GetBytes(jsonData);
                        channel.ConfirmSelect();
                        channel.BasicPublish("sms-send-groups", "send-sms", null, bytes);
                        if (!channel.WaitForConfirms())
                        {
                            _log.Error("Failed to send sms to queue in FarakoneshProject with data: " + jsonData);
                        }
                    }

                }
            }

        }

        public async Task sendToQueueTransAction(SMSSendModel data)
        {

            var factory = new ConnectionFactory();
            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "sms-send-transaction-queue.dlq" }
            };
                    channel.ExchangeDeclare("sms-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("sms-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("sms-send-transaction-queue", "sms-send-transaction", "sms-transaction-send");
                    var jsonData = data.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("sms-send-transaction", "sms-transaction-send", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send sms to queue in FarakoneshProject with data: " + jsonData);
                    }

                }
            }
        }
    }
}
