﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.RabbitMQ;
using RabbitMQ.Client;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Queue
{
   public class SendTTsQueue: ISendTTsQueue
    {
        private readonly ILog _log;
        public SendTTsQueue(ILog log)
        {
            _log = log;
        }
        public async Task sendToQueueTransAction(SMSSendModel data)
        {

            var factory = new ConnectionFactory();
            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "tts-send-transaction-queue.dlq" }
            };
                    channel.ExchangeDeclare("tts-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("tts-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("tts-send-transaction-queue", "tts-send-transaction", "tts-transaction-send");
                    var jsonData = data.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("tts-send-transaction", "tts-transaction-send", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send sms to queue in FarakoneshProject with data: " + jsonData);
                    }

                }
            }
        }
    }
}
