﻿using RabbitMQ.Client;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Models.API.Telegram;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;

namespace Farakonesh.Logic.Services.Queue
{
    public class SendTelegramQueue: ISendTelegramQueue
    {
        private readonly ILog _log;
        private readonly IConfiguration _configuration;
        public SendTelegramQueue(ILog log, IConfiguration configuration)
        {
            _log = log;
            _configuration = configuration;
        }
        public async Task sendToQueueTransAction(TelegramBotModel data)
        {

            var factory = new ConnectionFactory();
            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "telegrambot-send-transaction-queue.dlq" }
            };
                    channel.ExchangeDeclare("telegrambot-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("telegrambot-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("telegrambot-send-transaction-queue", "telegrambot-send-transaction", "telegrambot-transaction-send");
                    var jsonData = data.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("telegrambot-send-transaction", "telegrambot-transaction-send", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send telegrambot to queue in FarakoneshProject with data: " + jsonData);
                    }
                }
            }
        }

        public async Task sendToQueueTransActionWithHostName(TelegramBotModel data)
        {

            var factory = new ConnectionFactory()
            {
                HostName = _configuration.GetSection("RabbitConfigSettingAuxiliaryServer:Ip").Get<string>(),
                Port = _configuration.GetSection("RabbitConfigSettingAuxiliaryServer:Port").Get<int>() ,
                UserName = _configuration.GetSection("RabbitConfigSettingAuxiliaryServer:Username").Get<string>(),
                Password = _configuration.GetSection("RabbitConfigSettingAuxiliaryServer:Password").Get<string>()
            };
            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "telegrambot-send-transaction-queue.dlq" }
            };
                    channel.ExchangeDeclare("telegrambot-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("telegrambot-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("telegrambot-send-transaction-queue", "telegrambot-send-transaction", "telegrambot-transaction-send");
                    var jsonData = data.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("telegrambot-send-transaction", "telegrambot-transaction-send", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send telegrambot to queue in FarakoneshProject with data: " + jsonData);
                    }
                }
            }
        }
    }
}
