﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Models.API.Whatsapp;
using RabbitMQ.Client;
using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.Queue
{
    public class SendWhatsappQueue: ISendWhatsappQueue
    {
        private readonly ILog _log;
        public SendWhatsappQueue(ILog log)
        {
            _log = log;
        }
        public async Task sendToQueueTransAction(SendMessageWhatsappRequestModel data)
        {

            var factory = new ConnectionFactory();
            using (var connection = factory.CreateConnection())
            {
                using (var channel = connection.CreateModel())
                {
                    var arguments = new Dictionary<string, object>
            {
                { "x-dead-letter-exchange", "" },
                { "x-dead-letter-routing-key", "whatsapp-send-transaction-queue.dlq" }
            };
                    channel.ExchangeDeclare("whatsapp-send-transaction", ExchangeType.Direct, true);
                    channel.QueueDeclare("whatsapp-send-transaction-queue", true, false, false, arguments);
                    channel.QueueBind("whatsapp-send-transaction-queue", "whatsapp-send-transaction", "whatsapp-transaction-send");
                    var jsonData = new { receivers = data.Receivers, message = data.Message }.ObjToJson();
                    var bytes = Encoding.UTF8.GetBytes(jsonData);
                    channel.ConfirmSelect();
                    channel.BasicPublish("whatsapp-send-transaction", "whatsapp-transaction-send", null, bytes);
                    if (!channel.WaitForConfirms())
                    {
                        _log.Error("Failed to send whatsapp to queue in FarakoneshProject with data: " + jsonData);
                    }
                }
            }
        }
    }
}
