﻿using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Shared.Enums;
using Microsoft.AspNetCore.DataProtection;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Diagnostics.Metrics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestAnalytics: IHttpRequestAnalytics
    {
        private readonly IRedisContextService _redisContextService;
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestAnalytics(IRedisContextService redisContextService,
            IRestRequestHelper restRequestHelper)
        {
            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;
        }
        public async Task<object> Collect(CollectAnalyticsCommand model, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.GoogleAnalytics,cancellationToken);
            var response = await _restRequestHelper.executeAsync<object>(setting.BaseUrlService+ "Analytics/collect",
                new { clientId = model.ClientId, events = model.Events, measurementId= setting.RealPassword,
                    apiSecret = setting.RealApiKey
                }, Method.Post, cancellationToken, null);
            return response.Data;
        }
    }
}
