﻿using Microsoft.AspNetCore.Mvc.RazorPages;
using RestSharp;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.ArvanCloud;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestArvanCloud : IHttpRequestArvanCloud
    {
        private readonly IRedisContextService _redisContextService;
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestArvanCloud(IRedisContextService redisContextService, IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }

        public async Task<DBResult<ResponseClearCacheArvanCloudModel>> clearCache(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.ArvanCloudCdn,cancellationToken);
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", webServiceInfo.RealApiKey);
            var response = await _restRequestHelper.executeAsync<ResponseClearCacheArvanCloudModel>(webServiceInfo.BaseUrlService + $"cdn/4.0/domains/{setting.SiteUrlRoot.Replace("https://","")}caching/purge", new { purge ="all"}
                ,Method.Post,  cancellationToken, headers);
            if (response != null && response.Data != null && 
                (response.StatusCode == System.Net.HttpStatusCode.OK || response.StatusCode == System.Net.HttpStatusCode.Accepted))
            {
                return new DBResult<ResponseClearCacheArvanCloudModel>(response.Data);
            }

            throw new ExternalServiceException("خطا در حذف کش سی دی ان آروان کلود");
        }

        public async Task<string> getPlaneForInquiry(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.ArvanCloudCdn,cancellationToken);
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", setting.RealApiKey);
            var parameters = new Dictionary<string, string>();
                var response = await _restRequestHelper.executeAsyncGet<ResponseArvanCloudModel>(setting.BaseUrlService + "cdn/4.0/plans", parameters
                ,  cancellationToken, headers);
            if (response != null && response.Data != null && response.Data.data != null)
            {
                foreach (var item in response.Data.data.plans)
                {
                    var plan = item.Value;

                    if (plan.key == setting.Username)
                    {
                        if (plan.needed_balance >= 250000)
                        {
                            return "error-" + "اخطار: اعتبار سرویس سی دی ان آروان کلود روبه پایان است ، جهت جلوگیری از قطعی و اختلال هرچه سریعتر آن را شارژ نمایید";
                        }
                        else
                        {
                            return "success-" + "سرویس سی دی ان آروان کلود پایدار و معتبر است";
                        }
                    }
                }
            }
            return "error-" + "اخطار: ارتباط با سرویس سی دی ان آروان کلود برقرار نشد ، بررسی کنید که مشکلی وجود نداشته باشد";
        }
    }
}
