﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Shared.Exceptions;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Calendar.Pnldev;
using Microsoft.Extensions.Configuration;
using System.Runtime.CompilerServices;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestCalendarPnldev: IHttpRequestCalendarPnldev
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IConfiguration _configuration;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestCalendarPnldev(IRestRequestHelper restRequestHelper,
            IConfiguration configuration,
            IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _configuration = configuration;
            _redisContextService = redisContextService;
        }
        public async Task<CalendarPnldevResponse> getCalendar(string year, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.CalendarPnldev,cancellationToken);
            var parameters = new Dictionary<string, string>();
            parameters.Add("year",year);
            var response = await _restRequestHelper.executeAsyncGet<CalendarPnldevResponse>(webServiceInfo.BaseUrlService, parameters
                , cancellationToken);
            if (response.IsSuccessful && response.Data != null)
            {
                return response.Data;
            }
            throw new ExternalServiceException("خطا در دریافت تقویم");
        }
    }
}
