﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Captcha;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System.Threading;
using Farakonesh.Logic.IServices.ICache;
using Microsoft.Extensions.Configuration;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestCaptcha: IHttpRequestCaptcha
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public HttpRequestCaptcha(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService,
            IHttpContextAccessor httpContextAccessor)
        {
            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;
            _httpContextAccessor = httpContextAccessor;

        }
        public async Task<string> CheckCaptcha(string code, string id, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.CaptchaCombinationPersianEnglishNumbers,cancellationToken);
            if(webServiceInfo == null)
            {
                return "";
            }
            var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
            var url = webServiceInfo.BaseUrlService;
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternal = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider(),localIp);
            if (isExternal)
            {
                url = (string)config["externalServerUrl"];
            }
            var response = await _restRequestHelper.executeAsync<ResponseCaptcha>(url + "Captcha", new { captchaCode = code, captchaId = id }, Method.Put
                , cancellationToken);
            if (response.IsSuccessful)
            {
                if (response.Data.responseType == true)
                {
                    return "";
                }
                throw new ExternalServiceException(response.Data.message);
            }
            throw new ExternalServiceException("کد امنیتی اشتباه است");
        }
    }
}
