﻿using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using RestSharp;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using static System.Runtime.InteropServices.JavaScript.JSType;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestCrawler : IHttpRequestCrawler
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestCrawler(IRestRequestHelper restRequestHelper,
           IRedisContextService redisContextService)
        {
            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;

        }
        /// <summary>
        /// صدا زدن ربات استخراج از وب سایت الان چند
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<string> CallAlanchand(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.BotAlanchand,cancellationToken);

            if (string.IsNullOrWhiteSpace(webServiceInfo.RealApiKey))
            {
                throw new ExternalServiceException("کلید دسترسی الان چند تنظیم نشده است");
            }
            var parameters = new Dictionary<string, string> { { "AccessKey", webServiceInfo.RealApiKey } };
            var response = await _restRequestHelper.executeAsyncGet<object>(webServiceInfo.BaseUrlService + "AlanChandCrawl", parameters
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return "";
            }
            throw new ExternalServiceException("خطا در ارسال درخواست  ربات الان چند");
        }
        /// <summary>
        /// صدا زدن ربات استخراج از وب سایت نوسان
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<string> CallNavasan(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.BotNavasan, cancellationToken);


            if (string.IsNullOrWhiteSpace(webServiceInfo.RealApiKey))
            {
                throw new ExternalServiceException("کلید دسترسی نوسان تنظیم نشده است");
            }
            var parameters = new Dictionary<string, string> { { "AccessKey", webServiceInfo.RealApiKey } };
            var response = await _restRequestHelper.executeAsyncGet<object>(webServiceInfo.BaseUrlService + "NavasanCrawl", parameters
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return "";
            }
            throw new ExternalServiceException("خطا در ارسال درخواست  ربات نوسان");
        }
        /// <summary>
        /// صدا زدن ربات استخراج از وب سایت بن بست
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<string> CallBonbast(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.BotBonBast,cancellationToken);

            if (string.IsNullOrWhiteSpace(webServiceInfo.RealApiKey))
            {
                throw new ExternalServiceException("کلید دسترسی بن بست تنظیم نشده است");
            }
            var parameters = new Dictionary<string, string> { { "AccessKey", webServiceInfo.RealApiKey } };
            var response = await _restRequestHelper.executeAsyncGet<object>(webServiceInfo.BaseUrlService + "BonBastCrawl", parameters
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return "";
            }
            throw new ExternalServiceException("خطا در ارسال درخواست  ربات بن بست");
        }
        /// <summary>
        /// صدا زدن ربات استخراج از وب سایت ایکس ای
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<string> CallXe(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.BotXe, cancellationToken);
            
            if (string.IsNullOrWhiteSpace(webServiceInfo.RealApiKey))
            {
                throw new ExternalServiceException("کلید دسترسی ایکس ای تنظیم نشده است");
            }
            var parameters = new Dictionary<string, string> { { "AccessKey", webServiceInfo.RealApiKey } };
            var response = await _restRequestHelper.executeAsyncGet<object>(webServiceInfo.BaseUrlService + "XeCrawl", parameters
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return "";
            }
            throw new ExternalServiceException("خطا در ارسال درخواست  ربات ایکس ای");
        }
        /// <summary>
        /// صدا زدن ربات استخراج از پنل ایزابل یا همان وویپ
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<string> CallIssabel(HttpRequestIssabelCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.BotVoip, cancellationToken);
  
            if (string.IsNullOrWhiteSpace(webServiceInfo.RealApiKey))
            {
                throw new ExternalServiceException("کلید دسترسی ایزابل تنظیم نشده است");
            }
            var headers = new Dictionary<string, string>();

            var response = await _restRequestHelper.executeAsync<object>(webServiceInfo.BaseUrlService + "Issabel", new
            {
                fromDate = command.FromDate,
                toDate = command.ToDate,
                search = command.Search,
                accessKey = webServiceInfo.RealApiKey
            }
            , Method.Post, cancellationToken, headers);
            if (response.IsSuccessful)
            {
                return "";
            }
            throw new ExternalServiceException("خطا در ارسال درخواست  ربات ایزابل");
        }


    }
}
