﻿using Microsoft.AspNetCore.Http;
using RestSharp;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.API.Email;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestEmail: IHttpRequestEmail
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IHttpContextAccessor _httpContextAccessor;
        private readonly IConfiguration _configuration;
        public HttpRequestEmail(IRestRequestHelper restRequestHelper,
           IHttpContextAccessor httpContextAccessor, IConfiguration configuration)
        {

            _restRequestHelper = restRequestHelper;
            _httpContextAccessor = httpContextAccessor;
            _configuration = configuration;

        }
        public async Task<string> checkEmail(string server, CancellationToken cancellationToken)
        {
            var parameters = new Dictionary<string, string>();
            parameters.Add("ip", _httpContextAccessor.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString());
            var parametersHeader = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsyncGet<string>(server + "check", parameters
                , cancellationToken, parametersHeader);
            if (response.IsSuccessful)
            {
                return response.Data;
            }
            throw new InternalServiceException("خطا در بررسی ایمیل");
        }

        public async Task<string> sendEmail(string server, EmailRequestSendModel model, CancellationToken cancellationToken)
        {
            var parameters = new Dictionary<string, string>();
            parameters.Add("ip", _httpContextAccessor.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString());
            var parametersHeader = new Dictionary<string, string>();
            parametersHeader.Add("key-service", _configuration.GetSection("AccesskeyServiceWorker").Get<string>());
            var response = await _restRequestHelper.executeAsync<string>(server + "send", new { subject = model.Subject, body=model.Body, email=model.Email,ip = _httpContextAccessor.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString() }
                ,Method.Post, cancellationToken, parametersHeader);
            if (response.IsSuccessful)
            {
                return response.Data;
            }
            throw new InternalServiceException("خطا در ارسال ایمیل");
        }
    }
}
