﻿using Microsoft.AspNetCore.Http;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.IpGeoLocation;
using System;
using System.Collections.Generic;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestGeoLocation: IHttpRequestGeoLocation
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestGeoLocation(IRestRequestHelper restRequestHelper)
        {

            _restRequestHelper = restRequestHelper;

        }
        public async Task<ResponseIpGeoLocation> getGeoLocationIp(string server, string accessKey, CancellationToken cancellationToken, string serverAuxiliary = "",
         string accessKeyAuxiliary = "")
        {
            IHttpContextAccessor ctxAccessor = new HttpContextAccessor();
            var ip = ctxAccessor.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString();
            var response = await _restRequestHelper.executeAsyncGet<ResponseIpGeoLocation>(server, new Dictionary<string, string> { { "ip", ip }
                , { "accessKey", accessKey } }
                , cancellationToken);
            if (response != null && response.IsSuccessful && response.Data != null)
            {

                return response.Data;
            }
            else if (response != null && response.StatusCode == HttpStatusCode.Forbidden && response.Data != null)
            {
                if (string.IsNullOrWhiteSpace(accessKeyAuxiliary))
                {
                    var responseAuxiliary = await _restRequestHelper.executeAsyncGet<ResponseIpGeoLocationAuxiliary>(server + ip, new Dictionary<string, string> { }, cancellationToken);
                    if (responseAuxiliary != null && responseAuxiliary.IsSuccessful && responseAuxiliary.Data != null)
                    {
                        return new ResponseIpGeoLocation()
                        {
                            countryCode = responseAuxiliary.Data.countryCode,
                            latitude = responseAuxiliary.Data.lat,
                            longitude = responseAuxiliary.Data.lon,
                            countryName = responseAuxiliary.Data.country
                        };
                    }
                }
                else
                {
                    var responseAuxiliary = await _restRequestHelper.executeAsyncGet<ResponseIpGeoLocation>(serverAuxiliary, new Dictionary<string, string> { { "ip", ip }
                , { "accessKey", accessKeyAuxiliary } }
              , cancellationToken);
                    if (responseAuxiliary != null && responseAuxiliary.IsSuccessful && responseAuxiliary.Data != null)
                    {

                        return responseAuxiliary.Data;
                    }
                }

            }
            throw new ExternalException($"خطا در دریافت موقعیت شما ، لطفا با کارشناسان ما تماس بگیرید");
        }
    }
}
